<?php

namespace App\Http\Controllers\Masomwetu\Sys;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\Sys\User;
use Illuminate\Support\Facades\Hash;
use App\Masomwetu\Sys\SysUserRole; 
class UsersController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the users
        $users = User::all();

        // load the view and pass the users
        return view('Masomwetu.Sys.users.index')
            ->with('users', $users);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/users/create.blade.php)
        $user = new User;
        return view('Masomwetu.Sys.users.create',compact('user'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'name'=>$request->name,
					'email'=>$request->email,
					'email_verified_at'=>$request->email_verified_at,
					'password'=>Hash::make($request->password),
				];
				$rules = [
				'name'=>'required',
					'email'=>'required',
					'email_verified_at'=>'required',
					'password'=>'required',
				];
				\Validator::make($datas,$rules)->validate();
				$user = User::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					$id = $user->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('user',$user);
					return redirect()->back();
				}return redirect()->route('users.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $user = User::findOrFail($id);
				return view('Masomwetu.Sys.users.show',compact('user'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $user = User::findOrFail($id);
				return view('Masomwetu.Sys.users.edit',compact('user'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$user = User::findOrFail($id);
				$datas = [
				'name'=>$request->name,
					'email'=>$request->email,
					'email_verified_at'=>$request->email_verified_at,
					'password'=>Hash::make($request->password),
				];
				$rules = [
				'name'=>'required',
					'email'=>'required',
					'email_verified_at'=>'required',
					'password'=>'required',
				];
				
				\Validator::make($datas,$rules)->validate();
				$user->update($datas);
				my_flash("Modification effectée avec succès");
				return redirect()->route('users.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request, $id)
    {
				// 
        User::destroy($id);
				my_flash("Suppression effectée","danger");
				return redirect()->route('users.index');
    }
}
