<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;

use \App\Masomwetu\Sys\SysUserRole;
use Illuminate\Foundation\Auth\AuthenticatesUsers;

use App\Masomwetu\Sys\Parametre;

use \App\Config;
use \Excel;

use Validator,Rule;

class MobileScanController extends Controller
{
	
    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = '/ms/scan/';

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        // $this->middleware('guest')->except('logout');
    }
		
	public function showLoginForm(){
		return view('scan_mobile.login_scan');//redirect('/');
		
	}
	
	public function scan_presence_agent(){
		return view('scan_mobile.presence_mobile');//redirect('/');
		
	}
	
	public function mobile_scan(Request $request){
		if(!\Auth::user()){
			return redirect('/ms/scan/login/');// "formulaire d'authentification";
		}
		$user_id = \Auth::user()->id;
		$j = date('d');
		$code = "'$user_id'";
		$valuer = null;
		// dd($request);
		// si l'utilisateur active le scan mobile, le champ active porte la date du jour, et la valeur est fixee a null
		if($request->activeScan == 'true' or $request->activeScan === true){
			$p = Parametre::firstOrCreate(['name'=>$code],['active'=>$j]);			
			if($p and $j != $p->active){
				$p->active = $j;
				$p->value = null;
				$p->save();
			}
			return $p;
		}
		// sinon si il souhaite desactiver le scan mobile
		else if($request->activeScan == 'false' or $request->activeScan === false){
			if($p = Parametre::where('name',$code)->first()){
				$p->active = false;
				$p->save();
				return ['message'=>'Scan descativer'];
			}
			else return ['message'=>'Parametre non existant'];
		}
		// sinon si il veut lire la valeur scanee par mobile
		else if($request->getval){
			$p = Parametre::where('name',$code)->where('active',$j)->first();
			if($p and ($valeur = $p->value) !== null){// si une valeur est disponible, on la prend
				$p->value = null; // Puis on annule la valeur
				$p->save();
				return ['value'=>$valeur];
			} 
			return $valuer; // on retourne la valeur qui peut etre null ou autre
		}
		// sinon si il veut lire la valeur scanee par mobile
		else if($request->isScanActive){
			$p = Parametre::where('name',$code)->where('active',$j)->first();
			//dd($p);
			return $p;			
		}
		// si on effectue un scan mobile et que lon souhaite fixer la valeur
		else if($request->setval){
			$p = Parametre::where('name',$code)->first();
			if($p and $j == $p->active){ // si le scan est autorise, on 
				$p->value = $request->setval; // fixe la valeur et on update
				$p->save();	
			}
			else 
				return ['message'=>"ERREUR\nAutorisez le Scan SVP!\nEn cochant la case\n''SCAN PAR MOBILE''"];
			return $p;
		}
		if($request->has('activeScan') or $request->has('getval') or $request->has('setval'));
		
		// si rien de tout ce qui precede n'est valide alors on retourne la vue
		else return view('scan_mobile.mobile_scan');
		
	}
		
	
}
