<?php
namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
class MyDataTableController{

    private $jsTableSelector ;
    private $filter ;
    private $from ;
    private $select ;
    private $urlSearch ;
	private $types = [];
    private $except_create =[] ;
    private $except_liste = [];
    private $except_search = [];
    private $requiredData = [];
    private $except_online_editable_td = ['id'];// liste des champs de la liste a ne pas editer en ligne
	
	private $jsVarDataTable=false;

	public $create_rule = true;
	public $edite_rule = true;
	public $delete_rule = true;
	public $editable_table = false;
	public $session = '';
	public $formAction = '';
	public $formId = '';

	public $delete_url = '';
	public $create_url = '';
	public $before_edition_url = '';
	public $after_edition_url = '';
	public static $isAjaxCall = false;
	
	public $table = false;
	public $defaultInsertedValues = [];
	private $listeButton = []; // la [classe=>icon] pour construire des bouton suplementaire dans la liste

	
    public function create($urlSearch,$from,$fields,$filter=''){
        $this->filter = $filter;
        $this->from = ' FROM '.$from;
        $this->fields = $fields;
        $this->urlSearch = $urlSearch;
        $this->orderBy = '';
		if(count($this->types)==0){
			foreach($this->fields as $k=>$v)
				$this->types[$k] = 'text';
		}
		//if(session('defaultInsertedValues'))
		//	$this->setDefaultInsertedValues(session('defaultInsertedValues'));
    }
	
	public function select_request(Request $request,$select_option_data=false){
		$val = isset($_GET['search'])?trim($_GET['search']['value']):'';
		$cles = str_replace(' ','%', str_replace("'","\'", $val));
		$t = check_field_select_object($this->fields,$this->except_search);
		$fields = $t['fields'];
		$fields_select = $t['fields_select'];
		$fields_object = $t['fields_object'];
		if($this->orderBy == '' and isset($fields_object['t_id']))
			$this->orderBy = ' ORDER BY t.id DESC ';
		if($cles){
			$cles="%$cles%";
			//$t = [];
			//foreach($fields as $k=>$v){
			//	//$t[] = "$k like '$cles'";
			//}
			//$or = '  ('.implode(' or ',$t).') ';
			// $concat = " concat(".implode(",' ',",array_keys($fields)).") like '$cles' ";
			$concat = " concat(ifnull(".implode(",''),' ',ifnull(",array_keys($fields)).",'')) like '$cles' ";
			//$filter =  $or.($this->filter?str_replace('_R_',$cles, $this->filter):'');
			$filter =  $concat.($this->filter?str_replace('_R_',$cles, $this->filter):'');
		}
		else $filter =  1;
		// AJOUTER LES VALEURS PAR DEFAUT AU FILTRE POUR N'AFFICHER QUE LES BON ENREGISTREMENTS
		$defaultVal=" AND (1=1 ";
		if(count($this->defaultInsertedValues)){
			foreach($this->defaultInsertedValues as $k=>$v){
			    $tt = explode('.',$k);
			    if($tt[0]!='t'){
			        $defaultVal.= " AND ( $tt[0].$tt[1] = '$v' or $tt[0].$tt[1] is null) ";
			    }
			    else $defaultVal.= " AND $k = '$v' ";
			}
			
				
		}
		$defaultVal .= " ) ";

		
		$grp = strpos(strtolower($this->from),'group by');
		// si la requete contient un groupe by, la requet de selectAll devra etre du type 
		// select count(*) FROM (...requete normale de l'utilisateur...) AS table_alias
		// et le where doit etre remplace par le having
		// et le nom de l'alias doit venir apres le tout
		$clause_where = $grp?' HAVING ':' WHERE ';

		$selectAll = ' select count(*) as total  '. ($grp?('from (select '.(implode(',',array_keys($fields_select))).$this->from." HAVING 1 $defaultVal"/*.') as tab '*/):$this->from." WHERE 1 $defaultVal");
		//$selectAll = ' select count(*) as total '.$this->from;
		$req = 'select '.(implode(',',array_keys($fields_select))).' '.$this->from.$clause_where.$filter.$defaultVal.' '.$this->orderBy
        .(isset($_GET['start'])?(' limit '.$_GET['start'].','.$_GET['length']):'');   
		$return = [
			'req_count_all'=>$selectAll.($grp?') AS tab ':''),
			'req_count_filter'=>$selectAll .(' AND '). $filter.($grp?') AS tab ':''),
			'req'=>$req,
			'object'=>$fields_object
		];
		//dd($return);
		return $return;     
	}
	
	public function filter(Request $request){
		// composition des requetes
		$tab_reqs = $this->select_request($request);
		
		//dd($tab_reqs);
		$countAllRecords = \DB::select($tab_reqs['req_count_all']);		
		$countFilteredVRecords = \DB::select($tab_reqs['req_count_filter']);
		//\DB::setFetchMode(\PDO::FETCH_NUM);
		$data = \DB::select($tab_reqs['req']);
		$fields_object = $tab_reqs['object'];
		
		//dd($fields_select,$fields);
        $datas=[];
		foreach($data as $lg){
			$t=[];
			foreach($fields_object as $k=>$v)
				$t[] = $k=='-'?'':($lg->$k??'');
			$datas[]=$t;
		}
		//dd($dataOk);
		return array(  
			'draw'                =>     intval($_GET['draw']),  
			'recordsTotal'        =>     $countAllRecords[0]->total,  
			'recordsFiltered'     =>     $countFilteredVRecords[0]->total,  
			'data'                =>     $datas 
	   );
	}

	public function deleteData($id){
		$req = 'DELETE  '.$this->from.' WHERE id='.$id;
		if($id)
		return \DB::select($req);
	}

	public function setFormId($id){
		$this->formId = $id;
	}

	public function setDefaultInsertedValues($defaultInsertedValues=[]){
		foreach($defaultInsertedValues as $k=>$v)
			$this->defaultInsertedValues[$k] = $v;
	}
	
	public function setFields($fields){
		$this->fields = $fields;
	}

	public function getFields(){
		return $this->fields ;
	}
	public function setExceptListe($e){
		$this->except_liste = $e;
	}
	public function setExceptOnlineEditableTd($e){
		$this->except_online_editable_td = $e;
	}
	public function setExceptCreate($e){
		$this->except_create = $e;
	}
	public function setExceptSearch($e){
		$this->except_search = $e;
	}

	// permet de creer des td (du tableau) editable a partir du js
	private function createEditableTds(){
		$editable_tds="";
		// si le numero de la table d'edition a ete indiquee alors on comprend que l'on peut generer des champs editables sauf pour le premier qui est l'id
		//if($this->editable_table){
			$n=0;
			$num_table = $this->editable_table;
			foreach($this->fields as $k=>$v){
				if($k=='id' or $k=='t.id' or in_array($k,$this->except_liste))continue;
				$n++;// incrementer si le champs fait partie de la liste
				$kk = $k;
				$alias='';
				if(strpos($k,'.')){
					$alias = explode('.',$k);
					$kk = $alias[1];
				}
				if(in_array($k,$this->except_online_editable_td)or in_array($kk,$this->except_online_editable_td))continue; // sauter si le champ n'est pas editable
				
				//trouver la table de chaque champs
				if($alias){
					$t = explode(' AS '.$alias[0].' ',$this->from)[0];
					$t = explode(' ',$t);
					$table = $t[count($t)-1];
				}
				else $table = $this->table;

				//$num_table = self::$TABLES[$table];//$this->editable_table;
				if((isset($this->types[$k]) and $this->types[$k]=='img') or (isset($this->types[$kk]) and $this->types[$kk]=='img')){
					$img = "\"<img class='crud_img' src='".asset('storage/'.$table.'/'.$kk). "/\"+data[$n]+\" ' />\"";
					$editable_tds .= "$('td:eq($n)', row).html(".$img.");";
				}
				elseif($table == $this->table AND $this->editable_table) 
					$editable_tds .= "$('td:eq($n)', row).html(".$this->js_editable_lbl("(data[$n]?data[$n]:'-')",$num_table,$kk,"data[0]").");";
			}
		//}
		//	dd($this->types);
		return $editable_tds;
	}

	public function addListeButton($tab){
		$this->listeButton = array_merge($tab,$this->listeButton);
	}
	// cree le bouton de suppression dans la liste
	private function createDeleteButton(){
		$autre_boutton = '';
		if($this->listeButton){
			foreach($this->listeButton as $cl=>$icon)
			$autre_boutton .= "<button type='button' k='\"+data[0]+\"' class='btn btn-default $cl'><i class='fa $icon'></i></button>";
		}
		$str = '';

		//$str = str_replace('	','',str_replace('
		//','',str_replace('"',"'",$str)));
		$cl = str_replace('#','',$this->jsTableSelector);
		$tb = $this->table;
		return 
		(
		$this->delete_rule?
		//"var td = \"<label class='delete-enregistrement text-red' k='\"+data[0]+\"' ><i class='glyphicon glyphicon-trash'></i></label>\";
		//var detail = \"<label class='detail-enregistrement text-blue' k='\"+data[0]+\"' ><i class='glyphicon glyphicon-eye-open'></i></label>\";
		//var detail2 = \"<label class='detail-newpage text-green' k='\"+data[0]+\"' ><i class='fa fa-eye-slash'></i></label>\";
		//"

		"var td = \"<a class='btn btn-social-icon btn-xs'><i class='fa fa-angle-double-right'></i></a>$str\";"
		:"var td = data[0]; "
		).
		"$('td:eq(0)', row).html(td);
		$('td:eq(0)', row).addClass('td-option');
		$('td:eq(0)', row).attr('tb','$tb');
		$('td:eq(0)', row).attr('cl','$cl');
		$('td:eq(0)', row).attr('k',data[0]);
		$('td:eq(0)', row).attr('style','padding: 0;width: 30px;');";
	}
	

	// le code js responsable de la suppression d'une ligne
	private function jsDeleteFunction(){
		$jsClasTableSelector = str_replace('#','.',$this->jsTableSelector);
		$table_lbl = $this->table?getTableComment($this->table)['l']:"DETAILS";
		// suppression d'une ligne
		if($this->delete_url and $this->delete_rule)
			return 		
			"$('body').on('click','$jsClasTableSelector .delete-enregistrement',function(){"
			.	"var id = $(this).attr('k');"
			.	"var url = '$this->delete_url/'+id; "
			.	"if(confirm('Voulez-vous vraiment supprimer cette enregistrement ?')){"
			.		"$.ajax({"
			.			"type: 'POST',"
			.			"url: url,"
			.			"data: {'_token':'".csrf_token()."'},"
			.			"success: function(){"
			.				"$this->jsVarDataTable.ajax.reload();"
			.			"}"
			.		"});"
			.	"}"				
			."});"	
			."$('body').on('click','$jsClasTableSelector .get-data-for-edition',function(){
				var id = $(this).attr('k');
				var url = '$this->before_edition_url/'+id;
				$.ajax({
					type: 'POST',
					url: url,
					data: {'_token':'".csrf_token()."'},
					success: function(result){
						var data = result.data[0];
						console.log(data);
						for(i in data){
							var obj = $('#input-'+i+'-id');
							var selec = $('#input-'+i+'-id-autocomplete-select');
							if(0 != selec.length){
								selec.html('<option selected=selected value=\"'+data[i]+'\"></option>');
								$('#input-'+i+'-id').val(data[i+'_text']);
								$('#input-'+i+'-id').removeClass('no-much');
							}
							else if(0 != obj.length){
								console.log(i,data[i]);
								if(obj.attr('type')=='checkbox')
									$('#input-'+i+'-id').prop('checked',data[i]);
								else if(obj.attr('type')!='file')
									$('#input-'+i+'-id').val(data[i]);
							}
							
						}
						var urll = '$this->after_edition_url/'+id;
						$('#$this->formId-form').attr('action',urll);
						$('#$this->formId-form .modal-header').removeClass('bg-green').addClass('bg-aqua');
						$('#$this->formId-modal').modal('show');
						$('#$this->formId-form .modal-header .modal-title.update').show();
						$('#$this->formId-form .modal-header .modal-title.create').hide();
					}
				});
			});
			$('body').on('click','#$this->formId-add-btn',function(){
				var urll = '$this->create_url';
				$('#$this->formId-form').attr('action',urll);
				$('#$this->formId-form button[type=\"reset\"]').click()
				$('#$this->formId-form .modal-header').removeClass('bg-aqua').addClass('bg-green');
				$('#$this->formId-form .modal-header .modal-title.update').hide();
				$('#$this->formId-form .modal-header .modal-title.create').show();
			});"
			."$('body').on('click','$jsClasTableSelector .detail-enregistrement',function(){"
			.	"var id = $(this).attr('k');"
			.	"var url = '$this->detail_url/$this->session/'+id; "
			.	"$.get(url,function(data){"
			.		"$('#modal-default .modal-body').html(data.detail);$('.box').boxWidget();"
			.		"$('#modal-default').modal('show'); "
			.		"var t=\"<button type='button' class='btn bg-purple btn-flat'>DETAILS</button>\";"
			.		"$('#modal-default .modal-title').html(t +\"$table_lbl\");"
			.	"});"
			."});" 
			."$('body').on('click','$jsClasTableSelector .detail-newpage',function(){"
			.	"var id = $(this).attr('k');"
			.	"var url = '".route('menu.detail.newpage')."/$this->table/$this->session/'+id; "
			.	"window.location = url;"
			."});"
			."$('body').on('click','.table-responsive".($this->table?".$this->table":"")." .relations',function(){"
			.	"var id = $(this).attr('val');"
			.	"var ch = $(this).attr('ch');"
			.	"var tb = $(this).attr('tab');
				var sess = $(this).attr('sess');"
			.	"var url = '".route('data.table.get.relation.detail')."/'+tb+'/'+sess+'/'+ch+'/'+id; "
			.	"$.get(url,function(html){"
			.		"$('#modal-default .modal-body #detail-relation".($this->table?"$this->table":"")."').html(html);"
			.	"});"
			."});";
		elseif($this->delete_rule)
			return "alert('delete url non trouvee!');";
		return "";
	}

	
	
	public function jsTable($jsVarDataTable,$createdRow=''){
		$this->jsVarDataTable = $jsVarDataTable;
		// preparation des champs de suppression et des champs online editable avant tout autre manipulation des donnee de la ligne
		$createdRow = $this->createDeleteButton().$this->createEditableTds().$createdRow;
		$this->detail_url = route('data.table.get.detail',['table'=>$this->table]);
		return 
		//dataTable = $('#liste-eleve-paiement').DataTable({
		$jsVarDataTable.' = $("'.$this->jsTableSelector.'").DataTable({'.
			"
			'ordering': false,
			'processing':true,
			'serverSide':true,
			'lengthMenu': [ [10, 25, 50,100,150, -1], [10, 25, 50,100,150, 'All'] ],
			'pageLength': 50,
			'order':[],
			'ajax':{
				url:'$this->urlSearch',
				type:'GET'
			}
			,
			'createdRow': function( row, data, dataIndex ) {
				$createdRow
			}
	
		});console.log('.$jsVarDataTable.' );".$this->jsDeleteFunction()
		.'
		$(".voir-datatables-parameters").click(function(){
			$(".dataTables_wrapper div.row:first-child,.dataTables_wrapper div.row:last-child").show();
		});'
		;
	}

	public function js_editable_lbl($value_to_show_var,$i_str,$f_str,$k_var="data[0]",$tagHtml='div'){
		return "'<$tagHtml class=\"editable-td\" k=\"'+$k_var+'\" f=\"$f_str\" i=\"$i_str\">'+$value_to_show_var+'</$tagHtml>'";
	}

	public function htmlTable($id,$clas='table table-bordered table-striped table-condensed table-hover editable-table'){
        $this->jsTableSelector = $id?"#$id":(".".str_replace(' ','.',$clas));
		$ths="";
		foreach($this->fields as $k=>$v){
			if(in_array($k,$this->except_liste))continue;
			$ths .= "<th>$v</th>";
		}
		return "<table class='$clas' id='$id'>
		<thead><tr>$ths</tr></thead><tbody></tbody>
		</table>
		";
	}

	public function my_select_2($url,$tab='', $onChange='function(e){}', $attrs=['name'=>'select-1','id'=>'select-1','placeholder'=>'Rechercher...','class'=>'']){
		$name = $attrs['name']??'';
		$class = $attrs['class']??'';
		$id = $attrs['id']??'';
		$placeholder = $attrs['placeholder']??'Rechercher...';
		return 
		'
		<input type="text" id="'.$id.'" autocomplete="off" class="my-select-2 '.$class.'" name="'.$name.'" placeholder="'.$placeholder.'"/>
		
		<script>
		'.$this->js_ready('
			var tab = '.$tab.';
			my_select_2(document.getElementById("'.$id.'"), tab, "'.$url.'",'.$onChange.');
		').'
			
		</script>
		';
	}

	public function setTypes($typ=[]){
		foreach($typ as $k=>$v)
			$this->types[$k] = $v;
	}
	public function resetTypes($t=[]){
		$this->types=$t;
	}
	public function getTypes(){
		return $this->types;
	}
	
	public function getDefaultInsertedValues(){
		$defl = [];
		foreach($this->defaultInsertedValues as $k=>$v){
			$i = strpos(strtoupper($k),'.');
			$defl[substr($k,$i+1)] = $v;
		}
		return $defl;
	}
	
	public $source_ext = [];
	public function get_field_form_table($default=false){
		$_fields=$_required=[];
		$this->source_ext = [];
		if($this->table){			
			$req=' SHOW FULL COLUMNS FROM '.$this->table;
			$tab = \DB::select($req);
			$t2=0;
			$defl = array_keys($this->getDefaultInsertedValues());// les champs ont des alias alors il faut les en detacher			
			//if(count($defl))
			//dd($defl);
			// fin detachement
			foreach($tab as $f){
				$v = $f->Field;
				if($v=='updated_at' )
					continue;
				if(!$default and in_array($v,$defl))
					continue;
				$an = analiser_champ($f);
				//if($v=="st_type_appareil_id")dd($an);
				$type = $an["type"];
				$lbl = $an["lbl"];
				if($an['source']){
					$this->source_ext[$v] = $an['source'];
				}
				$this->setTypes([$v=>$type]);
				$_fields[$v]=$lbl;
				$_required[$v]=$f->Null=='NO'?'required':'';
			}
		}
		
		$this->requiredData = $_required;
		//dd($tab,$this->types,strpos($tab[5]->Type,'endum('));
		return $_fields;
	}
	
	public function create_form_fields($typ=[],$lbl_col=3){
		if(count($typ))
			$this->setTypes($typ);
		$_fields = $this->get_field_form_table();
		//dd($this->requiredData);
		$fields = '';
		$input_col = 12 - $lbl_col;
		//dd($_fields,array_keys($this->defaultInsertedValues));
		foreach($_fields as $k=>$v){
			$input=false;
			$required = $this->requiredData[$k];
			if(in_array($k,$this->except_create))continue;
			$type = $this->types[$k]??'';
			// si le champ fini avec un _id cela veut dire que c'est une cle etrangere
			if( (isset($this->source_ext[$k]) and ($table=$this->source_ext[$k])) or ((substr($k,strlen($k)-3,3)=='_id') and (($table=substr($k,0,strlen($k)-3).'s') and if_table_existe($table) ))){ // si le champ a une relation forte
				$excep['defaultInsVal'] = [] ;
				foreach($this->defaultInsertedValues as $ch=>$val){
    				$t = explode(".",$ch);
    				if(isset($t[1]))
    				    $excep['defaultInsVal'][$t[1]] = $val;
    				else $excep['defaultInsVal'][$t[0]] = $val;
				}
				$profondeur=1;$select_option=true;
				$tab='[]'; $onChange='function(e){}'; 
				$attrs=['name'=>$k,'id'=>"input-$k-id", 'class'=>'form-control'];
				$input = my_select_2('f_'.$k,$table,$excep,
				$profondeur,$select_option,$tab, $onChange, $attrs);
			}
			elseif(strpos($type,'enum(')!== false){
				$type = str_replace('enum(','',$type);
				$type = substr($type,0,strlen($type)-1);
				eval('$tabtyp=['.$type."];");
				$options='<option value="">Chosir '.$v.'</option>';
				foreach($tabtyp as $e)
					$options.='<option value="'.$e.'">'.strtoupper($e).'</option>';
				$input = '<select name="'.$k.'" class="form-control" id="input-'.$k.'-id" >'. 
				$options.'</select>';
			
			}
			elseif($type=='img'){
				$type = 'file';
			}
			//elseif($type=='text')
			//$input = '<textarea '.$required.' name="'.$k.'" class="form-control" id="input-'.$k.'-id" placeholder="'.$v.'"></textarea>';
			$input = $input?$input:('<input type="'.($type).'" '.$required.' name="'.$k.'" '.($type=='checkbox'?'':'class="form-control"').' '.($type=='date'?'value="'.date('Y-m-d').'"':'').' id="input-'.$k.'-id" placeholder="'.$v.'">'.($type == 'file'?'<input type="checkbox" name="update_'.$k.'" title="FORCE LA MISE A JOUR">':''));
			

			$fields .= '<div class="form-group">
			<label for="input-'.$k.'-id" class="col-sm-'.$lbl_col.' control-label">'.$v.($required?' *':'').'</label>

			<div class="col-sm-'.$input_col.'">
			  '.$input.'
			</div>
		  </div>';

		}
		//dd($fields);
		return $fields;
	}
	
	public function create_modal_form($formTitle="TITRE DU FORMULAIRE"){
		$fields = $this->create_form_fields();
		$formAction = $this->formAction;
		$this->create_url = $formAction;
		if(!$this->create_rule)return '';
		return "<form enctype='multipart/form-data' action='$formAction' id='$this->formId-form' class='form-horizontal' method='post'>
				".csrf_field()."
				<div class='modal fade' id='$this->formId-modal'>
				<div class='modal-dialog'>
					<div class='modal-content box'>
						<div class='modal-header'>
							<button type='button' class='close' data-dismiss='modal' aria-label='Close'>
								<span aria-hidden='true'>&times;</span></button>
							<a href='#x' class='text-black' data-dismiss='modal'><i class='fa fa-arrow-left'></i> </a>
     						<h4 style='display: inline;margin-left: 10px;' class='modal-title create'>
							$formTitle</h4>
							<h4 style='display: inline;margin-left: 10px;' class='modal-title update' style='display:none'>MODIFICATION</h4>
						</div>
						<div class='modal-body'>			
							".$fields."
						</div>
						<div class='overlay' style='display:none' id='$this->formId-overlay'>
						<i class='fa fa-refresh fa-spin'></i>
						</div>
						<div class='modal-footer'>
							<div class='alert alert-danger' style='text-align: left;display:none' id='$this->formId-result'>
								<h4><i class='icon fa fa-ban'></i> ERREUR!</h4>
								<p></p>
							</div>
							<button type='reset' class='btn btn-warning pull-left'>VIDER LES CHAMPS</button>
							<button type='submit' class='btn btn-primary'>ENREGISTRER</button>
						</div>
					</div>
				</div>
			</div>
		</form>". 
		'<script>
			if(""=="'.trim($formAction).'")alert("action est vide");
		  '.$this->js_ready($this->ajax_submit()).
	  	'</script>';
	}

	public function ajax_submit(){
		
		return "
		ajax_fomr_submit('#$this->formId-form',
			success_callback=function(data){
				$('#$this->formId-overlay').hide();
				if(data.result=='fail'){					
					$('#$this->formId-result p').html(data.message);
					$('#$this->formId-result').show();
				}
				else {					
					$('#$this->formId-modal').modal('hide'); 
					if('".$this->jsVarDataTable."'!==''){
						eval('var t = $this->jsVarDataTable!==undefined;');
						eval('if(t)$this->jsVarDataTable.ajax.reload();')
					}
				}
			},
			click_callback=function(){
				$('#$this->formId-overlay').show();
				$('#$this->formId-result p').html('');
				$('#$this->formId-result').hide();
			}	
		);";
	}

	
	public function create_form_add_button($text='Ajouter',$tag='a',$class='btn btn-xs btn-default'){
		return '<'.$tag.' type="button" class="'.$class.'" data-toggle="modal"
		id="'.$this->formId.'-add-btn" data-dismisss="modal" 
		data-target="#'.$this->formId.'-modal">
			<i class="fa fa-plus"></i> '.$text.'
		</'.$tag.'>';
	}

	public function box_liste($title,$id,$clas='table table-bordered table-striped table-condensed table-hover editable-table'){
        //$this->jsTableSelector = $id?"$id":".$clas";
		//$this->session = $this->session??$id;
		return '
		<div class="box box-primary box-solid">
			<div class="box-header">
				<h3 class="box-title">'.$title.'</h3>
				'.
				(($this->create_rule and isset($this->formId))?
				($this->create_form_add_button()):"").
			'
			  <div class="box-tools pull-right">
                <button type="button" class="btn btn-box-tool voir-datatables-parameters"><i class="fa fa-cog"></i></button>
                <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
              </div>
			</div>
			<div class="box-body">
				<div class="table-responsive">
					'.$this->htmlTable($id,$clas).'
				</div>
			</div>
		</div>
		<style>
			.dataTables_wrapper div.row:first-child, .dataTables_wrapper div.row:last-child {
				display: none;
			}
		</style>
		<script>
			var '.$this->session.';
			'.$this->js_ready($this->jsTable($this->session)).
		'</script>';
	}

	public function js_ready($code){
		// if(self::$isAjaxCall)dd("ok");
		if(self::$isAjaxCall)return $code;
		return 'document.addEventListener("DOMContentLoaded", function(event) {
			'.$code.'
		});';
	}

	public function setRulesData($tab){
		$this->requiredData = $tab;
	}

	public function dataToSave(Request $request,$dataConstraint,$_types=[]){
		// $collect = collect($this->requiredData);
		$datas = $rules = $champAretirer = [];
		// si on veut retirer certain champs:
		if(isset($dataConstraint['-'])){
			$champAretirer = $dataConstraint['-'];			
		}

		$champAretirer = array_merge($this->except_create,$champAretirer);// on melange avec les autres champs a ne pas creer par defaut

		$champAretirer = collect($champAretirer);// convertir pour pouvior utiliser ->contains() sur la collection

		// Recolte des donnees
		foreach($this->fields as $k=>$v){
			if(!$champAretirer->contains($k)){
				if(isset($_types[$k]) and $_types[$k]=='checkbox')
					$datas[$k] = $request->$k?true:false;
				elseif($k=="password")
					$datas[$k] = Hash::make($request->$k);
				else $datas[$k] = $request->$k;
			}
		}
		// FIXATION DES CONTRAINTE
		/* if(isset($this->requiredData['*'])){ 
			$val = $this->requiredData['*']; 
			foreach($datas as $k=>$lbl){ // on par cours nos champs a inserer
				if(!$champAretirer->contains($k)) // ceux qui ne sont pas a retirer
					$rules[$k] = $val; // on leur applique par defaut cette regle
			}
		} */

		//dd($this->fields,$_types,$datas);
		// on verifie si il existe une regle par defaut (appliquable a tous les champs *)
		$regle_par_defaut = isset($this->requiredData['*'])?$this->requiredData['*']:'';// si il y en a on prends la ou les regle(s)
		// on parcourt maintenant les autres champs afin de leur attribuer chacun sa ou ses regles specifiques
		foreach($datas as $k=>$v){
			if(isset($this->requiredData[$k])  ) // on voit si le champs a une regle propre a lui
				$rules[$k] = $this->requiredData[$k];// si oui on l'applique
			else $rules[$k] = $regle_par_defaut; // si non on applique la regle generale si elle existe
		}
		//dd($champAretirer,$this->fields,$_types,$datas,$rules);
		return compact('datas','rules');
	}

	public function simpleDetail($title,$tab){
		$html = "<table class='table table-condensed table-detail'><caption>$title</caption>";
		foreach($tab as $el){
			$html .= "<tr><th>$el[id]</th><td>$el[text]</td></tr>";
		}
		$html .= "</table>";
		return $html;
	}

	//c
		// $file = '/var/www/html/products/var/session/sess_ciktos8icvk11grtpkj3u610o3';
		// $contents = file_get_contents($file);
		// session_start();
		// session_decode($contents);
		// print_r($_SESSION);


		// @php 
		// 	$formAction = route('datatable.save.data').'/'.'chad';
		// 	$formTitle = "NOUVEL ENREGISTREMENT";
		// 	$formId = 'test-enregistrement';
			
		// 	$listee = my_data_table('chad','agents');
		// 	$listee->setFormId($formId);
		// 	$listee->setExceptCreate(['id','created_at']);
		// 	$champs = $listee->create_form_fields();
		// @endphp

		// {!!$listee->box_liste('LISTE DES AGENTS','test-tests')!!}
		// {!! $listee->create_modal_form($champs,$formAction,$formTitle,$formId) !!}

		// <script>
		// 	document.addEventListener("DOMContentLoaded", function(event) {
		// 	var testDataTable;
		// 	{!!$listee->jsTable('testDataTable')!!}
		// 	{!!$listee->ajax_submit()!!}
		// 	});
		// </script>

}

//if(count($fields_select)<=1){
//	echo "<script>alert('pas de champs option pour $this->table');</script>";
//}
?>