<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use \App\Masomwetu\Scholar\Tuteur;
use \App\Masomwetu\Scholar\Enfant;

use \App\Masomwetu\Scholar\MsEleve;
// use \App\Enfant;
use App\Masomwetu\Payment\MpFrais;
use \App\Masomwetu\Payment\MpFraisClasse;
use App\Masomwetu\School\McFonction;
use App\Http\Controllers\MDisciplinaryController;

use \App\Config;
class ScanController extends Controller
{
	
	public function eleve_en_ordre_avec_frais(Request $request){
		if($request->action=="presence"){
		    $d = new MDisciplinaryController();
		    $r = $d->marquer_presence_eleve($request->id,true);
		    return $r;
		}
		
		$msEleve = MsEleve::with('mpFraisPaiements.mpFraisClasse.mpFrais','msClasse','enfant')->find($request->id);
		if($msEleve){
			$mp_frais_id = $request->mp_frais_id;
			$fr = MpFraisClasse::where('ms_classe_id',$msEleve->ms_classe_id)->where('mp_frais_id',$mp_frais_id)->get()->first();
			if(!$fr){
				
				return compact('msEleve','montant','montant_payer');
			}
			
			$montant_payer = $msEleve->mpFraisPaiements->filter(function($p,$k) use($mp_frais_id){
				return $p->mpFraisClasse->mp_frais_id==$mp_frais_id;
				})->sum('montant_payer');
			$montant = $fr->montant ;
			return compact('msEleve','montant','montant_payer');
		}
		
	}
	
	public function accueil(Request $request){
	    return view('scan_accueil');
	}
	
	public function scan_verification(Request $request){
		$id_annee = Config::getIdAnnee();
		$ecole_id = Config::getEcoleId();
		
		if($request->scan=='presence'){
		    $msEleves = MsEleve::with('enfant','msClasse')
    		->where("ms_annee_scolaire_id",$id_annee)
    		->where('ecole_id',$ecole_id)->where('etat','Actif')->get();
		    $mpFraiss = '-';
		    return view('scan',compact('mpFraiss','msEleves'));
		}
		else {
		    $mpFraiss = MpFrais::with('mpFraisClasses.msClasse')
        		->whereHas('mpFraisClasses',function($q)use($id_annee,$ecole_id){ return $q
        			->whereHas('msClasse',function($q)use($ecole_id){ return $q->where('ecole_id',$ecole_id); })
        			->where('ms_annee_scolaire_id',$id_annee); })
        		->get();
		    return view('scan',compact('mpFraiss'));
		}
		
	}
	
	public function presence_eleve(){
		$id_annee = Config::getIdAnnee();
		$ecole_id = Config::getEcoleId();
		
		
		
		
	}
}
