<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class SmsController extends Controller
{
    // Récupère les SMS non envoyés
    public function getPendingSms(Request $request)
    {
        // 1️⃣ Récupération des SMS non téléchargés et non envoyés
        $reseaux = explode(',', strtolower($request->reseau));
        $nowMinus10 = Carbon::now()->subMinutes(10);
        
        // 🔹 1️⃣ Requête de base (fonction réutilisable)
        $query = function ($connection, $nowMinus10,$reseaux) {
            $r =  DB::connection($connection)
                ->table('mc_sms_ecoles as s')
                ->join('bulletin_ecoles as e', 's.ecole_id', '=', 'e.id')
                ->where(function ($query) use ($nowMinus10) {
                    $query->where(function ($q) {
                            $q->where('s.downloaded', false)
                              ->orWhereNull('s.downloaded');
                        })
                        ->orWhere(function ($q) use ($nowMinus10) {
                            $q->where(function ($q) {
                                    $q->where('s.envoye', false)
                                      ->orWhereNull('s.envoye');
                                })
                                ->where('s.downloaded_at', '<=',DB::raw("DATE_SUB(CONVERT_TZ(NOW(), '+00:00', '+06:00'), INTERVAL 10 MINUTE)"));
                        });
                })
                ->where(function ($q) {
                    $q->where('s.envoye','!=', '1')->orWhereNull('s.envoye');
                })
                // ✅ ICI : filtrer selon les réseaux
                // 🔍 Filtrer selon les réseaux demandés
                ->where(function ($query) use ($reseaux) {
                    foreach ($reseaux as $reseau) {
                        switch ($reseau) {
                            case 'airtel':
                                $query->orWhereIn(DB::raw("SUBSTRING(s.num, 4, 2)"), ['97', '98', '99']);
                                break;
            
                            case 'orange':
                                $query->orWhereIn(DB::raw("SUBSTRING(s.num, 4, 2)"), ['84', '85', '89']);
                                break;
            
                            case 'vodacom':
                                $query->orWhereIn(DB::raw("SUBSTRING(s.num, 4, 2)"), ['81', '82', '83', '86']);
                                break;
            
                            case 'africell':
                                $query->orWhereIn(DB::raw("SUBSTRING(s.num, 4, 2)"), ['90', '91']);
                                break;
                        }
                    }
                })
                ->select(
                    's.id',
                    's.envoye',
                    's.num as phone',
                    's.msg as message',
                    'e.sms_sender as school',
                    DB::raw("'$connection' as source_db")
                );
                
                

                return $r->get();
        };
    
        // 🔹 2️⃣ Récupération des SMS sur les deux connexions
        $smsMysql1 = $query('mysql', $nowMinus10,$reseaux);
        $smsMysql2 = $query('mysql2', $nowMinus10,$reseaux);
    
        // 🔹 3️⃣ Fusion des deux collections
        $mergedSms = $smsMysql1->merge($smsMysql2);
    
        // 🔹 4️⃣ Mise à jour des statuts téléchargés dans chaque base
        
    
        if ($smsMysql1->count() > 0) {
            DB::connection('mysql2')->table('mc_sms_ecoles')->whereIn('id', $smsMysql1->pluck('id'))->update(['downloaded' => true, 'downloaded_at' => now(), ]);
        }
        if ($smsMysql2->count() > 0) {
            DB::connection('mysql2')->table('mc_sms_ecoles')->whereIn('id', $smsMysql2->pluck('id'))->update(['downloaded' => true, 'downloaded_at' => now(), ]);
        }
        // dd($mergedSms,$request->reseau);
        // 🔹 5️⃣ Retour en JSON
        return response()->json($mergedSms->values());

    }

    // Récupère les SMS non envoyés
    public function getTransfertPendingSms($reseaux)
    {
        // 1️⃣ Récupération des SMS non téléchargés et non envoyés
            
        $nowMinus10 = Carbon::now()->subMinutes(10);
    
        // 🔹 1️⃣ Requête de base (fonction réutilisable)
        $query = function ($connection, $nowMinus10,$reseaux) {
            return DB::connection($connection)
                ->table('mc_sms_transferes as s')
                ->where(function ($query) use ($nowMinus10) {
                    $query->where(function ($q) {
                            $q->where('s.downloaded', false)
                              ->orWhereNull('s.downloaded');
                        })
                        ->orWhere(function ($q) use ($nowMinus10) {
                            $q->where(function ($q) {
                                    $q->where('s.envoye', false)
                                      ->orWhereNull('s.envoye');
                                })
                                ->where('s.downloaded_at', '<=', $nowMinus10);
                        });
                })->where(function ($query) use ($reseaux) {
                    foreach ($reseaux as $reseau) {
                        switch ($reseau) {
                            case 'airtel':
                                $query->orWhereIn(DB::raw("SUBSTRING(s.num, 4, 2)"), ['97', '98', '99']);
                                break;
            
                            case 'orange':
                                $query->orWhereIn(DB::raw("SUBSTRING(s.num, 4, 2)"), ['84', '85', '89']);
                                break;
            
                            case 'vodacom':
                                $query->orWhereIn(DB::raw("SUBSTRING(s.num, 4, 2)"), ['81', '82', '83', '86']);
                                break;
            
                            case 'africell':
                                $query->orWhereIn(DB::raw("SUBSTRING(s.num, 4, 2)"), ['90', '91']);
                                break;
                        }
                    }
                })
                ->select(
                    's.id',
                    's.envoye',
                    's.num as phone',
                    's.message',
                    DB::raw("'$connection' as source_db") // ✅ pour savoir d'où vient chaque SMS
                )
                ->get();
        };
    
        // 🔹 2️⃣ Récupération des SMS sur les deux connexions
        $smsMysql1 = $query('mysql', $nowMinus10,$reseaux);
        $smsMysql2 = $query('mysql2', $nowMinus10,$reseaux);
    
        // 🔹 3️⃣ Fusion des deux collections
        $mergedSms = $smsMysql1->merge($smsMysql2);
    
        // 🔹 4️⃣ Mise à jour des statuts téléchargés dans chaque base
        
    
        if ($smsMysql1->count() > 0) {
            DB::connection('mysql2')->table('mc_sms_transferes')->whereIn('id', $smsMysql1->pluck('id'))->update(['downloaded' => true, 'downloaded_at' => now(), ]);
        }
        if ($smsMysql2->count() > 0) {
            DB::connection('mysql2')->table('mc_sms_transferes')->whereIn('id', $smsMysql2->pluck('id'))->update(['downloaded' => true, 'downloaded_at' => now(), ]);
        }
    
        // 🔹 5️⃣ Retour en JSON
        return response()->json($mergedSms->values());

    }

    // Marquer un SMS comme envoyé
    public function deleteTransferedSms(Request $request)
    {
        $conn = $request->source;
        // $sms = DB::connection($conn)->table('mc_sms_transferes')->where('id', $request->id)->first(); 
        if ($conn && $request->id) {
            DB::connection($conn)->table('mc_sms_transferes')->where('id', $request->id)->delete();
            return response()->json(['status' => 'ok']);
        }
        return response()->json(['status' => 'not found'], 404);
    }
    // Marquer un SMS comme envoyé
    public function markAsSent(Request $request)
    {
        $conn = $request->source;
        $sms = DB::connection($conn)->table('mc_sms_ecoles')->where('id', $request->id)->first(); 
        if ($sms) {
            DB::connection($conn)->table('mc_sms_ecoles')->where('id', $request->id)->update(['envoye' => true]);
            return response()->json(['status' => 'ok']);
        }
        return response()->json(['status' => 'not found'], 404);
    }
    // Marquer un SMS comme envoyé 
    // 
    public function requestDatas(Request $request)
    {
        $telephone = $request->input('telephone');
        $code_ecole = $request->input('code_ecole');
        $matricule = $request->input('matricule');
        $req = $request->input('req');
        $transfert = $request->input('transfert');
        $msg="";
        $conn="mysql";
        $ecole = DB::connection($conn)->table('bulletin_ecoles')->where('code_ecole', $code_ecole)->first();
        if(!$ecole){
            $conn="mysql2";
            $ecole = DB::connection($conn)->table('bulletin_ecoles')->where('code_ecole', $code_ecole)->first();
        }
        $sms_sender = "";
        if ($ecole) {
            $ecole_id = $ecole->id;
            if($matricule and $telephone){
                $telephone = preg_replace('/^(\+243|243)/', '0', $telephone);

                $tut = DB::connection($conn)->table('tuteurs')->where('telephone', $telephone)->first();
                $enfant = DB::connection($conn)->table('enfants')->where('matricule', $matricule)->first();
                $annee = DB::connection($conn)->table('bulletin_ms_annee_scolaires')->where('etat', 1)->first();
                
                $el = false;
                if($tut && $enfant)
                    $el = DB::connection($conn)->table('bulletin_ms_eleves')->where('tuteur_id', $tut->id)->where('enfant_id', $enfant->id)->where('ms_annee_scolaire_id', $annee->id)->first();
                
                if($el){
                    $cl = DB::connection($conn)->table('bulletin_ms_classes')->where('id', $el->ms_classe_id)->first();
                    if($req=="DP"){
                        $req = "select payer_le, montant_payer_usd, montant_payer_cdf,num_recu,r.observation, f.frais
            			from mp_frais_paiements partition (p$ecole_id) p 
            			inner join mp_recus partition (p$ecole_id) r on r.id = p.mp_recu_id
            			inner join bulletin_ms_promotions pr on pr.id=$el->ms_promotion_id
            			inner join mp_frais_classes fcl on fcl.id = p.mp_frais_classe_id
            			inner join mp_frais f on f.id = fcl.mp_frais_id
            			where p.ms_eleve_id= $el->id
            			order by p.payer_le desc
            			limit 0,15";
            			$data = DB::connection($conn)->select($req);
            			$dataOk = [];
            			$sms_sender = $ecole->sms_sender?$ecole->sms_sender:$ecole->nom_ecole;
            			$msg="$sms_sender".'\n\n'."DOSSIER DE PAIEMENT".'\n'."$enfant->nom ".($enfant->prenom==$enfant->nom?$enfant->postnom:$enfant->prenom).'\n'."$cl->classe".'\n';
            			foreach($data as $e){
            				$msg.='\n'."LE ".(date("d/m",strtotime($e->payer_le)))." ".$e->frais.($e->montant_payer_cdf?" $e->montant_payer_cdf F":"").($e->montant_payer_usd?" $e->montant_payer_usd $":"");
            			}
            			if(count($data)==0)$msg.='\n'."N'A RIEN PAYE JUSQU'A ALORS";
                    }
                    else if($req=="DC"){
                        $req = "select payer_le, montant_payer_usd, montant_payer_cdf,num_recu,r.observation, f.frais
            			from mp_frais_paiements partition (p$ecole_id) p 
            			inner join mp_recus partition (p$ecole_id) r on r.id = p.mp_recu_id
            			inner join bulletin_ms_promotions pr on pr.id=$el->ms_promotion_id
            			inner join mp_frais_classes fcl on fcl.id = p.mp_frais_classe_id
            			inner join mp_frais f on f.id = fcl.mp_frais_id
            			where p.ms_eleve_id= $el->id
            			order by p.payer_le desc
            			limit 0,15";
            			$data = DB::connection($conn)->select($req);
            			$dataOk = [];
            			$ec = $ecole->sms_sender?$ecole->sms_sender:$ecole->nom_ecole;
            			$msg="$ec\n\nDOSSIER DE PAIEMENT\n$enfant->nom $enfant->prenom\n$cl->classe";
            			foreach($data as $e){
            				$msg.='\n'."LE ".(date("d/m",strtotime($e->payer_le)))." ".$e->frais.($e->montant_payer_cdf?" $e->montant_payer_cdf F":"").($e->montant_payer_usd?" $e->montant_payer_usd $":"");
            			}
            			if(count($data)==0)$msg.='\n'."N'A RIEN PAYE JUSQU'A ALORS";
                    }
                }
                else {
                    
                    if(!$tut)        $msg = "VOTRE NUMERO DE TELEPHONE N'EST RECONNU COMME NUMERO TUTEUR CHEZ-NOUS. VEUILLEZ PASSER A L'ECOLE AFIN DE REGULARISER";
                    else if(!$enfant)$msg = "LE MATRICULE DE L'ENFANT FOURNI N'EST PAS CORRECT";
                    else if(!$el)    $msg = "VOUS N'EST PAS TUTEUR DE L'ENFANT DONT VOUS AVEZ INDIQUE LE CODE, SI OUI ALORS UTILISEZ LE BON MATRICULE SVP";
                }
            }
            if($msg){
                //if($transfert=="oui" ){
                //    $this->transfert_sms($conn,$telephone,$msg);
                //}
                
                //else return response()->json(['status' => 'ok','phone'=>$telephone,'message'=>$msg,'transfert'=>$transfert]);
                $date_sms = date("Y-m-d H:i:s");
                $num = $telephone;$erreur="";$exp = $sms_sender;
                $datas = compact('ecole_id','date_sms','msg','exp','num','erreur');
                DB::connection($conn)->table("mc_sms_ecoles")->insert($datas);
                
                return response()->json(['status' => 'encours','message'=>"reponse enregistrée"]);
            }
        }
        return response()->json(['status' => "'not found' $telephone $code_ecole $matricule $req"], 404);
    }
    
    private function transfert_sms($conn,$num,$message){
        DB::connection($conn)->table('mc_sms_transferes')->insert(compact('message','num')); 
    }
    
    public function getUrlsToSendSms(){
        $urls = [
        "https://ecoles.delardc.com/",
        "https://appli.collegesaintvincent.org/", 
        "https://admin.itsalama.app/"
        ];
        return compact('urls');
    }
    
}