<?php

namespace App\Imports;

use App\Masomwetu\Report\MrCote;
use Maatwebsite\Excel\Concerns\ToModel;

class CoteImport implements ToModel
{
    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
	
	public function __construct($cours,$travaux,$grilleSyn=false){
		$TravauxLBL = ",1ère Période,2ème Période,1er Examen,3ème Période,4ème Période,2ème Examen,5ème Période,6ème Période,3ème Examen";
		$this->TravauxLBL = explode(',',$TravauxLBL);
		$this->mr_cours_id = '';
		$this->cours = '';
		$this->max_periode = 0;
		if($cours){
			$this->mr_cours_id = $cours->id;
			$this->cours = $cours->mrCoursPromotion->intitule_cours;			
			$this->max_periode = $cours->mrCoursPromotion->max_periode;			
		}
		$this->travaux = $travaux;
		$this->travail = $travaux;
		$this->erreur = [];
		$this->grilleSyn = $grilleSyn;
		$this->idCours = [];
		$this->MxCours = [];
		if(!$this->grilleSyn){
			foreach($this->travaux as $t){
				$this->MxCours[$t] = $this->max_periode*($t%3==0?2:1);
			}
		}
		$this->CrCours = [];
		$this->ligne_index=0;
	}
	public function getPeriode(){
		return $this->travail;
	}
	
	public function getErreur(){
		return $this->erreur;
	}
	
    public function save_cote_grille(array $row)
    {
		$index_id = 1;
		if($row[2]=='ID'){
			$this->idCours = $row;
		}
			
		else if($row[$index_id]=='Cours' and $row[2] !='ID' ){
			$this->CrCours = $row;
		}
		else if($row[$index_id]=='Max'){
			$this->MxCours = $row;
			for($i=3;isset($this->MxCours[$i]);$i++)
				$this->MxCours[$i] = (int)$this->MxCours[$i];
		}
		
		else if((int)$row[$index_id]>0 and count($this->idCours)){
			$id_eleve = (int)$row[1];
			$travail = "cote_".$this->travail;
			// dd($this->idCours);
			for($i=3;isset($this->idCours[$i]) and $this->idCours[$i]; $i++){
				$mr_cours_id = (int)($this->idCours[$i]);
				
				$co = (int)$row[$i];
				// dd($co, $this->CrCours);
				if($co > $this->MxCours[$i]){
					$err['num'] = $row[0];
					$err['cote'] = $co.'/'.$this->MxCours[$i];
					$err['cours'] = $this->CrCours[$i];
					$err['travail'] = $this->TravauxLBL[$this->travail];
					$this->erreur[$row[2]][] = $err;
					
				}
				else if($row[$i]!=''){
					$cotes[$travail] = $co;
					$c = MrCote::firstOrCreate(['ms_eleve_id'=>$id_eleve,'mr_cours_id'=>$mr_cours_id],$cotes);
					if( !($c->wasRecentlyCreated) ){
						$c->update($cotes);
					}
				}
			}
		}
		else if($row[$index_id]=='-')
			return false;
		// else dd($row,'cha4',$this->idCours); 
		
	}
	
    public function save_cote(array $row)
    {
		if (!isset($row[0]) OR $row[0]=='') {
			return null;
		}
		$cotes = [];
		foreach( $this->travaux as $i ){
			$j=$i+1;
			$co = (int)$row[$j];
			if($co > $this->MxCours[$i] ){
				$err['num'] = $this->ligne_index;
				$err['cote'] = $co.'/'.$this->MxCours[$i];
				$err['cours'] = $this->cours;
				$err['travail'] = $this->TravauxLBL[$i];
				$this->erreur[$row[1]][] = $err;
			}
			else $cotes["cote_$i"] = $co;
		}
			
		// dd($row,$cotes);
		if(count($cotes)){
			$c = MrCote::firstOrCreate(['ms_eleve_id'=>$row[0],'mr_cours_id'=>$this->mr_cours_id],$cotes);
			if( !($c->wasRecentlyCreated) ){
				$c->update($cotes);
			}
		}
	}
	
    public function model(array $row)
    {
		$this->ligne_index++;
		if($this->grilleSyn){
			
			$this->save_cote_grille($row);
		}
		else $this->save_cote($row);
		
		return null;
    }
		
    /* public function batchSize(): int
    {
        return 1000;
    }
		public function chunkSize(): int
    {
        return 1000;
    } */
}
 