<?php

namespace App\Imports;

use App\Masomwetu\Report\MrCoursPromotion;
use Maatwebsite\Excel\Concerns\ToModel;
// use Illuminate\Support\Facades\Hash;
use Maatwebsite\Excel\Concerns\WithBatchInserts;
use Maatwebsite\Excel\Concerns\WithChunkReading;
use Maatwebsite\Excel\Concerns\WithHeadingRow;

class CoursPromotionImport implements ToModel, WithBatchInserts, WithChunkReading, WithHeadingRow
{
    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
	private $num_row = 0;
	public function __construct($id_promo){
		$this->ms_promotion_id = $id_promo;
	}

    public function model(array $row)
    {
		if(!$row['cours'])return null;
        
		return new MrCoursPromotion([
            'intitule_cours'     => $row['cours'],
            'max_periode'    => $row['max_periode']??0,
            'coter_examen' => $row['coter_examen']??($row['max_periode']==100?0:1),
            'num_bulletin'    => ++$this->num_row,
            'aligner'    => $row['aligner']??1,
            'ms_promotion_id'    => $this->ms_promotion_id,
        ]);
    }
	
    public function batchSize(): int
    {
        return 1000;
    }
		public function chunkSize(): int
    {
        return 1000;
    }
}

