<?php

namespace App\Imports;

use App\Config\MsPromotion;
use Maatwebsite\Excel\Concerns\ToModel;
use App\Masomwetu\Scholar\MsClasse;
use App\Masomwetu\Report\MrCours;
use App\Masomwetu\Report\MrCoursPromotion;
use \App\Masomwetu\Payment\MpFraisPaiement;
use \App\Masomwetu\Payment\MpFrais;
use \App\Masomwetu\Payment\MpRecu;
use \App\Masomwetu\Payment\MpFraisClasse;
use \App\Masomwetu\Scholar\MsEleve;
use \App\Config;

class PaiementImport implements ToModel
{
    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
	
	
	
	function create_recu($ms_eleve_id,$num_recu,$obs=null){
		$num_recu=sprintf('%06.d',$num_recu).'-'.date('m-y');
		$user_id = \Auth::user()->id;
		$datas = [
			'date_recu'=>date('Y-m-d H:i:s'),
				'num_recu'=>$num_recu,
				'ms_eleve_id'=>$ms_eleve_id,
				// 'montant_recu_usd'=>$montant_recu_usd,
				// 'montant_recu_cdf'=>$montant_recu_cdf,
				// 'montant_recu'=>$montant_recu,
				'user_id'=>$user_id,
				'ms_annee_scolaire_id'=>Config::getIdAnnee(),
				'Observation'=>$obs
			];
			$mprecu = MpRecu::create($datas);
			// $mprecu->num_recu = sprintf('%06.d',$mprecu->id).'-'.date('-m-y');
			// $mprecu->save();
			return $mprecu;
	}

    public function model(array $row)
    {
      $montant_usd = (int)$row[8];
      $montant_cdf = (int)$row[7];
	  $id_eleve = (int)$row[1];
	  $num_r = (int)$row[2];
	  $f = trim($row[9]);
      $frais = explode("+", str_replace(" ","", is_numeric($f)?(int)($f):$f ) );
      $cles = explode(",", "tenafep,inscript,polo,combinaison,ecusson,gilet,pul,info,ex");
	  
	  $date = date("Y-m-d");
	  if($d = $row[0]){
		//$date = Carbon/Carbon::instance($row[0]);
		$date = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($d)->format('Y-m-d');
	  }
	  $user_id = \Auth::user()->id;
      //$compte = 1; // $this->trouver_classe_comptable($id_frais_classe, $date ); //
        
		if($frais[0] !=""){
			$return = [];
			foreach($frais as $id_frais){
				$eleve = MsEleve::where('id',$id_eleve)->first();
				if($eleve){
					$frais_apayer = false;
					// on priorise les frais extra
					if(in_array($id_frais,$cles)){
						$frais = MpFrais::where("frais",$id_frais)->first();
						if($frais)
						$frais_apayer = MpFraisClasse::where("ms_classe_id",$eleve->ms_classe_id)->where("mp_frais_id",$frais->id)->first();
					}
					else $frais_apayer = MpFraisClasse::where("ms_classe_id",$eleve->ms_classe_id)->where("mp_frais_id",$id_frais)->first();
					// si le frais existe alors on travail
					//dd($frais_apayer);
					if($frais_apayer)
					{
						$id_frais_classe = $frais_apayer->id;
						
						$result = MpFraisPaiement::groupBy('ms_eleve_id','mp_frais_classe_id')
							->selectRaw('sum(montant_payer) as sum')
							->where('mp_frais_classe_id',$id_frais_classe)
							->where('ms_eleve_id',$eleve->id)
							->get();
						$total_payer = count($result)?$result[0]->sum:0;

						$montant_du_frais = (double)$frais_apayer->montant;
						$compte = $frais_apayer->compte;
						$rest = 0;
						$montant_usd_en_fr = $montant_usd*$frais_apayer->taux;
						$montant_cdf_usd = $montant_cdf + $montant_usd_en_fr;
						$rest_a_payer = $montant_du_frais - $total_payer; // 
						$monnaie = $frais_apayer->montant_usd?'usd':'cdf';

						$taux = $frais_apayer->taux;
						$montants = $this->calculer_montant($montant_cdf,$montant_usd,$montant_du_frais ,$total_payer,$monnaie,$taux);
						//dd($row,$frais,"$montant_cdf,$montant_usd,$montant_du_frais ,$total_payer,$monnaie,$taux,$rest_a_payer",$montants);
						$mp = MpFraisPaiement::create(['ms_eleve_id'=>$id_eleve
						,'mp_frais_classe_id'=>$id_frais_classe
						,'montant_payer'=>$montants['montant']
						,'montant_payer_cdf'=>$montants['montant_cdf']
						,'montant_payer_usd'=>$montants['montant_usd']
						,'payer_le'=>$date
						,'compte_id'=>$compte
						,'user_id'=>$user_id
						,]);
						$rest = $montants['rest'];
						$return[] = $mp;
						$montant_usd -= $montants['montant_usd'];
						$montant_cdf -= $montants['montant_cdf'];
						
					// dd( $montants , $mp,$eleve);
					}
					else{
						
					}
				}
			}
			if(count($return)){
				$recu = $this->create_recu($id_eleve,$num_r);
				foreach($return as $p){
					if($p)$p->update(['mp_recu_id'=>$recu->id]);
				}
			}
			
		}		
		
		return null;
    }

  
	
	private function calculer_montant($montant_cdf,$montant_usd,$montant_du_frais ,$total_payer,$monnaie,$taux){
		$rest = 0;
		$montant_usd_en_fr = $montant_usd*$taux;
		$montant_cdf_usd = $montant_cdf + $montant_usd_en_fr;
		$rest_a_payer = $montant_du_frais - $total_payer; // 

		if($montant_cdf_usd){
			if($montant_cdf_usd > $rest_a_payer){
				$m = $this->deduire_les_montant_a_payer($montant_cdf_usd,$montant_cdf,$montant_usd,$montant_usd_en_fr ,$rest_a_payer,$taux,$monnaie);
				$montant_cdf = $m['montant_cdf'];
				$montant_usd = $m['montant_usd'];
				$rest 		 = $m['rest'];
				$montant 	 = $rest_a_payer;
				$msg="Montant trop grand ".chiffre($montant_cdf_usd)." CDF !!!";
				
			}
			else  $montant = $montant_cdf_usd;					
		}
		else {
			$montant = $rest_a_payer;
			// determiner la monnaie prise en charge
			if($monnaie == 'usd'){
				$montant_usd = (int)($montant / $taux);
				$montant_cdf = $montant - ($montant_usd * $taux);
			}						
			else $montant_cdf = $montant ;
		}
		return compact('montant_cdf','montant_usd','montant','rest');
	}
  
	private function preparer_montant_en_usd($montant_cdf,$montant_usd,$montant_usd_en_fr ,$rest_a_payer,$taux){
		// si l'usd est > au reste_a_payer alors on paye le tout en usd et on recalcule le reste
		if($montant_usd_en_fr >= $rest_a_payer){
			$montant_usd = (int)($rest_a_payer /$taux) ; // on concertie le reste a payer en usd
			$peu = $rest_a_payer % $taux; // ce qui ne peut etre converti en usd (on le prend en cdf)
			$montant_cdf = $peu;
		}
		else { // sinon alors on garde ca premierement et on voit combien rajouter en cdf
			$complement = $rest_a_payer - $montant_usd_en_fr; // donc dans le reste a payer on retire les usd(cdf) et le reste est suppose etre le cdf a rajouter
			// si il y'a des cdf
			if($montant_cdf >= $complement)
				$montant_cdf = $complement;
			else $montant_cdf = $montant_cdf; // sinon on rajouter le tout
		}
		return compact('montant_cdf','montant_usd');
	}

	private function preparer_montant_en_cdf($montant_cdf_usd,$montant_cdf,$montant_usd,$montant_usd_en_fr ,$rest_a_payer,$taux){
		// si le cdf est > au reste_a_payer alors on paye le tout en cdf et on recalcule le reste
		if($montant_cdf >= $rest_a_payer){
			$montant_cdf =  $rest_a_payer ; // on paie directement
			$montant_usd = 0;
		}
		else { // sinon alors on garde ca premierement et on voit combien rajouter en usd
			$complement = $rest_a_payer - $montant_cdf; // donc dans le reste a payer on retire les cdf et le reste est suppose etre converti en usd et rajouter a la somme
			// si il y'a des cdf
			if($montant_usd_en_fr >= $complement){
				$montant_usd = (int)( $complement / $taux);
				$peu = $complement % $taux; // ce qui ne peut etre converti en usd (?????)
				if($peu>0){
					// on doit rappler la fonction en priorisant les usd
					return $this->deduire_les_montant_a_payer($montant_cdf_usd,$montant_cdf,$montant_usd,$montant_usd_en_fr ,$rest_a_payer,$taux,'usd');
				}
			}
			else $montant_usd = $montant_usd; // sinon on rajouter le tout
		}
		return compact('montant_cdf','montant_usd');
	}

	// $frais_apayer->montant_usd
	private function deduire_les_montant_a_payer($montant_cdf_usd,$montant_cdf,$montant_usd,$montant_usd_en_fr ,$rest_a_payer,$taux,$monnaie='usd'){
		// si on doit payer en usd
		if($monnaie=='usd'){
			$r = $this->preparer_montant_en_usd($montant_cdf,$montant_usd,$montant_usd_en_fr ,$rest_a_payer,$taux);
		}
		// et si on doit payer en cdf
		else $r = $this->preparer_montant_en_cdf($montant_cdf_usd,$montant_cdf,$montant_usd,$montant_usd_en_fr ,$rest_a_payer,$taux);
		$r['rest'] = $montant_cdf_usd - $rest_a_payer;
		return $r;
	}
	
    
}
