<?php

namespace App\Masomwetu\Comptabilite;

use Illuminate\Database\Eloquent\Model;
use App\Masomwetu\Comptabilite\CategorieCompte;
use App\Masomwetu\Comptabilite\MouvementCompte; 
use App\Masomwetu\Cash\CashFicheSortie; 
use App\Masomwetu\Payment\MpFraisPaiement; 

class Compte extends Model
{
    //
		protected $guarded = [];
		public $timestamps = true;

		public function categorieCompte(){
			return $this->belongsTo(CategorieCompte::class);
		}

		public function compte(){
			return $this->belongsTo(Compte::class);
		}

		public function compteParent(){
			return $this->belongsTo(Compte::class,'compte_parent_id');
		}

		public function mouvementComptes(){
			return $this->hasMany(MouvementCompte::class);
		}
		
		public function compteFinals(){
			return $this->hasMany(MouvementCpteUtilise::class,'compte_final');
		}
		
		public function compteInitials(){
			return $this->hasMany(MouvementCpteUtilise::class,'compte_initial');
		}

		public function msInscriptions(){
			return $this->hasMany(MsInscription::class);
		}
		
		public function mpFraisPaiements(){
			return $this->hasMany(MpFraisPaiement::class);
		}
		public function cashFicheSorties(){
			return $this->hasMany(CashFicheSortie::class);
		}
}
