<?php
namespace App\Masomwetu\Comptabilite;

use Illuminate\Database\Eloquent\Model;
use App\Masomwetu\Comptabilite\Compte;
use App\Masomwetu\Comptabilite\MouvementCpteUtilise;
use App\Masomwetu\Comptabilite\MouvementComptePiece;
use App\Masomwetu\Cash\CashSuivi;
use App\Masomwetu\Sys\User; 

class MouvementCompte extends Model
{
    //
		protected $guarded = [];
		public $timestamps = true;

		public function compte(){
			return $this->belongsTo(Compte::class);
		}

		public function user(){
			return $this->belongsTo(User::class);
		}

		public function cashSuivis(){
			return $this->hasMany(CashSuivi::class);
		}

		public function mouvementCpteUtilises(){
			return $this->hasMany(MouvementCpteUtilise::class);
		}
		public function mouvementComptePieces(){
			return $this->hasMany(MouvementComptePiece::class);
		}
}
