<?php

namespace App\Masomwetu\Scholar;

use Illuminate\Database\Eloquent\Model;
use App\Masomwetu\School\Section;
use App\Masomwetu\Scholar\MsAnneeScolaire;
use App\Masomwetu\Scholar\MsClasse;
use App\Masomwetu\Scholar\MsInscription;
use App\Masomwetu\Scholar\MsEleve;
use App\Masomwetu\Report\MrCoursPromotion; 

class MsPromotion extends Model
{
    //
		protected $table = "bulletin_ms_promotions";
		protected $guarded = [];
		public $timestamps = true;

		public function section(){
			return $this->belongsTo(Section::class);
		}

		public function msAnneeScolaire(){
			return $this->belongsTo(MsAnneeScolaire::class);
		}

		public function msClasses(){
			return $this->hasMany(MsClasse::class);
		}
		public function msEleves(){
			return $this->hasMany(MsEleve::class);
		}

		public function msInscriptions(){
			return $this->hasMany(MsInscription::class);
		}

		public function mrCoursPromotions(){
			return $this->hasMany(MrCoursPromotion::class);
		}
}
