﻿@extends('Masomwetu.Allocation.materiels.main')

@section('content')


@section('liste-title')
	<i class="fa fa-plus-square left-icon" onclick=" window.location='{{route('materiels.create')}}'; " title="Ajouter un nouvel enregistrement" ></i> 
	
	Il y a ({{$materiels->count()}}) Materiel(s) dans la liste
	<a href="#" title="voir ou cacher des colonnes">
	<i style="display:none" id="btn-fa-eye-slash" onclick="cacher_les_champs()" class="fa fa-fw fa-eye-slash"></i>
	<i id="btn-fa-eye" onclick="voir_les_champs()" class="fa fa-fw fa-eye"></i></a>
@endsection
	<!-- will be used to show any messages -->
	@php display_flash(); @endphp

	<p class="champ-visible" style="display:none"></p>
	<table id="datatable-materiels" class="table table-striped table-bordered">
		<thead>
				<tr>
					
					<th>Nom</th>
					<th>Quantit</th>
					<th>Observation</th>
					<th style="width:30px">Voir</th>
					<th style="width:30px">Modif.</th>
					<th style="width:30px">Supp.</th>
				</tr>
		</thead>
		<tbody>
		@foreach($materiels as $key => $materiel)
			<tr>
					
					<td class='editable-td' k='{{$materiel->id}}' f='materiel' i='73' t='text' >{{ $materiel->materiel }}</td>
					<td class='editable-td' k='{{$materiel->id}}' f='quantite' i='73' t='number' >{{ $materiel->quantite }}</td>
					<td class='editable-td' k='{{$materiel->id}}' f='' i='73' t='text' >{{ $materiel-> }}</td>

						<!-- delete the nerd (uses the destroy method DESTROY /materiels/{id} -->
						<!-- we will add this later since its a little more complicated than the other two buttons -->

				<!-- we will also add show, edit, and delete buttons CrÃ©er -->
				<td>
					<a class="btn btn-small btn-success btn-xs" href="{{ URL::to('materiels/' . $materiel->id) }}">Voir</a>
				</td>
				<td>
					<a class="btn btn-small btn-info btn-xs" href="{{ URL::to('materiels/' . $materiel->id . '/edit') }}">Modif.</a>
				</td>
				<td>								
					<form style="margin: 0;" onsubmit="return confirm('Voulez-vous supprimer ?')" action="{{route('materiels.destroy',$materiel)}}" method="POST">
						{{csrf_field()}}
						{{method_field('DELETE')}}
						<button class="btn btn-small btn-danger btn-xs" type="submit">Supp.</button>
						
					</form>
				</td>
			</tr>
		@endforeach
		</tbody>
	</table>
@endsection


@section('script')
	<script>
	$(function(){
			$("#datatable-materiels").DataTable();
			creer_champ_visible_lable('materiels');
			$(".th_supprimer").click();
			$(".th_voir").click();
			
	});
	</script>
@endsection
