﻿@extends('Masomwetu.Cash.cashsuivis.main')

@section('content')


@section('liste-title')
	<i class="fa fa-plus-square left-icon" onclick=" window.location='{{route('cashsuivis.create')}}'; " title="Ajouter un nouvel enregistrement" ></i> 
	
	Il y a ({{$cashsuivis->count()}}) Suivi Fiche Sortie(s) dans la liste
	<a href="#" title="voir ou cacher des colonnes">
	<i style="display:none" id="btn-fa-eye-slash" onclick="cacher_les_champs()" class="fa fa-fw fa-eye-slash"></i>
	<i id="btn-fa-eye" onclick="voir_les_champs()" class="fa fa-fw fa-eye"></i></a>
@endsection
	<!-- will be used to show any messages -->
	@php display_flash(); @endphp

	<p class="champ-visible" style="display:none"></p>
	<table id="datatable-cashsuivis" class="table table-striped table-bordered">
		<thead>
				<tr>
					
					<th>Fiche Sortie</th>
					<th>Tâche</th>
					<th>Montant</th>
					<th>Dévise</th>
					<th>Date</th>
					<th style="width:30px">Voir</th>
					<th style="width:30px">Modif.</th>
					<th style="width:30px">Supp.</th>
				</tr>
		</thead>
		<tbody>
		@foreach($cashsuivis as $key => $cashsuivi)
			<tr>
					
					<td class='editable-td'  k='{{$cashsuivi->id}}' f='cash_fiche_sortie_id' i='29' t='select' s='CashFicheSortie' >{{ ($cashsuivi->cashFicheSortie->motif??'').' '.($cashsuivi->cashFicheSortie->montant??'') }}</td>
					<td class='editable-td' k='{{$cashsuivi->id}}' f='tache' i='29' t='text' >{{ $cashsuivi->tache }}</td>
					<td class='editable-td' k='{{$cashsuivi->id}}' f='montant' i='29' t='text' >{{ $cashsuivi->montant }}</td>
					<td class='editable-td' k='{{$cashsuivi->id}}' f='devise' i='29' t='text' >{{ $cashsuivi->devise }}</td>
					<td class='editable-td' k='{{$cashsuivi->id}}' f='date_suivi' i='29' t='date' >{{ $cashsuivi->date_suivi }}</td>

						<!-- delete the nerd (uses the destroy method DESTROY /cashsuivis/{id} -->
						<!-- we will add this later since its a little more complicated than the other two buttons -->

				<!-- we will also add show, edit, and delete buttons CrÃ©er -->
				<td>
					<a class="btn btn-small btn-success btn-xs" href="{{ URL::to('cashsuivis/' . $cashsuivi->id) }}">Voir</a>
				</td>
				<td>
					<a class="btn btn-small btn-info btn-xs" href="{{ URL::to('cashsuivis/' . $cashsuivi->id . '/edit') }}">Modif.</a>
				</td>
				<td>								
					<form style="margin: 0;" onsubmit="return confirm('Voulez-vous supprimer ?')" action="{{route('cashsuivis.destroy',$cashsuivi)}}" method="POST">
						{{csrf_field()}}
						{{method_field('DELETE')}}
						<button class="btn btn-small btn-danger btn-xs" type="submit">Supp.</button>
						
					</form>
				</td>
			</tr>
		@endforeach
		</tbody>
	</table>
@endsection


@section('script')
	<script>
	$(function(){
			$("#datatable-cashsuivis").DataTable();
			creer_champ_visible_lable('cashsuivis');
			$(".th_supprimer").click();
			$(".th_voir").click();
			
	});
	</script>
@endsection
