﻿@extends('Masomwetu.Comptabilite.mouvementcomptes.main')

@section('content')


@section('liste-title')
	<i class="fa fa-plus-square left-icon" onclick=" window.location='{{route('mouvementcomptes.create')}}'; " title="Ajouter un nouvel enregistrement" ></i> 
	
	Il y a ({{$mouvementcomptes->count()}}) Mouvement des Comptes(s) dans la liste
	<a href="#" title="voir ou cacher des colonnes">
	<i style="display:none" id="btn-fa-eye-slash" onclick="cacher_les_champs()" class="fa fa-fw fa-eye-slash"></i>
	<i id="btn-fa-eye" onclick="voir_les_champs()" class="fa fa-fw fa-eye"></i></a>
@endsection
	<!-- will be used to show any messages -->
	@php display_flash(); @endphp

	<p class="champ-visible" style="display:none"></p>
	<table id="datatable-mouvementcomptes" class="table table-striped table-bordered">
		<thead>
				<tr>
					
					<th>Compte</th>
					<th>Montant CDF</th>
					<th>Montant USD</th>
					<th>Date</th>
					<th>Utilisateur</th>
					<th>Déjà comptabilisé</th>
					<th style="width:30px">Voir</th>
					<th style="width:30px">Modif.</th>
					<th style="width:30px">Supp.</th>
				</tr>
		</thead>
		<tbody>
		@foreach($mouvementcomptes as $key => $mouvementcompte)
			<tr>
					
					<td class='editable-td'  k='{{$mouvementcompte->id}}' f='compte_id' i='68' t='select' s='Compte' >{{ ($mouvementcompte->compte->imputation??'') }}</td>
					<td class='editable-td' k='{{$mouvementcompte->id}}' f='montant_cdf' i='68' t='text' >{{ $mouvementcompte->montant_cdf }}</td>
					<td class='editable-td' k='{{$mouvementcompte->id}}' f='montant_usd' i='68' t='text' >{{ $mouvementcompte->montant_usd }}</td>
					<td class='editable-td' k='{{$mouvementcompte->id}}' f='date_mouv' i='68' t='date' >{{ $mouvementcompte->date_mouv }}</td>
					<td class='editable-td'  k='{{$mouvementcompte->id}}' f='user_id' i='68' t='select' s='User' >{{ ($mouvementcompte->user->name??'') }}</td>
					<td class='editable-td' k='{{$mouvementcompte->id}}' f='deja_comptabiliser' i='68' t='checkbox' >{{ $mouvementcompte->deja_comptabiliser }}</td>

						<!-- delete the nerd (uses the destroy method DESTROY /mouvementcomptes/{id} -->
						<!-- we will add this later since its a little more complicated than the other two buttons -->

				<!-- we will also add show, edit, and delete buttons CrÃ©er -->
				<td>
					<a class="btn btn-small btn-success btn-xs" href="{{ URL::to('mouvementcomptes/' . $mouvementcompte->id) }}">Voir</a>
				</td>
				<td>
					<a class="btn btn-small btn-info btn-xs" href="{{ URL::to('mouvementcomptes/' . $mouvementcompte->id . '/edit') }}">Modif.</a>
				</td>
				<td>								
					<form style="margin: 0;" onsubmit="return confirm('Voulez-vous supprimer ?')" action="{{route('mouvementcomptes.destroy',$mouvementcompte)}}" method="POST">
						{{csrf_field()}}
						{{method_field('DELETE')}}
						<button class="btn btn-small btn-danger btn-xs" type="submit">Supp.</button>
						
					</form>
				</td>
			</tr>
		@endforeach
		</tbody>
	</table>
@endsection


@section('script')
	<script>
	$(function(){
			$("#datatable-mouvementcomptes").DataTable();
			creer_champ_visible_lable('mouvementcomptes');
			$(".th_supprimer").click();
			$(".th_voir").click();
			
	});
	</script>
@endsection
