﻿@extends('Masomwetu.Disciplinary.absjours.main')

@section('content')


@section('liste-title')
	Il y a ({{$absjours->count()}}) Jour-Ouvert(s) dans la liste
	<a href="#" title="voir ou cacher des colonnes">
	<i style="display:none" id="btn-fa-eye-slash" onclick="cacher_les_champs()" class="fa fa-fw fa-eye-slash"></i>
	<i id="btn-fa-eye" onclick="voir_les_champs()" class="fa fa-fw fa-eye"></i></a>
@endsection
	<!-- will be used to show any messages -->
	@php display_flash(); @endphp

	<p class="champ-visible" style="display:none"></p>
	<table id="datatable-absjours" class="table table-striped table-bordered">
		<thead>
				<tr>
					
					<th>Date</th>
					<th>Commentaire</th>
					<th>Classe</th>
					<th style="width:30px">Voir</th>
					<th style="width:30px">Modif.</th>
					<th style="width:30px">Supp.</th>
				</tr>
		</thead>
		<tbody>
		@foreach($absjours as $key => $absjour)
			<tr>
					
					<td>{{ $absjour->date_jour }}</td>
					<td>{{ $absjour->commentaire }}</td>
					<td>{{ ($absjour->msClasse->classe??'').' '.($absjour->msClasse->msPromotion->promotion??'').' '.($absjour->msClasse->msPromotion->section->nom_sec??'') }}</td>

						<!-- delete the nerd (uses the destroy method DESTROY /absjours/{id} -->
						<!-- we will add this later since its a little more complicated than the other two buttons -->

				<!-- we will also add show, edit, and delete buttons CrÃ©er -->
				<td>
					<a class="btn btn-small btn-success btn-xs" href="{{ URL::to('absjours/' . $absjour->id) }}">Voir</a>
				</td>
				<td>
					<a class="btn btn-small btn-info btn-xs" href="{{ URL::to('absjours/' . $absjour->id . '/edit') }}">Modif.</a>
				</td>
				<td>								
					<form style="margin: 0;" onsubmit="return confirm('Voulez-vous supprimer ?')" action="{{route('absjours.destroy',$absjour)}}" method="POST">
						{{csrf_field()}}
						{{method_field('DELETE')}}
						<button class="btn btn-small btn-danger btn-xs" type="submit">Supp.</button>
						
					</form>
				</td>
			</tr>
		@endforeach
		</tbody>
	</table>
@endsection


@section('script')
	<script>
	$(function(){
			$("#datatable-absjours").DataTable();
			creer_champ_visible_lable('absjours');
			
	});
	</script>
@endsection
