﻿@extends('Masomwetu.Payment.mpfraisclasses.main')

@section('content')


@section('liste-title')
	<i class="fa fa-plus-square left-icon" onclick=" window.location='{{route('mpfraisclasses.create')}}'; " title="Ajouter un nouvel enregistrement" ></i> 
	
	Il y a ({{$mpfraisclasses->count()}}) Frais-Classe(s) dans la liste
	<a href="#" title="voir ou cacher des colonnes">
	<i style="display:none" id="btn-fa-eye-slash" onclick="cacher_les_champs()" class="fa fa-fw fa-eye-slash"></i>
	<i id="btn-fa-eye" onclick="voir_les_champs()" class="fa fa-fw fa-eye"></i></a>
@endsection
	<!-- will be used to show any messages -->
	@php display_flash(); @endphp

	<p class="champ-visible" style="display:none"></p>
	<table id="datatable-mpfraisclasses" class="table table-striped table-bordered">
		<thead>
				<tr>
					
					<th>Frais</th>
					<th>Classe</th>
					<th>Montant</th>
					<th style="width:30px">Voir</th>
					<th style="width:30px">Modif.</th>
					<th style="width:30px">Supp.</th>
				</tr>
		</thead>
		<tbody>
		@foreach($mpfraisclasses as $key => $mpfraisclasse)
			<tr>
					
					<td class='editable-td'  k='{{$mpfraisclasse->id}}' f='mp_frais_id' i='13' t='select' s='MpFrais' >{{ ($mpfraisclasse->mpFrais->frais??'').' '.($mpfraisclasse->mpFrais->devise??'') }}</td>
					<td class='editable-td'  k='{{$mpfraisclasse->id}}' f='ms_classe_id' i='13' t='select' s='MsClasse' >{{ ($mpfraisclasse->msClasse->classe??'').' '.($mpfraisclasse->msClasse->msPromotion->promotion??'').' '.($mpfraisclasse->msClasse->msPromotion->section->nom_sec??'') }}</td>
					<td class='editable-td' k='{{$mpfraisclasse->id}}' f='montant' i='13' t='text' >{{ $mpfraisclasse->montant }}</td>

						<!-- delete the nerd (uses the destroy method DESTROY /mpfraisclasses/{id} -->
						<!-- we will add this later since its a little more complicated than the other two buttons -->

				<!-- we will also add show, edit, and delete buttons CrÃ©er -->
				<td>
					<a class="btn btn-small btn-success btn-xs" href="{{ URL::to('mpfraisclasses/' . $mpfraisclasse->id) }}">Voir</a>
				</td>
				<td>
					<a class="btn btn-small btn-info btn-xs" href="{{ URL::to('mpfraisclasses/' . $mpfraisclasse->id . '/edit') }}">Modif.</a>
				</td>
				<td>								
					<form style="margin: 0;" onsubmit="return confirm('Voulez-vous supprimer ?')" action="{{route('mpfraisclasses.destroy',$mpfraisclasse)}}" method="POST">
						{{csrf_field()}}
						{{method_field('DELETE')}}
						<button class="btn btn-small btn-danger btn-xs" type="submit">Supp.</button>
						
					</form>
				</td>
			</tr>
		@endforeach
		</tbody>
	</table>
@endsection


@section('script')
	<script>
	$(function(){
			$("#datatable-mpfraisclasses").DataTable();
			creer_champ_visible_lable('mpfraisclasses');
			$(".th_supprimer").click();
			$(".th_voir").click();
			
	});
	</script>
@endsection
