﻿@extends('Masomwetu.Payment.mpfraispaiements.main')

@section('content')


@section('liste-title')
	<i class="fa fa-plus-square left-icon" onclick=" window.location='{{route('mpfraispaiements.create')}}'; " title="Ajouter un nouvel enregistrement" ></i> 
	
	Il y a ({{$mpfraispaiements->count()}}) Frais-Paiement(s) dans la liste
	<a href="#" title="voir ou cacher des colonnes">
	<i style="display:none" id="btn-fa-eye-slash" onclick="cacher_les_champs()" class="fa fa-fw fa-eye-slash"></i>
	<i id="btn-fa-eye" onclick="voir_les_champs()" class="fa fa-fw fa-eye"></i></a>
@endsection
	<!-- will be used to show any messages -->
	@php display_flash(); @endphp

	<p class="champ-visible" style="display:none"></p>
	<table id="datatable-mpfraispaiements" class="table table-striped table-bordered">
		<thead>
				<tr>
					
					<th>Elève</th>
					<th>Frais payé</th>
					<th>Montant payé</th>
					<th>Date Paiement</th>
					<th>Montant payé CDF</th>
					<th>Montant payé USD</th>
					<th style="width:30px">Voir</th>
					<th style="width:30px">Modif.</th>
					<th style="width:30px">Supp.</th>
				</tr>
		</thead>
		<tbody>
		@foreach($mpfraispaiements as $key => $mpfraispaiement)
			<tr>
					
					<td class='editable-td'  k='{{$mpfraispaiement->id}}' f='ms_eleve_id' i='14' t='select' s='MsEleve' >{{ ($mpfraispaiement->msEleve->enfant->matricule??'').' '.($mpfraispaiement->msEleve->enfant->nom??'').' '.($mpfraispaiement->msEleve->enfant->postnom??'').' '.($mpfraispaiement->msEleve->enfant->prenom??'').' '.($mpfraispaiement->msEleve->enfant->genre??'').' '.($mpfraispaiement->msEleve->msClasse->classe??'').' '.($mpfraispaiement->msEleve->msClasse->msPromotion->promotion??'').' '.($mpfraispaiement->msEleve->msClasse->msPromotion->section->nom_sec??'') }}</td>
					<td class='editable-td'  k='{{$mpfraispaiement->id}}' f='mp_frais_classe_id' i='14' t='select' s='MpFraisClasse' >{{ ($mpfraispaiement->mpFraisClasse->mpFrais->frais??'').' '.($mpfraispaiement->mpFraisClasse->mpFrais->devise??'').' '.($mpfraispaiement->mpFraisClasse->msClasse->classe??'').' '.($mpfraispaiement->mpFraisClasse->msClasse->msPromotion->promotion??'').' '.($mpfraispaiement->mpFraisClasse->msClasse->msPromotion->section->nom_sec??'').' '.($mpfraispaiement->mpFraisClasse->montant??'') }}</td>
					<td class='editable-td' k='{{$mpfraispaiement->id}}' f='montant_payer' i='14' t='text' >{{ $mpfraispaiement->montant_payer }}</td>
					<td class='editable-td' k='{{$mpfraispaiement->id}}' f='payer_le' i='14' t='date' >{{ $mpfraispaiement->payer_le }}</td>
					<td class='editable-td' k='{{$mpfraispaiement->id}}' f='montant_payer_cdf' i='14' t='text' >{{ $mpfraispaiement->montant_payer_cdf }}</td>
					<td class='editable-td' k='{{$mpfraispaiement->id}}' f='montant_payer_usd' i='14' t='text' >{{ $mpfraispaiement->montant_payer_usd }}</td>

						<!-- delete the nerd (uses the destroy method DESTROY /mpfraispaiements/{id} -->
						<!-- we will add this later since its a little more complicated than the other two buttons -->

				<!-- we will also add show, edit, and delete buttons CrÃ©er -->
				<td>
					<a class="btn btn-small btn-success btn-xs" href="{{ URL::to('mpfraispaiements/' . $mpfraispaiement->id) }}">Voir</a>
				</td>
				<td>
					<a class="btn btn-small btn-info btn-xs" href="{{ URL::to('mpfraispaiements/' . $mpfraispaiement->id . '/edit') }}">Modif.</a>
				</td>
				<td>								
					<form style="margin: 0;" onsubmit="return confirm('Voulez-vous supprimer ?')" action="{{route('mpfraispaiements.destroy',$mpfraispaiement)}}" method="POST">
						{{csrf_field()}}
						{{method_field('DELETE')}}
						<button class="btn btn-small btn-danger btn-xs" type="submit">Supp.</button>
						
					</form>
				</td>
			</tr>
		@endforeach
		</tbody>
	</table>
@endsection


@section('script')
	<script>
	$(function(){
			$("#datatable-mpfraispaiements").DataTable();
			creer_champ_visible_lable('mpfraispaiements');
			$(".th_supprimer").click();
			$(".th_voir").click();
			
	});
	</script>
@endsection
