﻿@extends('Masomwetu.Presence.jourouvrables.main')

@section('content')


@section('liste-title')
	<i class="fa fa-plus-square left-icon" onclick=" window.location='{{route('jourouvrables.create')}}'; " title="Ajouter un nouvel enregistrement" ></i> 
	
	Il y a ({{$jourouvrables->count()}}) Jour Ouvrable(s) dans la liste
	<a href="#" title="voir ou cacher des colonnes">
	<i style="display:none" id="btn-fa-eye-slash" onclick="cacher_les_champs()" class="fa fa-fw fa-eye-slash"></i>
	<i id="btn-fa-eye" onclick="voir_les_champs()" class="fa fa-fw fa-eye"></i></a>
@endsection
	<!-- will be used to show any messages -->
	@php display_flash(); @endphp

	<p class="champ-visible" style="display:none"></p>
	<table id="datatable-jourouvrables" class="table table-striped table-bordered">
		<thead>
				<tr>
					
					<th>Date</th>
					<th>Heure arrivée</th>
					<th>Heure sortie</th>
					<th style="width:30px">Voir</th>
					<th style="width:30px">Modif.</th>
					<th style="width:30px">Supp.</th>
				</tr>
		</thead>
		<tbody>
		@foreach($jourouvrables as $key => $jourouvrable)
			<tr>
					
					<td class='editable-td' k='{{$jourouvrable->id}}' f='jour_ouvert' i='61' t='date' >{{ $jourouvrable->jour_ouvert }}</td>
					<td class='editable-td' k='{{$jourouvrable->id}}' f='heure_arrivee' i='61' t='text' >{{ $jourouvrable->heure_arrivee }}</td>
					<td class='editable-td' k='{{$jourouvrable->id}}' f='heure_sortie' i='61' t='text' >{{ $jourouvrable->heure_sortie }}</td>

						<!-- delete the nerd (uses the destroy method DESTROY /jourouvrables/{id} -->
						<!-- we will add this later since its a little more complicated than the other two buttons -->

				<!-- we will also add show, edit, and delete buttons CrÃ©er -->
				<td>
					<a class="btn btn-small btn-success btn-xs" href="{{ URL::to('jourouvrables/' . $jourouvrable->id) }}">Voir</a>
				</td>
				<td>
					<a class="btn btn-small btn-info btn-xs" href="{{ URL::to('jourouvrables/' . $jourouvrable->id . '/edit') }}">Modif.</a>
				</td>
				<td>								
					<form style="margin: 0;" onsubmit="return confirm('Voulez-vous supprimer ?')" action="{{route('jourouvrables.destroy',$jourouvrable)}}" method="POST">
						{{csrf_field()}}
						{{method_field('DELETE')}}
						<button class="btn btn-small btn-danger btn-xs" type="submit">Supp.</button>
						
					</form>
				</td>
			</tr>
		@endforeach
		</tbody>
	</table>
@endsection


@section('script')
	<script>
	$(function(){
			$("#datatable-jourouvrables").DataTable();
			creer_champ_visible_lable('jourouvrables');
			$(".th_supprimer").click();
			$(".th_voir").click();
			
	});
	</script>
@endsection
