﻿@extends('Masomwetu.Report.mrcotemodifiees.main')

@section('content')


@section('liste-title')
	<i class="fa fa-plus-square left-icon" onclick=" window.location='{{route('mrcotemodifiees.create')}}'; " title="Ajouter un nouvel enregistrement" ></i> 
	
	Il y a ({{$mrcotemodifiees->count()}}) Cote-Modifiée(s) dans la liste
	<a href="#" title="voir ou cacher des colonnes">
	<i style="display:none" id="btn-fa-eye-slash" onclick="cacher_les_champs()" class="fa fa-fw fa-eye-slash"></i>
	<i id="btn-fa-eye" onclick="voir_les_champs()" class="fa fa-fw fa-eye"></i></a>
@endsection
	<!-- will be used to show any messages -->
	@php display_flash(); @endphp

	<p class="champ-visible" style="display:none"></p>
	<table id="datatable-mrcotemodifiees" class="table table-striped table-bordered">
		<thead>
				<tr>
					
					<th>Cote</th>
					<th>Travail(Pér-Ex)</th>
					<th>Ex-Cote</th>
					<th>Nouvelle-Cote</th>
					<th>Date</th>
					<th>Personnel</th>
					<th style="width:30px">Voir</th>
					<th style="width:30px">Modif.</th>
					<th style="width:30px">Supp.</th>
				</tr>
		</thead>
		<tbody>
		@foreach($mrcotemodifiees as $key => $mrcotemodifiee)
			<tr>
					
					<td class='editable-td'  k='{{$mrcotemodifiee->id}}' f='mr_cote_id' i='41' t='select' s='MrCote' >{{ ($mrcotemodifiee->mrCote->msEleve->enfant->matricule??'').' '.($mrcotemodifiee->mrCote->msEleve->enfant->nom??'').' '.($mrcotemodifiee->mrCote->msEleve->enfant->postnom??'').' '.($mrcotemodifiee->mrCote->msEleve->enfant->prenom??'').' '.($mrcotemodifiee->mrCote->msEleve->enfant->genre??'').' '.($mrcotemodifiee->mrCote->msEleve->msClasse->classe??'').' '.($mrcotemodifiee->mrCote->msEleve->msClasse->msPromotion->promotion??'').' '.($mrcotemodifiee->mrCote->msEleve->msClasse->msPromotion->section_id??'').' '.($mrcotemodifiee->mrCote->mrCours->mrCoursPromotion->intitule_cours??'').' '.($mrcotemodifiee->mrCote->mrCours->mrCoursPromotion->msPromotion->promotion??'').' '.($mrcotemodifiee->mrCote->mrCours->mrCoursPromotion->msPromotion->section_id??'').' '.($mrcotemodifiee->mrCote->mrCours->msClasse->classe??'').' '.($mrcotemodifiee->mrCote->mrCours->msClasse->msPromotion->promotion??'').' '.($mrcotemodifiee->mrCote->mrCours->msClasse->msPromotion->section_id??'').' '.($mrcotemodifiee->mrCote->mrCours->enseignant->agent->personnel_id??'').' '.($mrcotemodifiee->mrCote->mrCours->enseignant->agent->mc_fonction_id??'') }}</td>
					<td class='editable-td' k='{{$mrcotemodifiee->id}}' f='travail' i='41' t='text' >{{ $mrcotemodifiee->travail }}</td>
					<td class='editable-td' k='{{$mrcotemodifiee->id}}' f='old_cote' i='41' t='number' >{{ $mrcotemodifiee->old_cote }}</td>
					<td class='editable-td' k='{{$mrcotemodifiee->id}}' f='new_cote' i='41' t='number' >{{ $mrcotemodifiee->new_cote }}</td>
					<td class='editable-td' k='{{$mrcotemodifiee->id}}' f='date_modif' i='41' t='date' >{{ $mrcotemodifiee->date_modif }}</td>
					<td class='editable-td'  k='{{$mrcotemodifiee->id}}' f='personnel_id' i='41' t='select' s='Personnel' >{{ ($mrcotemodifiee->personnel->noms??'') }}</td>

						<!-- delete the nerd (uses the destroy method DESTROY /mrcotemodifiees/{id} -->
						<!-- we will add this later since its a little more complicated than the other two buttons -->

				<!-- we will also add show, edit, and delete buttons CrÃ©er -->
				<td>
					<a class="btn btn-small btn-success btn-xs" href="{{ URL::to('mrcotemodifiees/' . $mrcotemodifiee->id) }}">Voir</a>
				</td>
				<td>
					<a class="btn btn-small btn-info btn-xs" href="{{ URL::to('mrcotemodifiees/' . $mrcotemodifiee->id . '/edit') }}">Modif.</a>
				</td>
				<td>								
					<form style="margin: 0;" onsubmit="return confirm('Voulez-vous supprimer ?')" action="{{route('mrcotemodifiees.destroy',$mrcotemodifiee)}}" method="POST">
						{{csrf_field()}}
						{{method_field('DELETE')}}
						<button class="btn btn-small btn-danger btn-xs" type="submit">Supp.</button>
						
					</form>
				</td>
			</tr>
		@endforeach
		</tbody>
	</table>
@endsection


@section('script')
	<script>
	$(function(){
			$("#datatable-mrcotemodifiees").DataTable();
			creer_champ_visible_lable('mrcotemodifiees');
			$(".th_supprimer").click();
			$(".th_voir").click();
			
	});
	</script>
@endsection
