﻿@extends('Masomwetu.Report.mrgroupecourss.main')

@section('content')


@section('liste-title')
	<i class="fa fa-plus-square left-icon" onclick=" window.location='{{route('mrgroupecourss.create')}}'; " title="Ajouter un nouvel enregistrement" ></i> 
	
	Il y a ({{$mrgroupecourss->count()}}) Groupe-Corus(s) dans la liste
	<a href="#" title="voir ou cacher des colonnes">
	<i style="display:none" id="btn-fa-eye-slash" onclick="cacher_les_champs()" class="fa fa-fw fa-eye-slash"></i>
	<i id="btn-fa-eye" onclick="voir_les_champs()" class="fa fa-fw fa-eye"></i></a>
@endsection
	<!-- will be used to show any messages -->
	@php display_flash(); @endphp

	<p class="champ-visible" style="display:none"></p>
	<table id="datatable-mrgroupecourss" class="table table-striped table-bordered">
		<thead>
				<tr>
					
					<th>Groupe</th>
					<th>Num-Groupe</th>
					<th style="width:30px">Voir</th>
					<th style="width:30px">Modif.</th>
					<th style="width:30px">Supp.</th>
				</tr>
		</thead>
		<tbody>
		@foreach($mrgroupecourss as $key => $mrgroupecours)
			<tr>
					
					<td class='editable-td' k='{{$mrgroupecours->id}}' f='groupe' i='38' t='text' >{{ $mrgroupecours->groupe }}</td>
					<td class='editable-td' k='{{$mrgroupecours->id}}' f='num_groupe' i='38' t='number' >{{ $mrgroupecours->num_groupe }}</td>

						<!-- delete the nerd (uses the destroy method DESTROY /mrgroupecourss/{id} -->
						<!-- we will add this later since its a little more complicated than the other two buttons -->

				<!-- we will also add show, edit, and delete buttons CrÃ©er -->
				<td>
					<a class="btn btn-small btn-success btn-xs" href="{{ URL::to('mrgroupecourss/' . $mrgroupecours->id) }}">Voir</a>
				</td>
				<td>
					<a class="btn btn-small btn-info btn-xs" href="{{ URL::to('mrgroupecourss/' . $mrgroupecours->id . '/edit') }}">Modif.</a>
				</td>
				<td>								
					<form style="margin: 0;" onsubmit="return confirm('Voulez-vous supprimer ?')" action="{{route('mrgroupecourss.destroy',$mrgroupecours)}}" method="POST">
						{{csrf_field()}}
						{{method_field('DELETE')}}
						<button class="btn btn-small btn-danger btn-xs" type="submit">Supp.</button>
						
					</form>
				</td>
			</tr>
		@endforeach
		</tbody>
	</table>
@endsection


@section('script')
	<script>
	$(function(){
			$("#datatable-mrgroupecourss").DataTable();
			creer_champ_visible_lable('mrgroupecourss');
			$(".th_supprimer").click();
			$(".th_voir").click();
			
	});
	</script>
@endsection
