﻿@extends('Masomwetu.Salary.sarubriquecategoriebulletins.main')

@section('content')


@section('liste-title')
	<i class="fa fa-plus-square left-icon" onclick=" window.location='{{route('sarubriquecategoriebulletins.create')}}'; " title="Ajouter un nouvel enregistrement" ></i> 
	
	Il y a ({{$sarubriquecategoriebulletins->count()}}) Rubrique de catégorie de bulletin(s) dans la liste
	<a href="#" title="voir ou cacher des colonnes">
	<i style="display:none" id="btn-fa-eye-slash" onclick="cacher_les_champs()" class="fa fa-fw fa-eye-slash"></i>
	<i id="btn-fa-eye" onclick="voir_les_champs()" class="fa fa-fw fa-eye"></i></a>
@endsection
	<!-- will be used to show any messages -->
	@php display_flash(); @endphp

	<p class="champ-visible" style="display:none"></p>
	<table id="datatable-sarubriquecategoriebulletins" class="table table-striped table-bordered">
		<thead>
				<tr>
					
					<th>Catégorie du bulletin</th>
					<th>Rubrique de paie</th>
					<th>Montant de base</th>
					<th>Nombre par défaut</th>
					<th>Actif</th>
					<th style="width:30px">Voir</th>
					<th style="width:30px">Modif.</th>
					<th style="width:30px">Supp.</th>
				</tr>
		</thead>
		<tbody>
		@foreach($sarubriquecategoriebulletins as $key => $sarubriquecategoriebulletin)
			<tr>
					
					<td class='editable-td'  k='{{$sarubriquecategoriebulletin->id}}' f='sa_categorie_bulletin_id' i='49' t='select' s='SaCategorieBulletin' >{{ ($sarubriquecategoriebulletin->saCategorieBulletin->libelle??'').' '.($sarubriquecategoriebulletin->saCategorieBulletin->montant_sal_brute??'') }}</td>
					<td class='editable-td'  k='{{$sarubriquecategoriebulletin->id}}' f='sa_rubrique_paie_id' i='49' t='select' s='SaRubriquePaie' >{{ ($sarubriquecategoriebulletin->saRubriquePaie->libelle??'') }}</td>
					<td class='editable-td' k='{{$sarubriquecategoriebulletin->id}}' f='montant_de_base' i='49' t='number' >{{ $sarubriquecategoriebulletin->montant_de_base }}</td>
					<td class='editable-td' k='{{$sarubriquecategoriebulletin->id}}' f='qte_par_defaut' i='49' t='checkbox' >{{ $sarubriquecategoriebulletin->qte_par_defaut }}</td>
					<td class='editable-td' k='{{$sarubriquecategoriebulletin->id}}' f='actif' i='49' t='text' >{{ $sarubriquecategoriebulletin->actif }}</td>

						<!-- delete the nerd (uses the destroy method DESTROY /sarubriquecategoriebulletins/{id} -->
						<!-- we will add this later since its a little more complicated than the other two buttons -->

				<!-- we will also add show, edit, and delete buttons CrÃ©er -->
				<td>
					<a class="btn btn-small btn-success btn-xs" href="{{ URL::to('sarubriquecategoriebulletins/' . $sarubriquecategoriebulletin->id) }}">Voir</a>
				</td>
				<td>
					<a class="btn btn-small btn-info btn-xs" href="{{ URL::to('sarubriquecategoriebulletins/' . $sarubriquecategoriebulletin->id . '/edit') }}">Modif.</a>
				</td>
				<td>								
					<form style="margin: 0;" onsubmit="return confirm('Voulez-vous supprimer ?')" action="{{route('sarubriquecategoriebulletins.destroy',$sarubriquecategoriebulletin)}}" method="POST">
						{{csrf_field()}}
						{{method_field('DELETE')}}
						<button class="btn btn-small btn-danger btn-xs" type="submit">Supp.</button>
						
					</form>
				</td>
			</tr>
		@endforeach
		</tbody>
	</table>
@endsection


@section('script')
	<script>
	$(function(){
			$("#datatable-sarubriquecategoriebulletins").DataTable();
			creer_champ_visible_lable('sarubriquecategoriebulletins');
			$(".th_supprimer").click();
			$(".th_voir").click();
			
	});
	</script>
@endsection
