﻿@extends('Masomwetu.Schedule.scheures.main')

@section('content')


@section('liste-title')
	<i class="fa fa-plus-square left-icon" onclick=" window.location='{{route('scheures.create')}}'; " title="Ajouter un nouvel enregistrement" ></i> 
	
	Il y a ({{$scheures->count()}}) Les heures(s) dans la liste
	<a href="#" title="voir ou cacher des colonnes">
	<i style="display:none" id="btn-fa-eye-slash" onclick="cacher_les_champs()" class="fa fa-fw fa-eye-slash"></i>
	<i id="btn-fa-eye" onclick="voir_les_champs()" class="fa fa-fw fa-eye"></i></a>
@endsection
	<!-- will be used to show any messages -->
	@php display_flash(); @endphp

	<p class="champ-visible" style="display:none"></p>
	<table id="datatable-scheures" class="table table-striped table-bordered">
		<thead>
				<tr>
					
					<th>Jour</th>
					<th>Num.</th>
					<th>Num. Jour</th>
					<th style="width:30px">Voir</th>
					<th style="width:30px">Modif.</th>
					<th style="width:30px">Supp.</th>
				</tr>
		</thead>
		<tbody>
		@foreach($scheures as $key => $scheure)
			<tr>
					
					<td class='editable-td' k='{{$scheure->id}}' f='jour' i='43' t='text' >{{ $scheure->jour }}</td>
					<td class='editable-td' k='{{$scheure->id}}' f='num' i='43' t='number' >{{ $scheure->num }}</td>
					<td class='editable-td' k='{{$scheure->id}}' f='num_jr' i='43' t='number' >{{ $scheure->num_jr }}</td>

						<!-- delete the nerd (uses the destroy method DESTROY /scheures/{id} -->
						<!-- we will add this later since its a little more complicated than the other two buttons -->

				<!-- we will also add show, edit, and delete buttons CrÃ©er -->
				<td>
					<a class="btn btn-small btn-success btn-xs" href="{{ URL::to('scheures/' . $scheure->id) }}">Voir</a>
				</td>
				<td>
					<a class="btn btn-small btn-info btn-xs" href="{{ URL::to('scheures/' . $scheure->id . '/edit') }}">Modif.</a>
				</td>
				<td>								
					<form style="margin: 0;" onsubmit="return confirm('Voulez-vous supprimer ?')" action="{{route('scheures.destroy',$scheure)}}" method="POST">
						{{csrf_field()}}
						{{method_field('DELETE')}}
						<button class="btn btn-small btn-danger btn-xs" type="submit">Supp.</button>
						
					</form>
				</td>
			</tr>
		@endforeach
		</tbody>
	</table>
@endsection


@section('script')
	<script>
	$(function(){
			$("#datatable-scheures").DataTable();
			creer_champ_visible_lable('scheures');
			$(".th_supprimer").click();
			$(".th_voir").click();
			
	});
	</script>
@endsection
