﻿@extends('Masomwetu.Scholar.enfants.main')

@section('content')


@section('liste-title')
	<i class="fa fa-plus-square left-icon" onclick=" window.location='{{route('enfants.create')}}'; " title="Ajouter un nouvel enregistrement" ></i> 
	
	Il y a ({{$enfants->count()}}) Enfant(s) dans la liste
	<a href="#" title="voir ou cacher des colonnes">
	<i style="display:none" id="btn-fa-eye-slash" onclick="cacher_les_champs()" class="fa fa-fw fa-eye-slash"></i>
	<i id="btn-fa-eye" onclick="voir_les_champs()" class="fa fa-fw fa-eye"></i></a>
@endsection
	<!-- will be used to show any messages -->
	@php display_flash(); @endphp

	<p class="champ-visible" style="display:none"></p>
	<table id="datatable-enfants" class="table table-striped table-bordered">
		<thead>
				<tr>
					
					<th>Matricule</th>
					<th>Nom</th>
					<th>Post-Nom</th>
					<th>Prénom</th>
					<th>Genre</th>
					<th>Date de Naissance</th>
					<th>Lieu de Naissance</th>
					<th>Parents</th>
					<th style="width:30px">Voir</th>
					<th style="width:30px">Modif.</th>
					<th style="width:30px">Supp.</th>
				</tr>
		</thead>
		<tbody>
		@foreach($enfants as $key => $enfant)
			<tr>
					
					<td class='editable-td' k='{{$enfant->id}}' f='matricule' i='1' t='text' >{{ $enfant->matricule }}</td>
					<td class='editable-td' k='{{$enfant->id}}' f='nom' i='1' t='text' >{{ $enfant->nom }}</td>
					<td class='editable-td' k='{{$enfant->id}}' f='postnom' i='1' t='text' >{{ $enfant->postnom }}</td>
					<td class='editable-td' k='{{$enfant->id}}' f='prenom' i='1' t='text' >{{ $enfant->prenom }}</td>
					<td class='editable-td' k='{{$enfant->id}}' f='genre' i='1' t='text' >{{ $enfant->genre }}</td>
					<td class='editable-td' k='{{$enfant->id}}' f='datenaiss' i='1' t='date' >{{ $enfant->datenaiss }}</td>
					<td class='editable-td' k='{{$enfant->id}}' f='lieunaiss' i='1' t='text' >{{ $enfant->lieunaiss }}</td>
					<td class='editable-td'  k='{{$enfant->id}}' f='parent_enfant_id' i='1' t='select' s='ParentEnfant' >{{ ($enfant->parentEnfant->papa??'').' '.($enfant->parentEnfant->maman??'') }}</td>

						<!-- delete the nerd (uses the destroy method DESTROY /enfants/{id} -->
						<!-- we will add this later since its a little more complicated than the other two buttons -->

				<!-- we will also add show, edit, and delete buttons CrÃ©er -->
				<td>
					<a class="btn btn-small btn-success btn-xs" href="{{ URL::to('enfants/' . $enfant->id) }}">Voir</a>
				</td>
				<td>
					<a class="btn btn-small btn-info btn-xs" href="{{ URL::to('enfants/' . $enfant->id . '/edit') }}">Modif.</a>
				</td>
				<td>								
					<form style="margin: 0;" onsubmit="return confirm('Voulez-vous supprimer ?')" action="{{route('enfants.destroy',$enfant)}}" method="POST">
						{{csrf_field()}}
						{{method_field('DELETE')}}
						<button class="btn btn-small btn-danger btn-xs" type="submit">Supp.</button>
						
					</form>
				</td>
			</tr>
		@endforeach
		</tbody>
	</table>
@endsection


@section('script')
	<script>
	$(function(){
			$("#datatable-enfants").DataTable();
			creer_champ_visible_lable('enfants');
			$(".th_supprimer").click();
			$(".th_voir").click();
			
	});
	</script>
@endsection
