﻿@extends('Masomwetu.Scholar.msanneescolaires.main')

@section('content')


@section('liste-title')
	<i class="fa fa-plus-square left-icon" onclick=" window.location='{{route('msanneescolaires.create')}}'; " title="Ajouter un nouvel enregistrement" ></i> 
	
	Il y a ({{$msanneescolaires->count()}}) Année-Scolaire(s) dans la liste
	<a href="#" title="voir ou cacher des colonnes">
	<i style="display:none" id="btn-fa-eye-slash" onclick="cacher_les_champs()" class="fa fa-fw fa-eye-slash"></i>
	<i id="btn-fa-eye" onclick="voir_les_champs()" class="fa fa-fw fa-eye"></i></a>
@endsection
	<!-- will be used to show any messages -->
	@php display_flash(); @endphp

	<p class="champ-visible" style="display:none"></p>
	<table id="datatable-msanneescolaires" class="table table-striped table-bordered">
		<thead>
				<tr>
					
					<th>Année</th>
					<th>Ecole</th>
					<th>Etat</th>
					<th>Adresse</th>
					<th>Téléphone</th>
					<th>E-mail</th>
					<th style="width:30px">Voir</th>
					<th style="width:30px">Modif.</th>
					<th style="width:30px">Supp.</th>
				</tr>
		</thead>
		<tbody>
		@foreach($msanneescolaires as $key => $msanneescolaire)
			<tr>
					
					<td class='editable-td' k='{{$msanneescolaire->id}}' f='annee' i='9' t='text' >{{ $msanneescolaire->annee }}</td>
					<td class='editable-td'  k='{{$msanneescolaire->id}}' f='ecole_id' i='9' t='select' s='Ecole' >{{ ($msanneescolaire->ecole->nom_ecole??'') }}</td>
					<td class='editable-td' k='{{$msanneescolaire->id}}' f='etat' i='9' t='checkbox' >{{ $msanneescolaire->etat }}</td>
					<td class='editable-td' k='{{$msanneescolaire->id}}' f='adresse_ecole' i='9' t='text' >{{ $msanneescolaire->adresse_ecole }}</td>
					<td class='editable-td' k='{{$msanneescolaire->id}}' f='tel_ecole' i='9' t='text' >{{ $msanneescolaire->tel_ecole }}</td>
					<td class='editable-td' k='{{$msanneescolaire->id}}' f='email' i='9' t='text' >{{ $msanneescolaire->email }}</td>

						<!-- delete the nerd (uses the destroy method DESTROY /msanneescolaires/{id} -->
						<!-- we will add this later since its a little more complicated than the other two buttons -->

				<!-- we will also add show, edit, and delete buttons CrÃ©er -->
				<td>
					<a class="btn btn-small btn-success btn-xs" href="{{ URL::to('msanneescolaires/' . $msanneescolaire->id) }}">Voir</a>
				</td>
				<td>
					<a class="btn btn-small btn-info btn-xs" href="{{ URL::to('msanneescolaires/' . $msanneescolaire->id . '/edit') }}">Modif.</a>
				</td>
				<td>								
					<form style="margin: 0;" onsubmit="return confirm('Voulez-vous supprimer ?')" action="{{route('msanneescolaires.destroy',$msanneescolaire)}}" method="POST">
						{{csrf_field()}}
						{{method_field('DELETE')}}
						<button class="btn btn-small btn-danger btn-xs" type="submit">Supp.</button>
						
					</form>
				</td>
			</tr>
		@endforeach
		</tbody>
	</table>
@endsection


@section('script')
	<script>
	$(function(){
			$("#datatable-msanneescolaires").DataTable();
			creer_champ_visible_lable('msanneescolaires');
			$(".th_supprimer").click();
			$(".th_voir").click();
			
	});
	</script>
@endsection
