﻿@extends('Masomwetu.Scholar.msinscriptions.main')

@section('content')


@section('liste-title')
	<i class="fa fa-plus-square left-icon" onclick=" window.location='{{route('msinscriptions.create')}}'; " title="Ajouter un nouvel enregistrement" ></i> 
	
	Il y a ({{$msinscriptions->count()}}) Inscription(s) dans la liste
	<a href="#" title="voir ou cacher des colonnes">
	<i style="display:none" id="btn-fa-eye-slash" onclick="cacher_les_champs()" class="fa fa-fw fa-eye-slash"></i>
	<i id="btn-fa-eye" onclick="voir_les_champs()" class="fa fa-fw fa-eye"></i></a>
@endsection
	<!-- will be used to show any messages -->
	@php display_flash(); @endphp

	<p class="champ-visible" style="display:none"></p>
	<table id="datatable-msinscriptions" class="table table-striped table-bordered">
		<thead>
				<tr>
					
					<th>Noms</th>
					<th>Promotion</th>
					<th>Date Inscription</th>
					<th>Montant Payé</th>
					<th>Tuteur/Tutrice</th>
					<th>Déjà classé(e) ?</th>
					<th style="width:30px">Voir</th>
					<th style="width:30px">Modif.</th>
					<th style="width:30px">Supp.</th>
				</tr>
		</thead>
		<tbody>
		@foreach($msinscriptions as $key => $msinscription)
			<tr>
					
					<td class='editable-td'  k='{{$msinscription->id}}' f='enfant_id' i='10' t='select' s='Enfant' >{{ ($msinscription->enfant->matricule??'').' '.($msinscription->enfant->nom??'').' '.($msinscription->enfant->postnom??'').' '.($msinscription->enfant->prenom??'').' '.($msinscription->enfant->genre??'') }}</td>
					<td class='editable-td'  k='{{$msinscription->id}}' f='ms_promotion_id' i='10' t='select' s='MsPromotion' >{{ ($msinscription->msPromotion->promotion??'').' '.($msinscription->msPromotion->section->nom_sec??'') }}</td>
					<td class='editable-td' k='{{$msinscription->id}}' f='inscrit_le' i='10' t='date' >{{ $msinscription->inscrit_le }}</td>
					<td class='editable-td' k='{{$msinscription->id}}' f='montant' i='10' t='text' >{{ $msinscription->montant }}</td>
					<td class='editable-td'  k='{{$msinscription->id}}' f='tuteur_id' i='10' t='select' s='Tuteur' >{{ ($msinscription->tuteur->nom_tuteur??'').' '.($msinscription->tuteur->telephone??'') }}</td>
					<td class='editable-td' k='{{$msinscription->id}}' f='classer' i='10' t='checkbox' >{{ $msinscription->classer }}</td>

						<!-- delete the nerd (uses the destroy method DESTROY /msinscriptions/{id} -->
						<!-- we will add this later since its a little more complicated than the other two buttons -->

				<!-- we will also add show, edit, and delete buttons CrÃ©er -->
				<td>
					<a class="btn btn-small btn-success btn-xs" href="{{ URL::to('msinscriptions/' . $msinscription->id) }}">Voir</a>
				</td>
				<td>
					<a class="btn btn-small btn-info btn-xs" href="{{ URL::to('msinscriptions/' . $msinscription->id . '/edit') }}">Modif.</a>
				</td>
				<td>								
					<form style="margin: 0;" onsubmit="return confirm('Voulez-vous supprimer ?')" action="{{route('msinscriptions.destroy',$msinscription)}}" method="POST">
						{{csrf_field()}}
						{{method_field('DELETE')}}
						<button class="btn btn-small btn-danger btn-xs" type="submit">Supp.</button>
						
					</form>
				</td>
			</tr>
		@endforeach
		</tbody>
	</table>
@endsection


@section('script')
	<script>
	$(function(){
			$("#datatable-msinscriptions").DataTable();
			creer_champ_visible_lable('msinscriptions');
			$(".th_supprimer").click();
			$(".th_voir").click();
			
	});
	</script>
@endsection
