﻿@extends('Masomwetu.Scholar.mspromotions.main')

@section('content')


@section('liste-title')
	<i class="fa fa-plus-square left-icon" onclick=" window.location='{{route('mspromotions.create')}}'; " title="Ajouter un nouvel enregistrement" ></i> 
	
	Il y a ({{$mspromotions->count()}}) Promotion(s) dans la liste
	<a href="#" title="voir ou cacher des colonnes">
	<i style="display:none" id="btn-fa-eye-slash" onclick="cacher_les_champs()" class="fa fa-fw fa-eye-slash"></i>
	<i id="btn-fa-eye" onclick="voir_les_champs()" class="fa fa-fw fa-eye"></i></a>
@endsection
	<!-- will be used to show any messages -->
	@php display_flash(); @endphp

	<p class="champ-visible" style="display:none"></p>
	<table id="datatable-mspromotions" class="table table-striped table-bordered">
		<thead>
				<tr>
					
					<th>Promotion</th>
					<th>Section</th>
					<th>Niveau</th>
					<th>Option</th>
					<th>Frais d'inscription</th>
					<th>Contraintes</th>
					<th>Année Scolaire</th>
					<th style="width:30px">Voir</th>
					<th style="width:30px">Modif.</th>
					<th style="width:30px">Supp.</th>
				</tr>
		</thead>
		<tbody>
		@foreach($mspromotions as $key => $mspromotion)
			<tr>
					
					<td class='editable-td' k='{{$mspromotion->id}}' f='promotion' i='5' t='text' >{{ $mspromotion->promotion }}</td>
					<td class='editable-td'  k='{{$mspromotion->id}}' f='section_id' i='5' t='select' s='Section' >{{ ($mspromotion->section->nom_sec??'') }}</td>
					<td class='editable-td' k='{{$mspromotion->id}}' f='niveau' i='5' t='number' >{{ $mspromotion->niveau }}</td>
					<td class='editable-td' k='{{$mspromotion->id}}' f='option' i='5' t='text' >{{ $mspromotion->option }}</td>
					<td class='editable-td' k='{{$mspromotion->id}}' f='frais_inscription' i='5' t='number' >{{ $mspromotion->frais_inscription }}</td>
					<td class='editable-td' k='{{$mspromotion->id}}' f='contrainte' i='5' t='text' >{{ $mspromotion->contrainte }}</td>
					<td class='editable-td'  k='{{$mspromotion->id}}' f='ms_annee_scolaire_id' i='5' t='select' s='MsAnneeScolaire' >{{ ($mspromotion->msAnneeScolaire->annee??'').' '.($mspromotion->msAnneeScolaire->ecole->nom_ecole??'') }}</td>

						<!-- delete the nerd (uses the destroy method DESTROY /mspromotions/{id} -->
						<!-- we will add this later since its a little more complicated than the other two buttons -->

				<!-- we will also add show, edit, and delete buttons CrÃ©er -->
				<td>
					<a class="btn btn-small btn-success btn-xs" href="{{ URL::to('mspromotions/' . $mspromotion->id) }}">Voir</a>
				</td>
				<td>
					<a class="btn btn-small btn-info btn-xs" href="{{ URL::to('mspromotions/' . $mspromotion->id . '/edit') }}">Modif.</a>
				</td>
				<td>								
					<form style="margin: 0;" onsubmit="return confirm('Voulez-vous supprimer ?')" action="{{route('mspromotions.destroy',$mspromotion)}}" method="POST">
						{{csrf_field()}}
						{{method_field('DELETE')}}
						<button class="btn btn-small btn-danger btn-xs" type="submit">Supp.</button>
						
					</form>
				</td>
			</tr>
		@endforeach
		</tbody>
	</table>
@endsection


@section('script')
	<script>
	$(function(){
			$("#datatable-mspromotions").DataTable();
			creer_champ_visible_lable('mspromotions');
			$(".th_supprimer").click();
			$(".th_voir").click();
			
	});
	</script>
@endsection
