﻿@extends('Masomwetu.Scholar.parents.main')

@section('content')


@section('liste-title')
	<i class="fa fa-plus-square left-icon" onclick=" window.location='{{route('parents.create')}}'; " title="Ajouter un nouvel enregistrement" ></i> 
	
	Il y a ({{$parents->count()}}) Parent(s) dans la liste
	<a href="#" title="voir ou cacher des colonnes">
	<i style="display:none" id="btn-fa-eye-slash" onclick="cacher_les_champs()" class="fa fa-fw fa-eye-slash"></i>
	<i id="btn-fa-eye" onclick="voir_les_champs()" class="fa fa-fw fa-eye"></i></a>
@endsection
	<!-- will be used to show any messages -->
	@php display_flash(); @endphp

	<p class="champ-visible" style="display:none"></p>
	<table id="datatable-parents" class="table table-striped table-bordered">
		<thead>
				<tr>
					
					<th>Pere</th>
					<th>Téléphone père</th>
					<th>Profession-père</th>
					<th>Maman</th>
					<th>Téléphone mère</th>
					<th>Profession mère</th>
					<th style="width:30px">Voir</th>
					<th style="width:30px">Modif.</th>
					<th style="width:30px">Supp.</th>
				</tr>
		</thead>
		<tbody>
		@foreach($parents as $key => $parent)
			<tr>
					
					<td class='editable-td' k='{{$parent->id}}' f='papa' i='63' t='' >{{ $parent->papa }}</td>
					<td class='editable-td' k='{{$parent->id}}' f='telephone_pa' i='63' t='' >{{ $parent->telephone_pa }}</td>
					<td class='editable-td' k='{{$parent->id}}' f='profession_pa' i='63' t='' >{{ $parent->profession_pa }}</td>
					<td class='editable-td' k='{{$parent->id}}' f='maman' i='63' t='' >{{ $parent->maman }}</td>
					<td class='editable-td' k='{{$parent->id}}' f='telephone_ma' i='63' t='' >{{ $parent->telephone_ma }}</td>
					<td class='editable-td' k='{{$parent->id}}' f='profession_ma' i='63' t='' >{{ $parent->profession_ma }}</td>

						<!-- delete the nerd (uses the destroy method DESTROY /parents/{id} -->
						<!-- we will add this later since its a little more complicated than the other two buttons -->

				<!-- we will also add show, edit, and delete buttons CrÃ©er -->
				<td>
					<a class="btn btn-small btn-success btn-xs" href="{{ URL::to('parents/' . $parent->id) }}">Voir</a>
				</td>
				<td>
					<a class="btn btn-small btn-info btn-xs" href="{{ URL::to('parents/' . $parent->id . '/edit') }}">Modif.</a>
				</td>
				<td>								
					<form style="margin: 0;" onsubmit="return confirm('Voulez-vous supprimer ?')" action="{{route('parents.destroy',$parent)}}" method="POST">
						{{csrf_field()}}
						{{method_field('DELETE')}}
						<button class="btn btn-small btn-danger btn-xs" type="submit">Supp.</button>
						
					</form>
				</td>
			</tr>
		@endforeach
		</tbody>
	</table>
@endsection


@section('script')
	<script>
	$(function(){
			$("#datatable-parents").DataTable();
			creer_champ_visible_lable('parents');
			$(".th_supprimer").click();
			$(".th_voir").click();
			
	});
	</script>
@endsection
