﻿@extends('Masomwetu.Scholar.tuteurs.main')

@section('content')


@section('liste-title')
	<i class="fa fa-plus-square left-icon" onclick=" window.location='{{route('tuteurs.create')}}'; " title="Ajouter un nouvel enregistrement" ></i> 
	
	Il y a ({{$tuteurs->count()}}) Tuteur(s) dans la liste
	<a href="#" title="voir ou cacher des colonnes">
	<i style="display:none" id="btn-fa-eye-slash" onclick="cacher_les_champs()" class="fa fa-fw fa-eye-slash"></i>
	<i id="btn-fa-eye" onclick="voir_les_champs()" class="fa fa-fw fa-eye"></i></a>
@endsection
	<!-- will be used to show any messages -->
	@php display_flash(); @endphp

	<p class="champ-visible" style="display:none"></p>
	<table id="datatable-tuteurs" class="table table-striped table-bordered">
		<thead>
				<tr>
					
					<th>Tuteur/Tutrice</th>
					<th>Téléphone</th>
					<th>Adresse</th>
					<th style="width:30px">Voir</th>
					<th style="width:30px">Modif.</th>
					<th style="width:30px">Supp.</th>
				</tr>
		</thead>
		<tbody>
		@foreach($tuteurs as $key => $tuteur)
			<tr>
					
					<td class='editable-td' k='{{$tuteur->id}}' f='nom_tuteur' i='3' t='text' >{{ $tuteur->nom_tuteur }}</td>
					<td class='editable-td' k='{{$tuteur->id}}' f='telephone' i='3' t='text' >{{ $tuteur->telephone }}</td>
					<td class='editable-td' k='{{$tuteur->id}}' f='adresse' i='3' t='text' >{{ $tuteur->adresse }}</td>

						<!-- delete the nerd (uses the destroy method DESTROY /tuteurs/{id} -->
						<!-- we will add this later since its a little more complicated than the other two buttons -->

				<!-- we will also add show, edit, and delete buttons CrÃ©er -->
				<td>
					<a class="btn btn-small btn-success btn-xs" href="{{ URL::to('tuteurs/' . $tuteur->id) }}">Voir</a>
				</td>
				<td>
					<a class="btn btn-small btn-info btn-xs" href="{{ URL::to('tuteurs/' . $tuteur->id . '/edit') }}">Modif.</a>
				</td>
				<td>								
					<form style="margin: 0;" onsubmit="return confirm('Voulez-vous supprimer ?')" action="{{route('tuteurs.destroy',$tuteur)}}" method="POST">
						{{csrf_field()}}
						{{method_field('DELETE')}}
						<button class="btn btn-small btn-danger btn-xs" type="submit">Supp.</button>
						
					</form>
				</td>
			</tr>
		@endforeach
		</tbody>
	</table>
@endsection


@section('script')
	<script>
	$(function(){
			$("#datatable-tuteurs").DataTable();
			creer_champ_visible_lable('tuteurs');
			$(".th_supprimer").click();
			$(".th_voir").click();
			
	});
	</script>
@endsection
