﻿@extends('Masomwetu.School.agents.main')

@section('content')


@section('liste-title')
	<i class="fa fa-plus-square left-icon" onclick=" window.location='{{route('agents.create')}}'; " title="Ajouter un nouvel enregistrement" ></i> 
	
	Il y a ({{$agents->count()}}) Agent(s) dans la liste
	<a href="#" title="voir ou cacher des colonnes">
	<i style="display:none" id="btn-fa-eye-slash" onclick="cacher_les_champs()" class="fa fa-fw fa-eye-slash"></i>
	<i id="btn-fa-eye" onclick="voir_les_champs()" class="fa fa-fw fa-eye"></i></a>
@endsection
	<!-- will be used to show any messages -->
	@php display_flash(); @endphp

	<p class="champ-visible" style="display:none"></p>
	<table id="datatable-agents" class="table table-striped table-bordered">
		<thead>
				<tr>
					
					<th>Personnel</th>
					<th>Fonction</th>
					<th>Date d'engagement</th>
					<th style="width:30px">Voir</th>
					<th style="width:30px">Modif.</th>
					<th style="width:30px">Supp.</th>
				</tr>
		</thead>
		<tbody>
		@foreach($agents as $key => $agent)
			<tr>
					
					<td class='editable-td'  k='{{$agent->id}}' f='personnel_id' i='54' t='select' s='Personnel' >{{ ($agent->personnel->noms??'') }}</td>
					<td class='editable-td'  k='{{$agent->id}}' f='mc_fonction_id' i='54' t='select' s='McFonction' >{{ ($agent->mcFonction->fonction??'') }}</td>
					<td class='editable-td' k='{{$agent->id}}' f='date_engagement' i='54' t='date' >{{ $agent->date_engagement }}</td>

						<!-- delete the nerd (uses the destroy method DESTROY /agents/{id} -->
						<!-- we will add this later since its a little more complicated than the other two buttons -->

				<!-- we will also add show, edit, and delete buttons CrÃ©er -->
				<td>
					<a class="btn btn-small btn-success btn-xs" href="{{ URL::to('agents/' . $agent->id) }}">Voir</a>
				</td>
				<td>
					<a class="btn btn-small btn-info btn-xs" href="{{ URL::to('agents/' . $agent->id . '/edit') }}">Modif.</a>
				</td>
				<td>								
					<form style="margin: 0;" onsubmit="return confirm('Voulez-vous supprimer ?')" action="{{route('agents.destroy',$agent)}}" method="POST">
						{{csrf_field()}}
						{{method_field('DELETE')}}
						<button class="btn btn-small btn-danger btn-xs" type="submit">Supp.</button>
						
					</form>
				</td>
			</tr>
		@endforeach
		</tbody>
	</table>
@endsection


@section('script')
	<script>
	$(function(){
			$("#datatable-agents").DataTable();
			creer_champ_visible_lable('agents');
			$(".th_supprimer").click();
			$(".th_voir").click();
			
	});
	</script>
@endsection
