﻿@extends('Masomwetu.School.enseignants.main')

@section('content')


@section('liste-title')
	<i class="fa fa-plus-square left-icon" onclick=" window.location='{{route('enseignants.create')}}'; " title="Ajouter un nouvel enregistrement" ></i> 
	
	Il y a ({{$enseignants->count()}}) Enseignant(s) dans la liste
	<a href="#" title="voir ou cacher des colonnes">
	<i style="display:none" id="btn-fa-eye-slash" onclick="cacher_les_champs()" class="fa fa-fw fa-eye-slash"></i>
	<i id="btn-fa-eye" onclick="voir_les_champs()" class="fa fa-fw fa-eye"></i></a>
@endsection
	<!-- will be used to show any messages -->
	@php display_flash(); @endphp

	<p class="champ-visible" style="display:none"></p>
	<table id="datatable-enseignants" class="table table-striped table-bordered">
		<thead>
				<tr>
					
					<th>Agent</th>
					<th>Journée Péda.</th>
					<th>Code Couleur</th>
					<th>Couleur Text</th>
					<th style="width:30px">Voir</th>
					<th style="width:30px">Modif.</th>
					<th style="width:30px">Supp.</th>
				</tr>
		</thead>
		<tbody>
		@foreach($enseignants as $key => $enseignant)
			<tr>
					
					<td class='editable-td'  k='{{$enseignant->id}}' f='agent_id' i='46' t='select' s='Agent' >{{ ($enseignant->agent->personnel->noms??'').' '.($enseignant->agent->mcFonction->fonction??'') }}</td>
					<td class='editable-td' k='{{$enseignant->id}}' f='journee_pedago' i='46' t='text' >{{ $enseignant->journee_pedago }}</td>
					<td class='editable-td' k='{{$enseignant->id}}' f='code_couleur' i='46' t='text' >{{ $enseignant->code_couleur }}</td>
					<td class='editable-td' k='{{$enseignant->id}}' f='couleur_text' i='46' t='text' >{{ $enseignant->couleur_text }}</td>

						<!-- delete the nerd (uses the destroy method DESTROY /enseignants/{id} -->
						<!-- we will add this later since its a little more complicated than the other two buttons -->

				<!-- we will also add show, edit, and delete buttons CrÃ©er -->
				<td>
					<a class="btn btn-small btn-success btn-xs" href="{{ URL::to('enseignants/' . $enseignant->id) }}">Voir</a>
				</td>
				<td>
					<a class="btn btn-small btn-info btn-xs" href="{{ URL::to('enseignants/' . $enseignant->id . '/edit') }}">Modif.</a>
				</td>
				<td>								
					<form style="margin: 0;" onsubmit="return confirm('Voulez-vous supprimer ?')" action="{{route('enseignants.destroy',$enseignant)}}" method="POST">
						{{csrf_field()}}
						{{method_field('DELETE')}}
						<button class="btn btn-small btn-danger btn-xs" type="submit">Supp.</button>
						
					</form>
				</td>
			</tr>
		@endforeach
		</tbody>
	</table>
@endsection


@section('script')
	<script>
	$(function(){
			$("#datatable-enseignants").DataTable();
			creer_champ_visible_lable('enseignants');
			$(".th_supprimer").click();
			$(".th_voir").click();
			
	});
	</script>
@endsection
