﻿@extends('Masomwetu.School.imgdossierenfants.main')

@section('content')


@section('liste-title')
	<i class="fa fa-plus-square left-icon" onclick=" window.location='{{route('imgdossierenfants.create')}}'; " title="Ajouter un nouvel enregistrement" ></i> 
	
	Il y a ({{$imgdossierenfants->count()}}) Document enfant(s) dans la liste
	<a href="#" title="voir ou cacher des colonnes">
	<i style="display:none" id="btn-fa-eye-slash" onclick="cacher_les_champs()" class="fa fa-fw fa-eye-slash"></i>
	<i id="btn-fa-eye" onclick="voir_les_champs()" class="fa fa-fw fa-eye"></i></a>
@endsection
	<!-- will be used to show any messages -->
	@php display_flash(); @endphp

	<p class="champ-visible" style="display:none"></p>
	<table id="datatable-imgdossierenfants" class="table table-striped table-bordered">
		<thead>
				<tr>
					
					<th>Dossier enfant</th>
					<th>Le Scan</th>
					<th style="width:30px">Voir</th>
					<th style="width:30px">Modif.</th>
					<th style="width:30px">Supp.</th>
				</tr>
		</thead>
		<tbody>
		@foreach($imgdossierenfants as $key => $imgdossierenfant)
			<tr>
					
					<td class='editable-td'  k='{{$imgdossierenfant->id}}' f='dossier_enfant_id' i='65' t='select' s='DossierEnfant' >{{ ($imgdossierenfant->dossierEnfant->enfant->matricule??'').' '.($imgdossierenfant->dossierEnfant->enfant->nom??'').' '.($imgdossierenfant->dossierEnfant->enfant->postnom??'').' '.($imgdossierenfant->dossierEnfant->enfant->prenom??'').' '.($imgdossierenfant->dossierEnfant->enfant->genre??'').' '.($imgdossierenfant->dossierEnfant->titre_document??'') }}</td>
					<td class='editable-td' k='{{$imgdossierenfant->id}}' f='scan' i='65' t='file' ><img class='crud_img' src="{{ asset('storage/imgdossierenfant/scan/'.$imgdossierenfant->scan) }}" /></td>

						<!-- delete the nerd (uses the destroy method DESTROY /imgdossierenfants/{id} -->
						<!-- we will add this later since its a little more complicated than the other two buttons -->

				<!-- we will also add show, edit, and delete buttons CrÃ©er -->
				<td>
					<a class="btn btn-small btn-success btn-xs" href="{{ URL::to('imgdossierenfants/' . $imgdossierenfant->id) }}">Voir</a>
				</td>
				<td>
					<a class="btn btn-small btn-info btn-xs" href="{{ URL::to('imgdossierenfants/' . $imgdossierenfant->id . '/edit') }}">Modif.</a>
				</td>
				<td>								
					<form style="margin: 0;" onsubmit="return confirm('Voulez-vous supprimer ?')" action="{{route('imgdossierenfants.destroy',$imgdossierenfant)}}" method="POST">
						{{csrf_field()}}
						{{method_field('DELETE')}}
						<button class="btn btn-small btn-danger btn-xs" type="submit">Supp.</button>
						
					</form>
				</td>
			</tr>
		@endforeach
		</tbody>
	</table>
@endsection


@section('script')
	<script>
	$(function(){
			$("#datatable-imgdossierenfants").DataTable();
			creer_champ_visible_lable('imgdossierenfants');
			$(".th_supprimer").click();
			$(".th_voir").click();
			
	});
	</script>
@endsection
