﻿@extends('Masomwetu.School.niveauetudepersonnels.main')

@section('content')


@section('liste-title')
	<i class="fa fa-plus-square left-icon" onclick=" window.location='{{route('niveauetudepersonnels.create')}}'; " title="Ajouter un nouvel enregistrement" ></i> 
	
	Il y a ({{$niveauetudepersonnels->count()}}) Niveau étude du personnel(s) dans la liste
	<a href="#" title="voir ou cacher des colonnes">
	<i style="display:none" id="btn-fa-eye-slash" onclick="cacher_les_champs()" class="fa fa-fw fa-eye-slash"></i>
	<i id="btn-fa-eye" onclick="voir_les_champs()" class="fa fa-fw fa-eye"></i></a>
@endsection
	<!-- will be used to show any messages -->
	@php display_flash(); @endphp

	<p class="champ-visible" style="display:none"></p>
	<table id="datatable-niveauetudepersonnels" class="table table-striped table-bordered">
		<thead>
				<tr>
					
					<th>Non Personnel</th>
					<th>Qualifiqation</th>
					<th>Diplôme Brevet License</th>
					<th>Année</th>
					<th>Observation</th>
					<th style="width:30px">Voir</th>
					<th style="width:30px">Modif.</th>
					<th style="width:30px">Supp.</th>
				</tr>
		</thead>
		<tbody>
		@foreach($niveauetudepersonnels as $key => $niveauetudepersonnel)
			<tr>
					
					<td class='editable-td'  k='{{$niveauetudepersonnel->id}}' f='personnel_id' i='58' t='select' s='Personnel' >{{ ($niveauetudepersonnel->personnel->noms??'') }}</td>
					<td class='editable-td' k='{{$niveauetudepersonnel->id}}' f='qualification' i='58' t='text' >{{ $niveauetudepersonnel->qualification }}</td>
					<td class='editable-td' k='{{$niveauetudepersonnel->id}}' f='diplome_brevet_licence' i='58' t='text' >{{ $niveauetudepersonnel->diplome_brevet_licence }}</td>
					<td class='editable-td' k='{{$niveauetudepersonnel->id}}' f='annee' i='58' t='text' >{{ $niveauetudepersonnel->annee }}</td>
					<td class='editable-td' k='{{$niveauetudepersonnel->id}}' f='observation' i='58' t='text' >{{ $niveauetudepersonnel->observation }}</td>

						<!-- delete the nerd (uses the destroy method DESTROY /niveauetudepersonnels/{id} -->
						<!-- we will add this later since its a little more complicated than the other two buttons -->

				<!-- we will also add show, edit, and delete buttons CrÃ©er -->
				<td>
					<a class="btn btn-small btn-success btn-xs" href="{{ URL::to('niveauetudepersonnels/' . $niveauetudepersonnel->id) }}">Voir</a>
				</td>
				<td>
					<a class="btn btn-small btn-info btn-xs" href="{{ URL::to('niveauetudepersonnels/' . $niveauetudepersonnel->id . '/edit') }}">Modif.</a>
				</td>
				<td>								
					<form style="margin: 0;" onsubmit="return confirm('Voulez-vous supprimer ?')" action="{{route('niveauetudepersonnels.destroy',$niveauetudepersonnel)}}" method="POST">
						{{csrf_field()}}
						{{method_field('DELETE')}}
						<button class="btn btn-small btn-danger btn-xs" type="submit">Supp.</button>
						
					</form>
				</td>
			</tr>
		@endforeach
		</tbody>
	</table>
@endsection


@section('script')
	<script>
	$(function(){
			$("#datatable-niveauetudepersonnels").DataTable();
			creer_champ_visible_lable('niveauetudepersonnels');
			$(".th_supprimer").click();
			$(".th_voir").click();
			
	});
	</script>
@endsection
