﻿@extends('Masomwetu.School.personnels.main')

@section('content')


@section('liste-title')
	<i class="fa fa-plus-square left-icon" onclick=" window.location='{{route('personnels.create')}}'; " title="Ajouter un nouvel enregistrement" ></i> 
	
	Il y a ({{$personnels->count()}}) Personnel(s) dans la liste
	<a href="#" title="voir ou cacher des colonnes">
	<i style="display:none" id="btn-fa-eye-slash" onclick="cacher_les_champs()" class="fa fa-fw fa-eye-slash"></i>
	<i id="btn-fa-eye" onclick="voir_les_champs()" class="fa fa-fw fa-eye"></i></a>
@endsection
	<!-- will be used to show any messages -->
	@php display_flash(); @endphp

	<p class="champ-visible" style="display:none"></p>
	<table id="datatable-personnels" class="table table-striped table-bordered">
		<thead>
				<tr>
					
					<th>Noms</th>
					<th>Genre</th>
					<th>Adresse</th>
					<th>Téléphone</th>
					<th>Adresse e-mail</th>
					<th>Etat-Civil</th>
					<th>Image</th>
					<th>Date Naissance</th>
					<th>Nationalité</th>
					<th>Situation Familiale</th>
					<th style="width:30px">Voir</th>
					<th style="width:30px">Modif.</th>
					<th style="width:30px">Supp.</th>
				</tr>
		</thead>
		<tbody>
		@foreach($personnels as $key => $personnel)
			<tr>
					
					<td class='editable-td' k='{{$personnel->id}}' f='noms' i='33' t='text' >{{ $personnel->noms }}</td>
					<td class='editable-td' k='{{$personnel->id}}' f='genre' i='33' t='text' >{{ $personnel->genre }}</td>
					<td class='editable-td' k='{{$personnel->id}}' f='adresse' i='33' t='text' >{{ $personnel->adresse }}</td>
					<td class='editable-td' k='{{$personnel->id}}' f='telephone' i='33' t='text' >{{ $personnel->telephone }}</td>
					<td class='editable-td' k='{{$personnel->id}}' f='adresse_mail' i='33' t='text' >{{ $personnel->adresse_mail }}</td>
					<td class='editable-td' k='{{$personnel->id}}' f='etat_civil' i='33' t='text' >{{ $personnel->etat_civil }}</td>
					<td class='editable-td' k='{{$personnel->id}}' f='image' i='33' t='file' ><img class='crud_img' src="{{ asset('storage/personnel/image/'.$personnel->image) }}" /></td>
					<td class='editable-td' k='{{$personnel->id}}' f='date_naissance' i='33' t='date' >{{ $personnel->date_naissance }}</td>
					<td class='editable-td' k='{{$personnel->id}}' f='nationalite' i='33' t='text' >{{ $personnel->nationalite }}</td>
					<td class='editable-td' k='{{$personnel->id}}' f='sifa' i='33' t='text' >{{ $personnel->sifa }}</td>

						<!-- delete the nerd (uses the destroy method DESTROY /personnels/{id} -->
						<!-- we will add this later since its a little more complicated than the other two buttons -->

				<!-- we will also add show, edit, and delete buttons CrÃ©er -->
				<td>
					<a class="btn btn-small btn-success btn-xs" href="{{ URL::to('personnels/' . $personnel->id) }}">Voir</a>
				</td>
				<td>
					<a class="btn btn-small btn-info btn-xs" href="{{ URL::to('personnels/' . $personnel->id . '/edit') }}">Modif.</a>
				</td>
				<td>								
					<form style="margin: 0;" onsubmit="return confirm('Voulez-vous supprimer ?')" action="{{route('personnels.destroy',$personnel)}}" method="POST">
						{{csrf_field()}}
						{{method_field('DELETE')}}
						<button class="btn btn-small btn-danger btn-xs" type="submit">Supp.</button>
						
					</form>
				</td>
			</tr>
		@endforeach
		</tbody>
	</table>
@endsection


@section('script')
	<script>
	$(function(){
			$("#datatable-personnels").DataTable();
			creer_champ_visible_lable('personnels');
			$(".th_supprimer").click();
			$(".th_voir").click();
			
	});
	</script>
@endsection
