﻿@extends('Masomwetu.Sys.sysroles.main')

@section('content')


@section('liste-title')
	<i class="fa fa-plus-square left-icon" onclick=" window.location='{{route('sysroles.create')}}'; " title="Ajouter un nouvel enregistrement" ></i> 
	
	Il y a ({{$sysroles->count()}}) Rôle(s) dans la liste
	<a href="#" title="voir ou cacher des colonnes">
	<i style="display:none" id="btn-fa-eye-slash" onclick="cacher_les_champs()" class="fa fa-fw fa-eye-slash"></i>
	<i id="btn-fa-eye" onclick="voir_les_champs()" class="fa fa-fw fa-eye"></i></a>
@endsection
	<!-- will be used to show any messages -->
	@php display_flash(); @endphp

	<p class="champ-visible" style="display:none"></p>
	<table id="datatable-sysroles" class="table table-striped table-bordered">
		<thead>
				<tr>
					
					<th>Rôle</th>
					<th>Code</th>
					<th>Description</th>
					<th style="width:30px">Voir</th>
					<th style="width:30px">Modif.</th>
					<th style="width:30px">Supp.</th>
				</tr>
		</thead>
		<tbody>
		@foreach($sysroles as $key => $sysrole)
			<tr>
					
					<td class='editable-td' k='{{$sysrole->id}}' f='role' i='15' t='text' >{{ $sysrole->role }}</td>
					<td class='editable-td' k='{{$sysrole->id}}' f='code' i='15' t='text' >{{ $sysrole->code }}</td>
					<td class='editable-td' k='{{$sysrole->id}}' f='role_desc' i='15' t='text' >{{ $sysrole->role_desc }}</td>

						<!-- delete the nerd (uses the destroy method DESTROY /sysroles/{id} -->
						<!-- we will add this later since its a little more complicated than the other two buttons -->

				<!-- we will also add show, edit, and delete buttons CrÃ©er -->
				<td>
					<a class="btn btn-small btn-success btn-xs" href="{{ URL::to('sysroles/' . $sysrole->id) }}">Voir</a>
				</td>
				<td>
					<a class="btn btn-small btn-info btn-xs" href="{{ URL::to('sysroles/' . $sysrole->id . '/edit') }}">Modif.</a>
				</td>
				<td>								
					<form style="margin: 0;" onsubmit="return confirm('Voulez-vous supprimer ?')" action="{{route('sysroles.destroy',$sysrole)}}" method="POST">
						{{csrf_field()}}
						{{method_field('DELETE')}}
						<button class="btn btn-small btn-danger btn-xs" type="submit">Supp.</button>
						
					</form>
				</td>
			</tr>
		@endforeach
		</tbody>
	</table>
@endsection


@section('script')
	<script>
	$(function(){
			$("#datatable-sysroles").DataTable();
			creer_champ_visible_lable('sysroles');
			$(".th_supprimer").click();
			$(".th_voir").click();
			
	});
	</script>
@endsection
