﻿@extends('Masomwetu.Sys.sysuserroles.main')

@section('content')


@section('liste-title')
	<i class="fa fa-plus-square left-icon" onclick=" window.location='{{route('sysuserroles.create')}}'; " title="Ajouter un nouvel enregistrement" ></i> 
	
	Il y a ({{$sysuserroles->count()}}) Utilisateur et rôle(s) dans la liste
	<a href="#" title="voir ou cacher des colonnes">
	<i style="display:none" id="btn-fa-eye-slash" onclick="cacher_les_champs()" class="fa fa-fw fa-eye-slash"></i>
	<i id="btn-fa-eye" onclick="voir_les_champs()" class="fa fa-fw fa-eye"></i></a>
@endsection
	<!-- will be used to show any messages -->
	@php display_flash(); @endphp

	<p class="champ-visible" style="display:none"></p>
	<table id="datatable-sysuserroles" class="table table-striped table-bordered  editable-table">
		<thead>
				<tr>
					
					<th>Utilisateur</th>
					<th>Rôle</th>
					<th>Année Scolaire</th>
					<th>Actif</th>
					<th>Désactiver le</th>
					<th style="width:30px">Voir</th>
					<th style="width:30px">Modif.</th>
					<th style="width:30px">Supp.</th>
				</tr>
		</thead>
		<tbody>
		@foreach($sysuserroles as $key => $sysuserrole)
			<tr>
					
					<td class='editable-td'  k='{{$sysuserrole->id}}' f='user_id' i='19' t='select' s='User' >{{ ($sysuserrole->user->name??'') }}</td>
					<td class='editable-td'  k='{{$sysuserrole->id}}' f='sys_role_id' i='19' t='select' s='SysRole' >{{ ($sysuserrole->sysRole->role??'') }}</td>
					<td class='editable-td'  k='{{$sysuserrole->id}}' f='ms_annee_scolaire_id' i='19' t='select' s='MsAnneeScolaire' >{{ ($sysuserrole->msAnneeScolaire->annee??'').' '.($sysuserrole->msAnneeScolaire->ecole->nom_ecole??'') }}</td>
					<td class='editable-td' k='{{$sysuserrole->id}}' f='actif' i='19' t='text' >{{ $sysuserrole->actif }}</td>
					<td class='editable-td' k='{{$sysuserrole->id}}' f='date_desactif' i='19' t='date' >{{ $sysuserrole->date_desactif }}</td>

						<!-- delete the nerd (uses the destroy method DESTROY /sysuserroles/{id} -->
						<!-- we will add this later since its a little more complicated than the other two buttons -->

				<!-- we will also add show, edit, and delete buttons CrÃ©er -->
				<td>
					<a class="btn btn-small btn-success btn-xs" href="{{ URL::to('sysuserroles/' . $sysuserrole->id) }}">Voir</a>
				</td>
				<td>
					<a class="btn btn-small btn-info btn-xs" href="{{ URL::to('sysuserroles/' . $sysuserrole->id . '/edit') }}">Modif.</a>
				</td>
				<td>								
					<form style="margin: 0;" onsubmit="return confirm('Voulez-vous supprimer ?')" action="{{route('sysuserroles.destroy',$sysuserrole)}}" method="POST">
						{{csrf_field()}}
						{{method_field('DELETE')}}
						<button class="btn btn-small btn-danger btn-xs" type="submit">Supp.</button>
						
					</form>
				</td>
			</tr>
		@endforeach
		</tbody>
	</table>
@endsection


@section('script')
	<script>
	$(function(){
			$("#datatable-sysuserroles").DataTable();
			creer_champ_visible_lable('sysuserroles');
			$(".th_supprimer").click();
			$(".th_voir").click();
			
	});
	</script>
@endsection
