﻿@extends('Masomwetu.Sys.users.main')

@section('content')


@section('liste-title')
	<i class="fa fa-plus-square left-icon" onclick=" window.location='{{route('users.create')}}'; " title="Ajouter un nouvel enregistrement" ></i> 
	
	Il y a ({{$users->count()}}) Utilisateur(s) dans la liste
	<a href="#" title="voir ou cacher des colonnes">
	<i style="display:none" id="btn-fa-eye-slash" onclick="cacher_les_champs()" class="fa fa-fw fa-eye-slash"></i>
	<i id="btn-fa-eye" onclick="voir_les_champs()" class="fa fa-fw fa-eye"></i></a>
@endsection
	<!-- will be used to show any messages -->
	@php display_flash(); @endphp

	<p class="champ-visible" style="display:none"></p>
	<table id="datatable-users" class="table table-striped table-bordered editable-table">
		<thead>
				<tr>
					
					<th>Nom</th>
					<th>Email</th>
					<th>E-mail Connecté à</th>
					<th>Mot de passe</th>
					<th style="width:30px">Voir</th>
					<th style="width:30px">Modif.</th>
					<th style="width:30px">Supp.</th>
				</tr>
		</thead>
		<tbody class=''>
		@foreach($users as $key => $user)
			<tr>
					
					<td class='editable-td' k='{{$user->id}}' f='name' i='18' t='text' >{{ $user->name }}</td>
					<td class='editable-td' k='{{$user->id}}' f='email' i='18' t='text' >{{ $user->email }}</td>
					<td class='editable-td' k='{{$user->id}}' f='email_verified_at' i='18' t='text' >{{ $user->email_verified_at }}</td>
					<td class='editable-td' k='{{$user->id}}' f='password' i='18' t='text' >{{ $user->password }}</td>

						<!-- delete the nerd (uses the destroy method DESTROY /users/{id} -->
						<!-- we will add this later since its a little more complicated than the other two buttons -->

				<!-- we will also add show, edit, and delete buttons CrÃ©er -->
				<td>
					<a class="btn btn-small btn-success btn-xs" href="{{ URL::to('users/' . $user->id) }}">Voir</a>
				</td>
				<td>
					<a class="btn btn-small btn-info btn-xs" href="{{ URL::to('users/' . $user->id . '/edit') }}">Modif.</a>
				</td>
				<td>								
					<form style="margin: 0;" onsubmit="return confirm('Voulez-vous supprimer ?')" action="{{route('users.destroy',$user)}}" method="POST">
						{{csrf_field()}}
						{{method_field('DELETE')}}
						<button class="btn btn-small btn-danger btn-xs" type="submit">Supp.</button>
						
					</form>
				</td>
			</tr>
		@endforeach
		</tbody>
	</table>
@endsection


@section('script')
	<script>
	$(function(){
			$("#datatable-users").DataTable();
			creer_champ_visible_lable('users');
			$(".th_supprimer").click();
			$(".th_voir").click();
			
	});
	</script>
@endsection
