@extends('template')
@section('style')
	<link href="{{asset('css/select2.min.css')}}" rel="stylesheet">
	<link rel="stylesheet" href="{{asset('static/my_select_2.css?d=o')}}">
	<script src="{{ asset('static/my_select_2.js') }}"></script>
	<style>
        #synthese td.sortie {
            background: #ff000017;
            color: #884949;
        }
        #synthese td.sold  {
            background: #00ff0017;
            color: #498868;
        }
        #synthese td.mnt {
            text-align: right;
        }
        .box-header {
        padding: 5px 9px;
        }
        table#synthese tr.sous-groupe td{
            padding:0;
        }
        

        @keyframes slide
        {
            from {height: 0;}
            to {height: 25px;}
        }

        tr td div {
        max-height: 0;
        padding: 0 10px;
        box-sizing: border-box;
        overflow: hidden;
        transition: max-height 0.3s, padding 0.3s;
        }
        tr.active td div {
        max-height: 100px;
        padding: 5px;
        transition: max-height 0.6s, padding 0.6s;
        }

	</style>
	
@endsection
@section('content')

<div class="box">
    <div class="box-body">        
        <div class="box-header with-border">
            <h3 class="box-title">SYNTHESE DES COMPTES</h3>

            <div class="box-tools pull-right">
            <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
            </button>
            </div>
            <!-- /.box-tools -->
        </div>
        @php 
        
        // les entrees par groupe
        $req_data_grp = "SELECT cg.compte_id, g.id gr_id, `libelle`, `code`,g.titre, `e_cdf`, `e_usd`, `s_cdf`, `s_usd`, `sold_cdf`, `sold_usd` 
        FROM `v_les_entrees_sorties_comptes`  e
        left join cpt_regroupement_comptes cg on cg.compte_id=e.id 
        left join cpt_regroupements g on g.id = cg.cpt_regroupement_id
        order by g.id,e.libelle
        ";
        $data_grp = \DB::select($req_data_grp);
        $data_grp_cl = collect($data_grp );
        ///dd($data_grp_cl);
        $req = "SELECT `id`, `libelle`, `code`, `cpte_parent_id`, `e_cdf`, `e_usd`, `s_cdf`, `s_usd`, `sold_cdf`, `sold_usd` 
        FROM `v_les_entrees_sorties_comptes` WHERE 1";
        $data = \DB::select($req);

        $data_cl = collect($data ); 
        $data_entree_frais = false;
        $d1 = date('Y-m-01');
        $d2 = date('Y-m-d');
        if(isset($_GET['d1']) and isset($_GET['d2'])){
            $d1 = $_GET['d1'];
            $d2 = $_GET['d2'];
        }
        $req_entree_frais = "SELECT sum(`usd`) u, sum(`cdf`) c,
         `code`, `libelle`, `compte_id`, `compte_parent_id` 
        FROM `v_entree_des_frais` 
        WHERE payer_le between '$d1' and '$d2' group by compte_id
         ";
        //$data_entree_frais = \DB::select($req_entree_frais);

        // les entrees par groupe
        $req_entree_frais_grp = "SELECT  `code`, `libelle`,e.compte_id
        ,g.id gr_id, g.titre, 
        sum(`usd`) u, sum(`cdf`) c 
        FROM `v_entree_des_frais` e
        left join cpt_regroupement_comptes cg on cg.compte_id=e.compte_id 
        left join cpt_regroupements g on g.id = cg.cpt_regroupement_id
        WHERE payer_le between '$d1' and '$d2'
        group by e.compte_id
        order by g.id,e.libelle
        ";
        $data_entree_frais = \DB::select($req_entree_frais_grp);
        //var_dump($req_entree_frais_grp);
        $data_entree_frais_cl = collect($data_entree_frais);
        @endphp
        <form action="" method="get">
            <label for="">Charger les frais</label> DU
            <input value="{{$d1}}" type="date" name="d1"> AU
            <input value="{{$d2}}" type="date" name="d2"> <input type="submit" value="CHARGER">
        </form>
        <table id="synthese" class="table table-bordered table-condensed table-hover table-striped">
        <tr class="bg-aqua">
            <th>N</th>
            <th>CODE</th>
            <th>COMPTE</th>
            <TH>E.USD</TH>
            <TH>E.CDF</TH>
            <TH>S.USD</TH>
            <TH>S.CDF</TH>
            <TH>SLD.USD</TH>
            <TH>SLD.CDF</TH>
        </tr>
        @if($data_entree_frais)
            
            @php 
            $ex_grp = isset($data_entree_frais[0])?$data_entree_frais[0]:'';
            $grp_index=0;
            $gr_e_usd = $gr_e_cdf = $gr_s_usd = $gr_s_cdf = $gr_sold_usd = $gr_sold_cdf = 0;
            @endphp
            @foreach($data_entree_frais as $d)
                @php            
                    $m = $data_grp_cl->where('compte_id',$d->compte_id)->first();
                    $sold_usd = $e_usd = $d->u;
                    $sold_cdf =$e_cdf = $d->c;
                    $s_usd = $s_cdf = 0;
                    //$t = $d->u;
                    if($m){
                        $e_usd += $m->e_usd;
                        $e_cdf += $m->e_cdf;
                        $s_usd = $m->s_usd;
                        $s_cdf = $m->s_cdf;
                        $sold_usd += $m->sold_usd;
                        $sold_cdf += $m->sold_cdf;
                        //$t = "$t et ".$m->sold_usd;
                    }                
                @endphp

                @if($d->titre!=$ex_grp->titre)            
                    <tr style="background: #7b727224;">
                        <td class="bg-green "> <a href="#x" class="bg-green groupe invisi" g="f-{{$ex_grp->gr_id}}" v="n">+{{++$grp_index}}</a> </td>
                        <td colspan="2"> {{$ex_grp->titre?$ex_grp->titre:'AUTRES COMPTES'}}</th>
                        <td class="mnt">{{ chiffre($gr_e_usd) }}</td>
                        <td class="mnt">{{chiffre($gr_e_cdf)}}</td>
                        <td class="sortie mnt">{{chiffre($gr_s_usd)}}</td>
                        <td class="sortie mnt">{{chiffre($gr_s_cdf)}}</td>
                        <td class="sold mnt" style="color:{{$gr_sold_usd<0?'red':'blue'}}">{{chiffre($gr_sold_usd)}}</td>
                        <td class="sold mnt" style="color:{{$gr_sold_cdf<0?'red':'blue'}}">{{chiffre($gr_sold_cdf)}}</td>
                    </tr>
                    @php 
                        $gr_e_usd = $gr_e_cdf = $gr_s_usd = $gr_s_cdf = $gr_sold_usd = $gr_sold_cdf = 0;
                    @endphp
                @endif
                
                <tr class="sg-f-{{$d->gr_id}} sous-groupe">
                    <td><div>{{$loop->index+1}}</div></td>
                    <td><div>{{$d->code}}</div></td>
                    <td><div>{{$d->libelle}}</div></td>
                    <td class="mnt"><div>{{chiffre($e_usd) }}</div></td>
                    <td class="mnt"><div>{{chiffre($e_cdf)}}</div></td>
                    <td class="sortie mnt"><div>{{chiffre($s_usd)}}</div></td>
                    <td class="sortie mnt"><div>{{chiffre($s_cdf)}}</div></td>
                    <td class="sold mnt" style="color:{{$sold_usd<0?'red':'blue'}}"><div>{{chiffre($sold_usd)}} </div></td>
                    <td class="sold mnt" style="color:{{$sold_cdf<0?'red':'blue'}}"><div>{{chiffre($sold_cdf)}}  </div></td>
                </tr>
                @php 
                    $ex_grp = $d;
                
                    $gr_e_usd += $e_usd;
                    $gr_e_cdf += $e_cdf;
                    $gr_s_usd += $s_usd;
                    $gr_s_cdf += $s_cdf;
                    $gr_sold_usd += $sold_usd;
                    $gr_sold_cdf += $sold_cdf;
                @endphp
            @endforeach
            <tr style="background: #7b727224;">
                <td class="bg-green "> <a href="#x" class="bg-green groupe invisi" g="f-{{$ex_grp->gr_id}}" v="n">+{{++$grp_index}}</a> </td>
                <td colspan="2" class=""> {{$ex_grp->titre}}</th>
                <td class="mnt">{{ chiffre($gr_e_usd) }}</td>
                <td class="mnt">{{chiffre($gr_e_cdf)}}</td>
                <td class="sortie mnt">{{chiffre($gr_s_usd)}}</td>
                <td class="sortie mnt">{{chiffre($gr_s_cdf)}}</td>
                <td class="sold mnt" style="color:{{$gr_sold_usd<0?'red':'blue'}}">{{chiffre($gr_sold_usd)}}</td>
                <td class="sold mnt" style="color:{{$gr_sold_cdf<0?'red':'blue'}}">{{chiffre($gr_sold_cdf)}}</td>
            </tr>
        @endif
        <tr style="border-bottom: solid;"> <td colspan="10"></td> </tr>

        @php 
        $ex_grp = isset($data_grp[0])?$data_grp[0]:'';
        $grp_index=0;$loop_index=0;
        $gr_e_usd = $gr_e_cdf = $gr_s_usd = $gr_s_cdf = $gr_sold_usd = $gr_sold_cdf = 0;
        @endphp
        @foreach($data_grp as $d)
            @php 
                $m = $data_entree_frais_cl->where('compte_id',$d->compte_id)->first();
                if($m)continue;
            @endphp
            @if($d->titre!=$ex_grp->titre)            
                <tr style="background: #7b727224;">
                    <td class="bg-green "> <a href="#x" class="bg-green groupe invisi" g="{{$ex_grp->gr_id}}" v="n">+{{++$grp_index}}({{$loop_index}})</a> </td>
                    <td colspan="2"> {{$ex_grp->titre?$ex_grp->titre:'AUTRES COMPTES'}}</th>
                    <td class="mnt">{{ chiffre($gr_e_usd) }}</td>
                    <td class="mnt">{{chiffre($gr_e_cdf)}}</td>
                    <td class="sortie mnt">{{chiffre($gr_s_usd)}}</td>
                    <td class="sortie mnt">{{chiffre($gr_s_cdf)}}</td>
                    <td class="sold mnt" style="color:{{$gr_sold_usd<0?'red':'blue'}}">{{chiffre($gr_sold_usd)}}</td>
                    <td class="sold mnt" style="color:{{$gr_sold_cdf<0?'red':'blue'}}">{{chiffre($gr_sold_cdf)}}</td>
                </tr>
                @php $loop_index=0;
                    $gr_e_usd = $gr_e_cdf = $gr_s_usd = $gr_s_cdf = $gr_sold_usd = $gr_sold_cdf = 0;
                @endphp
            @endif
            
            <tr class="sg-{{$d->gr_id}} sous-groupe">
                <td><div>{{++$loop_index}}</div></td>
                <td><div>{{$d->code}}</div></td>
                <td><div>{{$d->libelle}}</div></td>
                <td class="mnt"><div>{{ chiffre($d->e_usd) }}</div></td>
                <td class="mnt"><div>{{chiffre($d->e_cdf)}}</div></td>
                <td class="sortie mnt"><div>{{chiffre($d->s_usd)}}</div></td>
                <td class="sortie mnt"><div>{{chiffre($d->s_cdf)}}</div></td>
                <td class="sold mnt" style="color:{{$d->sold_usd<0?'red':'blue'}}"><div>{{chiffre($d->sold_usd)}} </div></td>
                <td class="sold mnt" style="color:{{$d->sold_cdf<0?'red':'blue'}}"><div>{{chiffre($d->sold_cdf)}}  </div></td>
            </tr>
            @php 
                $ex_grp = $d;
             
                $gr_e_usd += $d->e_usd;
                $gr_e_cdf += $d->e_cdf;
                $gr_s_usd += $d->s_usd;
                $gr_s_cdf += $d->s_cdf;
                $gr_sold_usd += $d->sold_usd;
                $gr_sold_cdf += $d->sold_cdf;
            @endphp
        @endforeach
            <tr style="background: #7b727224;">
                <td class="bg-green "> <a href="#x" class="bg-green groupe invisi" g="{{$ex_grp->gr_id}}" v="n">+{{++$grp_index}}</a> </td>
                <td colspan="2" class=""> {{$ex_grp->titre}}</th>
                <td class="mnt">{{ chiffre($gr_e_usd) }}</td>
                <td class="mnt">{{chiffre($gr_e_cdf)}}</td>
                <td class="sortie mnt">{{chiffre($gr_s_usd)}}</td>
                <td class="sortie mnt">{{chiffre($gr_s_cdf)}}</td>
                <td class="sold mnt" style="color:{{$gr_sold_usd<0?'red':'blue'}}">{{chiffre($gr_sold_usd)}}</td>
                <td class="sold mnt" style="color:{{$gr_sold_cdf<0?'red':'blue'}}">{{chiffre($gr_sold_cdf)}}</td>
            </tr>
        </table>
    </div>
</div>
<div class="row">
        
    <div class="col-md-6">
        @php
            echo my_table_crud('cpt_regroupements',[],1,true);
        @endphp
    </div>
    <div class="col-md-6">
        @php
            echo my_table_crud('cpt_regroupement_comptes',[],1,true);
        @endphp
    </div>
</div>
@endsection

@section('script')
	<script src="{{asset('js/select2.full.min.js')}}"></script>
	
<script>
  var PREV_MODAL='-';
      $(function(){
          $('.groupe').click(function(){
              //$('.sous-groupe').hide();
              //$('.sous-groupe').hide();
              $g = $(this).attr('g');
              /*if($(this).hasClass('invisi')){
                  $('.groupe').removeClass('visi').addClass('invisi');                
                  $(this).removeClass('invisi').addClass('visi');
                  $("td.visi-sous-groupe ,th.visi-sous-groupe ").addClass('invisi-sous-groupe').removeClass('visi-sous-groupe');
                  $('.sg-'+$g+' td,.sg-'+$g+' th').remove('invisi-sous-groupe').addClass('visi-sous-groupe');
              }
              else{
                  //$('.groupe');
                  $(this).addClass('invisi').removeClass('visi');
                  //$(".visi-sous-groupe").removeClass('invisi-sous-groupe').addClass('visi-sous-groupe');
                  $('.sg-'+$g+' td,.sg-'+$g+' th').addClass('invisi-sous-groupe').removeClass('visi-sous-groupe');
              }*/
              $('.sg-'+$g).toggleClass('active');
              
              // $('.sg-'+$g+' td,.sg-'+$g+' th').slideDown("slow");
              //$('.sg-'+$g).show();
              /*if($(this).attr('v')=='n'){
                $('.sg-'+$g).show("slow");
                $(this).attr('v','y');
              }
              else {
                $('.sg-'+$g).hide();
                $(this).attr('v','n');
              }*/
          })
        // se lance a l'ouverture d'un modal
        $(document).on('show.bs.modal',function(e){
          console.log('ouverture modale',PREV_MODAL) 
          /* if($('#modal-default:visible').length){
              $('#modal-default').modal('hide');
              setTimeout(() => {
                PREV_MODAL = '#modal-default';
                console.log(PREV_MODAL)
              }, 3000);
              
          }
          else PREV_MODAL = '-';*/
        })
        // se lance a la fermeture d'un modal
        $(document).on('hidden.bs.modal',function(e){
          console.log('fermeture de','chado',PREV_MODAL)
          /* //&& ('#'+$(this).attr('id'))!=PREV_MODAL 
          if(PREV_MODAL != '#modal-default' && PREV_MODAL != '-' ){
            console.log('ouverture de',$(this).attr('id'),PREV_MODAL)
            $(PREV_MODAL).modal('show');
            PREV_MODAL = '-';
          } */
        })

        function hide_options(){
            var id = 'test-group';
            $("#"+id+' .btn-group').animate({'margin-left':-300},'slow');
            setTimeout(function(){$("#"+id).hide(); },500);
        }
        $('body').on('click','.td-option',function(e){
            //$(this).parent().animate({'backgroud':'#f00'},'slow');
            console.log($(this))
            var left = $(this).offset().left ;//- $(window).scrollLeft();
            var top = $(this).offset().top ;//- $(window).scrollTop();
            var id = 'test-group';
            var time = ($("#"+id+' .btn-group').css('margin-left')=='-300px')?0:500;
            $("#"+id+' button').attr('k',$(this).attr('k'));
            //$("#"+id).attr("class",$(this).attr('cl'));
            $("#"+id).attr("class",$(this).attr('cl'));

            $("#"+id+' .get-data-for-print').attr("tb",$(this).attr('tb'));
            
            setTimeout(function(){
                $("#"+id).show(); 
                if(($("#"+id+' .btn-group').css('margin-left')=='0px')){
                    $("#"+id+' .btn-group').animate({'margin-left':-300},250);
                    setTimeout(function(){ $("#"+id).css({'top':top,'left':left});},500);
                }
                else $("#"+id).css({'top':top,'left':left});//setTimeout(function(){},500);
            },500);
            if(($("#"+id+' .btn-group').css('margin-left')=='0px'))
                setTimeout(function(){$("#"+id+' .btn-group').animate({'margin-left':0},'slow'); },750);
            else
                setTimeout(function(){$("#"+id+' .btn-group').animate({'margin-left':0},'slow'); },0);
            
        })
        //,'.td-option-x'
        $('body').on('click',function(e){
            if(e.target.className!="td-option" && e.target.className!="fa fa-angle-double-right")
                hide_options()
            //console.log(e)
        })

    })
</script>

<div id="test-group" style="display:none;width:300px;height:auto;position:absolute;z-index:10000;overflow:hidden" >
    <div class='btn-group btn-group-sm' style="margin-left:-300px;border: solid 1px #004cffab;border-radius: 4px;">
        <button type="button" class="btn btn-default td-option-x"><i class='fa fa-angle-double-left'></i></button>
        <button type='button' k='' class='btn btn-danger delete-enregistrement'><i class='glyphicon glyphicon-trash'></i></button>
        <button type='button' k='' class='btn btn-primary detail-enregistrement'><i class='fa fa-eye'></i></button>
        <button type='button' k='' class='btn btn-success detail-newpage'><i class='fa fa-eye-slash'></i></button>
        <button type='button' k='' class='btn btn-default get-data-for-edition'><i class='fa fa-pencil-square-o'></i></button>
        <button type='button' k='' class='btn btn-info get-data-for-print'><i class='fa fa-print'></i></button>
    </div>
</div>
@endsection		