@extends("template")

@section('style')
<style>
	.mailbox-attachments li{
		width:32%;
		border:none;
	}
	li .mailbox-attachment-icon{
		height: 172px;
		/* border-bottom:solid 2px #3c8dbc; */
	}
	.mailbox-attachment-info{
		font-size: 22px;
	}
	
	span.mailbox-attachment-icon, .mailbox-attachment-info {
    box-shadow: 0 -1px 4px rgba(0,0,0,0.3);
	}

	span.mailbox-attachment-icon {
		box-shadow: 1 3px 2px rgba(0,0,0,0.3);
	}
</style>
@endsection

@section('content')
	
	@php
		$link_retard = route('disciplinary.create').'?m-act=re';
		$link_absent = route('disciplinary.create').'?m-act=ab';
		$link_convoc = route('disciplinary.create').'?m-act=cv';
		$link_commen = route('disciplinary.create').'?m-act=cm';
	@endphp
	
	<div class="col-md-12 col-md-offset-0">
          <div class="box box-primary">
            <div class="box-header with-border">
              <h3 class="box-title"> Situation du jour [ <a title="cliquez ici pour avoir la liste de tous les cas du jours" href="{{route('scholar.eleves.inscrits')}}">{{$nbr_abs}} Absences, {{$nbr_ret}} Retards, {{$nbr_com}} Mauvaises conduites </a>]</h3>

            </div>
            <!-- /.box-header -->
            <div class="box-body no-padding">
              
            </div>
            <!-- /.box-body -->
            <div class="box-footer">
              <ul class="mailbox-attachments clearfix col-md-12">
                <li>
                  
                  <div class="mailbox-attachment-info">
                    <a href="{{$link_retard}}" class="mailbox-attachment-name"><i class="fa fa-clock-o"></i> Marquer Retards</a>                        
                  </div>
				  
				  <a href="{{$link_retard}}" >
					<span class="mailbox-attachment-icon"><i class="fa fa-clock-o text-yellow"></i></span>
				  </a>
				  
				  <p style="padding: 10px;">
				  Les eleves sont-ils en retard? cliquez <a href="{{$link_retard}}" >ici</a> puis, scannez leurs cartes ou indiquez leurs noms et notifiez leurs retards aux parents.</p>
                </li>
                <li>
				  <div class="mailbox-attachment-info">
                    <a href="{{$link_absent}}" class="mailbox-attachment-name"><i class="fa fa-user-times"></i> Marquer Absence</a>
                  </div>
				  
				  <a href="{{$link_absent}}" class="mailbox-attachment-name">
					<span class="mailbox-attachment-icon"><i class="fa fa-user-times text-yellow"></i></span>
				  </a>
                  <p style="padding: 10px;">
				  Les eleves sont-ils absents? cliquez <a href="{{$link_absent}}" >ici</a> puis, indiquez leurs noms et notifiez leurs absents aux parents.</p>
                </li>
                <li>
                  <div class="mailbox-attachment-info">
                    <a href="{{$link_commen}}" class="mailbox-attachment-name"><i class="fa fa-thumbs-down"></i> Mauvaise Conduite</a>                        
                  </div>
				  
				  <a href="{{$link_commen}}" class="mailbox-attachment-name">
					<span class="mailbox-attachment-icon"><i class="fa fa-thumbs-down text-red"></i></span>
				  </a>

                  <p style="padding: 10px;">
				  Les eleves se sont mal conduit? cliquez <a href="{{$link_commen}}">ici</a> puis, scannez leurs cartes ou indiquez leurs noms et notifiez leurs mauvaises conduites aux parents.</p>
                </li>
              </ul>
			  
              <ul class="mailbox-attachments clearfix col-md-12">
                <li>
                  <div class="mailbox-attachment-info">
                    <a href="{{$link_convoc}}" class="mailbox-attachment-name"><i class="fa fa-bullhorn"></i> Convoquer Parents</a>                        
                  </div>
				  <a href="{{$link_convoc}}" >
					<span class="mailbox-attachment-icon"><i class="fa fa-bullhorn text-green"></i></span>
				  </a>
                  <p style="padding: 10px;">
				  Les eleves sont-ils en retard? cliquez <a href="{{$link_convoc}}" >ici</a> puis, scannez leurs cartes ou indiquez leurs noms et notifiez leurs retards aux parents.</p>
                </li>
                <li>
				  <div class="mailbox-attachment-info">
                    <a  href="{{route('disciplinary.dossier')}}" target=_blank class="mailbox-attachment-name"><i class="fa fa-folder-open"></i> Dossier de conduite</a>
                  </div>
					<a  href="{{route('disciplinary.dossier')}}" target=_blank >
						<span class="mailbox-attachment-icon"><i class="fa fa-folder-open text-light-blue"></i></span>
					</a>
                  <p style="padding: 10px;">
				  Les eleves sont-ils absents? cliquez <a  href="{{route('disciplinary.dossier')}}" target=_blank >ici</a> puis, indiquez leurs noms et notifiez leurs absents aux parents.</p>
                </li>
                <li>
                  <div class="mailbox-attachment-info">
                    <a href="{{route('disciplinary.rapport')}}" class="mailbox-attachment-name"><i class="fa fa-line-chart"></i> Rapports</a>                        
                  </div>
				  <a href="{{route('disciplinary.rapport')}}" >
					<span class="mailbox-attachment-icon"><i class="fa fa-line-chart"></i></span>
				  </a>
                  <p style="padding: 10px;">
				  Les eleves se sont mal conduit? cliquez <a href="{{route('disciplinary.rapport')}}">ici</a> puis, scannez leurs cartes ou indiquez leurs noms et notifiez leurs mauvaises conduites aux parents.</p>
                </li>
              </ul>
			  
            </div>
            <!-- /.box-footer -->
            
          </div>
          <!-- /. box -->
        </div>
	
	
@endsection

@section('script')
	
	
	<script>

	</script>
	
	
	
@endsection