@extends("template")

@section('autre-menu-list')
	@include('mes_vues.Payment.partials._autre_menu')
@endsection

@section('style')
	<link href="{{asset('css/select2.min.css')}}" rel="stylesheet">
	
	<style>
		.fa-gears.active {
			color: green;
		}
		.fa-gears {
			color: #0080007a;
		}
		.table-bordered > thead > tr > th, .table-bordered > tbody > tr > th, .table-bordered > tfoot > tr > th, .table-bordered > thead > tr > td, .table-bordered > tbody > tr > td, .table-bordered > tfoot > tr > td{
			border:solid 1px #000;color:#000;
		}
		.table-hover > tbody > tr:hover {
				background-color: #91f7ff;
		}
		.table-bordered {
				border: 1px solid #000;
		}
		.select2-container--default .select2-selection--multiple .select2-selection__choice{
		    color: #3e3e3e;
		}
	</style>
@endsection

@section('content')
<div class="col-md-offset-0 col-md-12" >
	<h3 class="box-title" 
				style="margin: 0;font-weight: bold;color: #009abf;font-size: 24px;margin-bottom: 10px;">Souscrire des élèves à un frais
	</h3>
	<div class="row-fluid">
	{{display_flash()}}
	<div class="box col-md-12" stylee="background: #eff8ff;box-shadow: 0 1px 1px rgba(0,0,0,0.1);margin: 5px;border-radius: 4px;">
		
		<div class="box-body"  style='display:nonee'>
    		<form method="get"  class=" row form-horizontal" action="{{route('payment.frais.optionnel')}}" style="padding: 5px;background: #ff00002e;">
    		    <div class="form-group" id='div-all_classes'>
					
					<div class="col-sm-5">
					    <label for="input-ms_classe_id-id" style="text-align: left;" class="col-sm-12 control-label">Choisir les Classes dans lesquelles vous voulez souscrire les élèves </label>
					    <select style='width:100%' name="ms_classe_id[]"  multiple="multiple" id="input-ms_classe_id-id"  class="form-control select2">
							@foreach($msClasses as $e)
							<option value="{{$e->id}}">{{$e->classe.' '.$e->msPromotion->promotion.' '.$e->msPromotion->section->nom_sec}}</option>
							@endforeach
						</select> 
					</div>
        			<div class="col-sm-4">
					    <label for="input-mp_frais_id-id" class="col-sm-12 control-label" style="text-align:left" >Choisir frais souscrits </label>
						<select  style='width:100%' name="mp_frais_id[]" multiple id=""  class="form-control select2">
							@foreach($mpFraiss as $e)
							<option value="{{$e->id}}">{{$e->mpTypeFrais->type}} {{$e->frais.' '.$e->devise}}</option>
							@endforeach
						</select>
					</div>
					<div class="col-sm-3 ">						
						<button type="submit" class="btn btn-info pull-right">Afficher les élèves</button>
					</div>
				</div>
			</form>
			
			<br/>
			@if($msEleves)
    		<form method="POST"  class="form-horizontal" action="{{route('payment.frais.optionnel')}}" >
    			@csrf
    			<div class="row" style="background: #00800033;">
        			<div class="form-group col-md-6 " style="margin: 0px;">
        				
        				<div class="form-group" id='form-group-mp_frais_id'>
        					<label for="input-mp_frais_id-id" class="col-sm-12 control-label" style="text-align:left" >Choisir frais auquel souscrire </label>
        					<div class="col-sm-12">
        						<select  style='width:100%' name="mp_frais_id[]" multiple id="input-mp_frais_id-id"  class="form-control select2">
        							@foreach($mpFraiss as $e)
        							<option value="{{$e->id}}">{{$e->mpTypeFrais->type}} {{$e->frais.' '.$e->devise}}</option>
        							@endforeach
        						</select>
        					</div>
        				</div>
        			</div>
        			
        			<div class="col-md-6 border-left" style="padding: 5px 5px 5px 0;">
        				
        				<div class="form-group">
        					<label for="input-ms_classe_id-id"  style="text-align:left" class="col-sm-12 control-label">
        					    Ce frais ne sera imposable qu'auprès des élèves sélectionnés ci-dessus. 
        					</label>
        
        					<div class="col-sm-12">						
        						<button type="submit" class="btn btn-info pull-right">Valider la creation du frais</button>
        					</div>
        				</div>
        				
        			</div>
    		    </div>
    		    
    			<br/>
    		    <table id="datatable-mpfraisclasses" class="table table-striped table-bordered table-condensed editable-table">
        			<thead>
        				<tr>
        					
        					<th>Num</th>
        					<th><input type="checkbox" id="tout-cocher" title="cocher toutes les lignes visible"/></th>
        					<th>FRAIS</th>
        					<th>MAT</th>
        					<th>ELEVES</th>
        					<th>GENRE</th>
        					<th>CLASSE</th>
        				</tr>
        			</thead>
        			<tbody>
        			@foreach($msEleves as $key => $e)
        			<tr>			
        				<td>{{ $loop->index+1}}</td>
        				<td><input type="checkbox" name="ms_eleve_id[]" class="cocher-frais" value="{{$e->id}}"/></td>
        				<td>{{ $e->frais }}</td> 
        				<td>{{ $e->matricule }}</td>
        				<td>{{ $e->nom.' '.$e->postnom.' '.$e->prenom }}</td>
        				<td>{{ $e->genre }}</td>
        				<td>{{ $e->classe }}</td>
        			</tr>
        			@endforeach
        			</tbody>
        		</table>
        		
    		</form>
    		@endif
		</div>
		
	</div>
	</div>
	
	
<!-- /.row -->
</div>
@endsection


@section('script')
	<script src="{{asset('js/select2.full.min.js')}}"></script>

	<script>
		$(".select2").select2();
		$(function(){
			$("#datatable-mpfraisclasses").DataTable({"lengthMenu": [[10, 25, 50,100,500, -1], [10, 25, 50,100,500, "Tout"]],"pageLength": 500});
			$('#tout-cocher').click(function(){
			    $('.cocher-frais').each(function(){
    				if($(this).is(':checked')){	
    					$(this).prop('checked', false);	
    				}
    				else{
    					$(this).prop('checked', true);
    				}
			    })
			})
			
			
		});
	</script>

@endsection