@extends("template")

@section('autre-menu-list')
	@include('mes_vues.Payment.partials._autre_menu')
@endsection

@section('content')

	
<div class="col-md-10 col-md-offset-1">
	<div class="box">
		<div class="box-header with-border">
			<h3 class="box-title">Liste des frais : {{ \App\Config::getAnnee() }}</h3>
		</div>
		<!-- /.box-header -->
		<div class="box-body">
					<table class="table table-striped table-bordered">
							<thead>
									<tr>
										
										<th>Libelle</th>
										<th>Type Frais</th>
										<td colspan="3">Actions</td>
									</tr>
							</thead>
							<tbody>
							@foreach($mpfraiss as $key => $value)
									<tr>
										
										<td>{{ $value->frais }}</td>
										<td>{{ $value->mpTypeFrais->type }}</td>

											<!-- we will also add show, edit, and delete buttons -->
											<td>
												<a class="btn btn-small btn-danger btn-xs" 
												href="{{ route('payment.en_ordre.non',['id_frais'=>$value->id ]) }}">Elèves non en ordre</a>

											</td>
											<td>
												<a class="btn btn-small btn-info btn-xs" href="{{ route('payment.en_ordre.tou',['id_frais'=>$value->id ]) }}">Tous les élèves</a>
											</td>
											<td>
												<a class="btn btn-small btn-success btn-xs" href="{{ route('payment.en_ordre.oui',['id_frais'=>$value->id ]) }}">Elèves en ordre</a>
											</td>
									</tr>
							@endforeach
							</tbody>
					</table>
		
		</div>
	</div>
</div>

{{--
	<div class="col-md-4">
          <!-- Info Boxes Style 2 -->
          <div class="info-box bg-yellow">
            <span class="info-box-icon"><i class="ion ion-ios-pricetag-outline"></i></span>

            <div class="info-box-content">
              <span class="info-box-text">Inventory</span>
              <span class="info-box-number">5,200</span>

              <div class="progress">
                <div class="progress-bar" style="width: 50%"></div>
              </div>
              <span class="progress-description">
                    50% Increase in 30 Days
                  </span>
            </div>
            <!-- /.info-box-content -->
          </div>
          <!-- /.info-box -->
          <div class="info-box bg-green">
            <span class="info-box-icon"><i class="ion ion-ios-heart-outline"></i></span>

            <div class="info-box-content">
              <span class="info-box-text">Mentions</span>
              <span class="info-box-number">92,050</span>

              <div class="progress">
                <div class="progress-bar" style="width: 20%"></div>
              </div>
              <span class="progress-description">
                    20% Increase in 30 Days
                  </span>
            </div>
            <!-- /.info-box-content -->
          </div>
          <!-- /.info-box -->
          <div class="info-box bg-red">
            <span class="info-box-icon"><i class="ion ion-ios-cloud-download-outline"></i></span>

            <div class="info-box-content">
              <span class="info-box-text">Downloads</span>
              <span class="info-box-number">114,381</span>

              <div class="progress">
                <div class="progress-bar" style="width: 70%"></div>
              </div>
              <span class="progress-description">
                    70% Increase in 30 Days
                  </span>
            </div>
            <!-- /.info-box-content -->
          </div>
          <!-- /.info-box -->
          <div class="info-box bg-aqua">
            <span class="info-box-icon"><i class="ion-ios-chatbubble-outline"></i></span>

            <div class="info-box-content">
              <span class="info-box-text">Direct Messages</span>
              <span class="info-box-number">163,921</span>

              <div class="progress">
                <div class="progress-bar" style="width: 40%"></div>
              </div>
              <span class="progress-description">
                    40% Increase in 30 Days
                  </span>
            </div>
            <!-- /.info-box-content -->
          </div>
          <!-- /.info-box -->

        </div>
				--}}
@endsection
