@extends("main")

@section('style')
	<link href="{{asset('css/select2.min.css')}}" rel="stylesheet">
	<style>
		.mailbox-attachments li{
			width:32%;
		}
		li .mailbox-attachment-icon{
			height: 172px;
		}
		.select2-selection.select2-selection--single {
		  height: 34px;
		}
	</style>
@endsection

@section('content')
	
	
	@php 						
		$tabIdsClas=[];
		$tabIdsPromos=[];
		foreach($msClasses as $cl){
			$tabIdsClas[]=$cl->id;
			$tabIdsPromos[$cl->ms_promotion_id]='';
		}
		$tabIdsPromos = array_keys($tabIdsPromos);
	@endphp
	
	<div class="col-md-2 col-md-offset-1">
		<div class="box box-primary" style="min-height:600px;">
            <div class="box-header with-border" style="background:#3c8dbc;color: #fff;">
              <h3 class="box-title" style="font-weight: bolder;"> Parametres</h3>
            </div>
            <!-- /.box-header -->
            <div class="box-body" style="background: #fff;" title="Indiquer les Périodes sur lesquelles vous souhaitez travailler">
			
			  <i class="glyphicon glyphicon-edit"></i> Période
			  <select id="select-travaux-ok" multiple=multiple style="min-width:100%;color:red">
				<option value=1 >1 Période</option>
				<option value=2 >2 Période</option>
				<option value=3 >1 Examen</option>
				<option value=4 >3 Période</option>
				<option value=5 >4 Période</option>
				<option value=6 >2 Examen</option>
				<option value=7 >4 Période</option>
				<option value=8 >5 Période</option>
				<option value=9 >3 Examen</option>
			  </select>	
			  
			  
			</div>
			<div class="box-footer"  title="Indiquer les classes sur lesquelles vous souhaitez travailler">
			
				<i class="glyphicon glyphicon-edit"></i> Classes 
				<select id="input-ms_classe_id-grille-delib" multiple style="width:100%;"></select>
			
			</div>
			<div class="box-footer"  title="Indiquer les classes sur lesquelles vous souhaitez travailler">
			
				<i class="glyphicon glyphicon-edit"></i> Format du bulletin
				
				<select name="format" class="form-control" id="select-format">
					<option value=primaire >Primaire</option>
					<option value=ed_base >Education de Base</option>
					<option value=secondaire >Secondaire</option>
				</select>
			</div>
		</div>
	</div>
	<div class="col-md-8">
          <div class="box box-primary" style="border: solid 2px #fff;background:none;">
            <div class="box-header with-border"  style="background:#fff">
              <h3 class="box-title" style="width: 100%;"> Elaboration automatique des bulletins </h3>
            </div>
            <!-- /.box-header -->
            <div class="box-body no-padding">
              
            </div>
            <!-- /.box-body -->
            <div class="box-footer" style="background:none">
				<div class="col-md-6">
				  <!-- Application buttons -->
				  <div class="box">
					<div class="box-header  with-border">
						<h3 class="box-title" style="width: 100%;"><b>
							{{$nombre_cours}} cours </b>
							<a href="#" id="link-1-voir-cours-classe" style="float: right;display:none" title="Cliquez pour voir les cours des classes">Cours</a>
						</h3>
						
					</div>
					<div class="box-body" style="text-align:center">
					
					<div class="col-md-6">
					  <a class="btn bg-maroon margin btn-app" id="download-grille-cours">
						<i class="fa fa-cloud-download "></i> Extraire
					  </a>
					  <p>Telecharger les grilles des cours par classe, et indiquez pour chaque classe les cours enseignants.</p>
					</div>
					<div class="col-md-6">
					  <label for="input-cours-select" class="btn btn-app bg-olive margin">
						<i class="fa fa-cloud-upload"></i> Rentrer
					  </label>
					  <p>Uploader les grille des cours, pour mettre a jour la liste des cours dans chaque classe au niveau du systeme.</p>
					</div>
					
					</div>
					<!-- /.box-body -->
				  </div>
				</div>
				<div class="col-md-6">
				  <!-- Application buttons -->
				  <div class="box">
					<div class="box-header  with-border">
					  <h3 class="box-title">Fiches des Cotes : [ <b id="nombre-cote">-</b> cotes ]  </h3>
					</div>
					<div class="box-body" style="text-align:center">
					
						<div class="col-md-6">
						  <a class="btn bg-maroon margin btn-app" id="download-grille-cotes">
							<i class="fa fa-cloud-download "></i> Extraire
						  </a>
						  <p>Telecharger les fiches des cotes pour chaque cours</p>
						  
						</div>
						<div class="col-md-6">
						  <label for="input-cotes-select" class="btn btn-app bg-olive margin grille-cotes">
							<i class="fa fa-cloud-upload"></i> Rentrer
						  </label>
						  
						  <p>Uploader la grille des cotes remises par les enseignants, pour mettre a jour les cotes des eleves dans le systeme.</p>
						</div>					
					</div>
					<!-- /.box-body -->
				  </div>
				</div>
			</div>
            
			<div class="box-footer" style="background:none">
				<div class="col-md-6">
				  <!-- Application buttons -->
				  <div class="box">
					<div class="box-header  with-border">					  
						<h3 class="box-title" style="width: 100%;"> <b>
							
							Grilles de Déliberation: </b> 
							
						</h3>
					</div>
					<div class="box-body" style="text-align:center">
					
					<div class="col-md-6">
					  <a class="btn bg-maroon margin btn-app" id="download-grille-delib">
						<i class="fa fa-cloud-download "></i> Extraire
					  </a>
					  <p>Télécharger la grille des promotions, puis indiquez a cote de chaque promotion les noms des classes organisees</p>
					</div>
					<div class="col-md-6">
					  <label for="input-cotes-select" class="btn btn-app bg-olive margin grille-delib">
						<i class="fa fa-cloud-upload"></i> Rentrer
					  </label>
					  
					  <p>Uploader la grille des promotions, pour mettre a jour la liste des classes dans le systeme.</p>
					</div>
					
					</div>
					<!-- /.box-body -->
				  </div>
				</div>
				<div class="col-md-6">
				  <!-- Application buttons -->
				  <div class="box">
					<div class="box-header  with-border">
					  <h3 class="box-title">BULLETINS periodiques & annuels</h3>
					</div>
					<div class="box-body" style="text-align:center">
					
					<div class="col-md-6">
					  <a class="btn bg-maroon margin btn-app" target="_blank" href="{{route('report.mini')}}" id="link-print-mini-bulletin">
						<i class="glyphicon glyphicon-list-alt"></i> Petit Bulletin
					  </a>
					  <p>Proclamation periodique, produisez des petits bulletins sur deux periode et un examen.</p>
					</div>
					<div class="col-md-6">
					  <a class="btn btn-app bg-olive margin" target="_blank" href="{{route('report.grand')}}" id="link-print-grand-bulletin">
						<i class="glyphicon glyphicon-list-alt"></i> Grand Bulletin
					  </a>
					  <p>Proclamation annuelle, produisez des grand bulletins.</p>
					</div>
					
					</div>
					<!-- /.box-body -->
				  </div>
				</div>
			</div>
            
          </div>
          <!-- /. box -->
        </div>
	
	<a href="#" download='ch' style="display:none" id="link-download-grille-cote">Download</a>
	<a href="#" style="display:none" id="link-voir-cours-classe" target="_blank">Download</a>

	<form enctype="multipart/form-data" style='display:none' id="form4" action="{{route('report.import.cours')}}" method="POST">
		{{csrf_field()}}
		<input  name="ms_classe_id" id="input-ms_classe_id-select" type="hidden" value="all" />
		<input  name="select_file[]" multiple id="input-cours-select" type="file" style="display:none;" />
	</form>
	
	<form enctype="multipart/form-data" target="_blank" id='form3' class="form-horizontal col-sm-5" action="{{route('report.import.cotes')}}" style='display:none' method="POST">
		{{csrf_field()}}
		<input  name="select_file[]" multiple id="input-cotes-select" type="file" />
		<input type='hidden' name=grilleSyn id="input-grilleSyn"/>
		<input type='hidden' name=travail id="input-grilleSyn-travail"/>
		
		<select id="selected-travaux-ok" name="travaux[]"  multiple=multiple style="width:100%;height:200px;font-size: 18px;">
			<option id="trav-1" value=1  >1 Période</option>
			<option value=2 >2 Période</option>
			<option value=3 >1 Examen</option>
			<option value=4 >3 Période</option>
			<option value=5 >4 Période</option>
			<option value=6 >2 Examen</option>
			<option value=7 >4 Période</option>
			<option value=8 >5 Période</option>
			<option value=9 >3 Examen</option>
		</select>	
	</form>
	
		
		
@endsection

@section('script')
	
	<script src="{{asset('js/select2/select2.full.js')}}?d=sgssd"></script>
	
	<script>

	function download_grille_cotes(tabClas=[]){
		var str = tabClas.join('-')
		var url = "{{route('report.get.cours.ids')}}?cls="+str;
		
		var link = document.getElementById("link-download-grille-cote");
		
		$.get(url,function(data){
			console.log(data);
			var url = "{{asset('export/grille/cote/')}}";
			for(i in data){
				if (i%20==0 && i!=0){
					if(!confirm(i+' fichier telecharges.\n Voulez-vous continuer ?'))
						return true;
				}
				id = data[i];
				href = url+'/'+id;
				
				link.setAttribute('href',href);
				link.click();
			}	
			alert(data.length+' grilles de cours ont été téléchargées');
		});
	}

	function download_grille_cours(){
		var url = "{{asset('export/grille/cours/')}}";
		
		var link = document.getElementById("link-download-grille-cote");
		var tab = []
		var tabIdCls = $('#input-ms_classe_id-grille-delib').val();
		
		if(!tabIdCls.length && confirm('Voulez-vous les grilles de cours de cours de toutes les classes ?'))
			tab =  [ {{implode(',',$tabIdsPromos)}} ];
		else if(tabIdCls.length){
			tab = [];var id_pr;
			for(i in tabIdCls){
				idCl = tabIdCls[i];
				id_pr = $("#input-ms_classe_id-grille-delib option[value='"+idCl+"']").attr("id_promo");
				if( tab.indexOf( id_pr ) == -1)
					tab.push(id_pr);
			}			
		}
		else alert("Telechargement annulé");
		
		console.log(tab, tabIdCls);
		if(!tab.length)
			return 0
		
		for(i in tab){
			id = tab[i];
			href = url+'/'+id;
			link.setAttribute('href',href);
			link.click();
		}	
		alert(tab.length+' grilles de cours ont été téléchargées');
	}

	
	// telecharger les grille de cote
	function download_grille_synth(aveCode=true){
		var sameFile = false;
		var id_cls = $("#input-ms_classe_id-grille-delib").val();
		if(id_cls.length==0){
			if(confirm('vous allez télécharger les grilles de toutes les classes? ')){				
				tab = [ {{implode(',',$tabIdsClas )}} ];
				sameFile = confirm('Souohaitez-vous avoir toutes les grille dans un meme fichier.? ');
			}			
			else {
				alert("Veuillez alors indiquez une classe SVP!");
				return ;
			}	
		}
		else tab = id_cls;
				
		var travaux = $('#select-travaux-ok').val();
		if(travaux.length==0 && !confirm('Voulez-vous les grilles de toutes les période? ')){
			alert("Indiquez une période SVP!");
			return;
		}
		aveCode+='/'+travaux.join('-');
		
		var url = "{{asset('export/grille/synth/')}}";
		var link = document.getElementById("link-download-grille-cote");
		if(sameFile){
			tab = ['all']
		}
		
		for(i in tab){
			id = tab[i];
			href = url+'/'+id+'/'+aveCode;
			link.setAttribute('href',href);
			link.click();
		}
		var msg = tab.length==1?'La grille a été téléchargée':'Toutes les grilles ont été téléchargées';
		alert(msg);
		
	}
	
	$(function(){
		
		
		$.get("{{route('report.get.nombre.cote')}}",function(data){		
			console.log(data)
			$("#nombre-cote").html(data);
		});
		
		// ========= SELECT PARAMETES==========
		$("#select-format").select2()
		
		$("#select-travaux-ok").select2({			
		  placeholder: "Filtrer les periodes svp!",
		  allowClear: true
		})
		$('#select-travaux-ok').change(function(){
			$('#selected-travaux-ok').val($('#select-travaux-ok').val())
		});
		
		$('#input-ms_classe_id-grille-delib').select2({
		  placeholder: "Saisissez une classe SVP",
		  allowClear:true,
		  ajax: {
			url: "{{route('scholar.select.classe.ajax')}}",
			processResults: function (data) {
			  // Transforms the top-level key of the response object from 'items' to 'results'
			  console.log(data);
			  return {
				results: data.items
			  };
			}
		  }
		});
		
		$('#input-ms_classe_id-grille-delib').change(function(){
			$('#link-1-voir-cours-classe').show();
			var t = $(this).val().length;
			var text = (t==0)?'':((t==1)?'Cours': ('Cours de '+t+" classes"));
			$('#link-1-voir-cours-classe').text( text );
			
		});
		// ========== FIN SELECT2 ==================
		
		
		
		// ============ EXTRACTION DES GRILLES ==================
		$("#download-grille-delib").click(function(){
			download_grille_synth();
		})
		
		$("#download-grille-cours").click(function(){
			download_grille_cours();			
		})
		
		
		$("#download-grille-cotes").click(function(){
			var t = $('#input-ms_classe_id-grille-delib').val()
			if(t.length==0 && confirm('Voulez-vous les grilles de cotes de tous les cours et dans toutes les classes ?'))
				download_grille_cotes();
			else if(t.length!=0){
				download_grille_cotes(t);
			}
			else alert("Telechargement annulé");			
		})
		// =============== FIN EXTRACTION ======================
		
		
		// ================ SAUVEGARDE DES COURS =================
		$("label[for='input-cours-select']").click(function(){
			$("#input-cours-select").val('');
		})
		$("#input-cours-select").change(function(){
			var grille = $("#input-cours-select").val();
			if(grille){
				if(confirm('Voulez-vous envoyer les fichier selectionnés ?'))
					document.getElementById('form4').submit();
				else alert("Envoi annulé");
			}
			//else alert('Selectionnez la grille SVP!');
		})
		// ============== FIN SAUVEGARDE ==================
		
		// =============== SAUVEGARDE DES COTES =====================
		// ==========================================================
		// =============== SELECTION GRILLE DE COTES =================
		$("label[for='input-cotes-select'].grille-cotes").click(function(){
			$("#input-cotes-select").val('');
			$('#input-grilleSyn').val('no');
		})
		// =============== SELECTION GRILLE DE DELIBERATION ================
		$("label[for='input-cotes-select'].grille-delib").click(function(){
			$("#input-cotes-select").val('');
			$('#input-grilleSyn').val(confirm("Les cotes sont-elles dans une meme fichier.?")?'all-class':'yes');
		})
		// ============== ENVOI DU FORMULAIRE COTES OU DELIBERATION ========
		$("#input-cotes-select").change(function(){
			var grille = $("#input-cotes-select").val();
			if(grille){
				if($('#selected-travaux-ok').val().length){
					if(confirm('Voulez-vous envoyer les fichier selectionnés ?')){
						document.getElementById('form3').submit();
					}
					else alert("Envoi annulé");					
				}
				else alert("Indiquer les periodes a mettre a jour SVP!");
			}
		})
		
		// =====================================================		
	
		
		
		
		// ================ IMPRESSION DES BULLETINS GRAND ET PETIT ================
		$('#link-print-mini-bulletin, #link-print-grand-bulletin').click(function(){
			var cls = ($('#input-ms_classe_id-grille-delib').val().join('&id[]='));
			cls = cls?('id[]='+cls):'';
			var format = $('#select-format').val();
			var trim = $('#select-travaux-ok').val();
			trim = trim.length==0?1:trim[0];
			$('#link-print-mini-bulletin').attr( "href","{{route('report.mini')}}?"+cls+"&travail="+trim+"&format="+format);
			$('#link-print-grand-bulletin').attr( "href","{{route('report.grand')}}?"+cls+"&travail="+trim+"&format="+format);
		})
		// ==================== AFFICHER LES COURS D'UNE CLASSE =====================
		$('#link-1-voir-cours-classe').click(function(){
			var t = $('#input-ms_classe_id-grille-delib').val()
			if(t.length){
				href = "{{route('report.voir.cours.classse')}}";
				var link = document.getElementById("link-voir-cours-classe");
				for(i in t){
					link.setAttribute('href',href+'/'+t[i]);
					link.click();
				}					
			}
		});
		
		
	})
		
		
	
	</script>
	
	
	
@endsection