@php 
  if(!isset($monnaie))
    $monnaie="USD";
@endphp
<section class="invoice">

      <!-- title row -->
      <div class="row" style="">
        <div class="col-xs-12">
          <h2 class="page-header">
            <i class="fa fa-money"></i> PRIME POUR 
			<strong>
				{{$sacategoriebulletin->libelle}}
			</strong>
			<small class="pull-right">Date: {{date('d/m/Y')}}</small>
          </h2>
        </div>
        <!-- /.col -->
      </div>
      <!-- info row -->
	  @if($sasalarie->personnel??false)
      <div class="row invoice-info">
        <div class="col-sm-4 invoice-col">Institution<address>
            <strong>{{\App\Config::getEcole()}}</strong><br>
            5, Femmes Katangaises<br>Lubumbashi/Haut-Katanga<br>
            Phone: (+243) 99 52 85 024<br>
            Email: kaniba@esisalama.org
          </address>
        </div>
        <!-- /.col -->
        <div class="col-sm-4 invoice-col">Agent<address>
            <strong>{{$sasalarie->personnel->noms??'Nom Agent'}}</strong><br>
			{{$sasalarie->personnel->adresse??'Adresse Agent'}} <br>
            Telephone: {{$sasalarie->personnel->telephone??'+243 -- -- -- ---'}}
            <br>
            Catégorie Agent : 
			<br><strong>{{$sasalarie->saCategorieBulletin->libelle??'Categorie PRIME'}}</strong><br></address>
        </div>
        <!-- /.col -->
		<style>
		#sal-div b{ display:inline-block; width:70px }
		</style>
        <div class="col-sm-4 invoice-col" style="color: #3c8dbc;" id="sal-div">
          <b>Salaire</b>
          <br><br>
          <b>Date</b> : {{$sapaiementsalaire->date_paiement??'En cours'}}<br>
          <b>Periode</b> : {{$sapaiementsalaire->periode??'2/22/2014 au  3/22/2014'}}<br>
          <b>Mois</b> :  
			@if($sapaiementsalaire??false)
			  {{$Mois[$sapaiementsalaire->mois??0]}} - {{$sapaiementsalaire->annee}}
			@else 
				Janvier-2019 
			@endif
        </div>
        <!-- /.col -->
      </div>
	  @endif
      <!-- /.row -->

      <!-- Table row -->
      <div class="row">
        <div class="col-xs-12 table-responsive">
          <table class="table table-striped table-bordered table-hover">
            <thead>
            <tr>
              <th>#</th>
              <th>Libelle</th>
              <th>Montant de base</th>
              <th>Quantité</th>
              <th>Gains</th>
			  <th>Retenus</th>
            </tr>
            </thead>
            <tbody>
			@php 
			$salaireBruteCalculer = 0;
			$totalRetenu = 0;
			$sorted = $sacategoriebulletin->saRubriqueCategorieBulletins->sortBy('saRubriquePaie.type');
			$dt = $sorted->values()->all();
			
			$saOperationSalaires = [];
			if($tt = $sasalarie->saOperationSalaires??false){
				foreach($tt as $op){
					$id_rub = $op->saRubriqueCategorieBulletin->id??0;
					$saOperationSalaires[$id_rub][] = $op;
				}
			}
			
			@endphp
			@foreach($dt as $rb_cat_bul)
			@php 
				$gain = false;
				$qte = $rb_cat_bul->qte_par_defaut;
				$val = ($rb_cat_bul->montant_de_base * $qte);
				if($rb_cat_bul->saRubriquePaie->type=='Gain'){
					$gain = true;
					$salaireBruteCalculer += $val;
				}
				else {
					if( isset($saOperationSalaires[$rb_cat_bul->id]) ){
						foreach($saOperationSalaires[$rb_cat_bul->id] as $rb_cat_bul_bis){
							$val += $rb_cat_bul_bis->montant;
							$qte++;
						}
					}
					$totalRetenu += $val;
				}
			@endphp
            <tr style="text-align:right" class="{{$gain?'text-light-blue':'text-red'}}">
              <td>{{$loop->index+1}}</td>
              <td style="text-align:left">{{$rb_cat_bul->saRubriquePaie->libelle}}</td>
              <td >{{chiffre($rb_cat_bul->montant_de_base)}} {{$monnaie}}</td>
              <td style="text-align:center">{{$qte}}</td>
			  @if($rb_cat_bul->saRubriquePaie->type=='Retenu')
				  <td>-</td><td>{{chiffre($val)}} {{$monnaie}}</td>
			  @else
				  <td>{{chiffre($val)}} {{$monnaie}}</td><td>-</td>
			  @endif
            </tr>
			@endforeach			           
            </tbody>
          </table>
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->

      <div class="row">
        <!-- accepted payments column -->
        <div class="col-xs-6">
		@if($sasalarie->personnel??false)
    <img class="no-print" alt="Visa" src="{{asset('img/sceau.png')}}" >
		  <p class="lead no-print">Methode de paiement: Cash</p>
          
          <p class="no-print text-muted well well-sm no-shadow" style="margin-top: 10px;float: left;">ce document fait l'objet d'un bulletin de paie, toute surcharge ou rature sur celui-ci l'annule.<br>
          </p>
		@endif
        </div>
		
        <!-- /.col -->
        <div class="col-xs-6">
          <p class="lead">Situation finale</p>

          <div class="table-responsive">
            <table class="table">
              <tbody><tr>
                <th style="width:50%">Total gains :</th>
                <th style="text-align:right">{{chiffre($salaireBruteCalculer)}} {{$monnaie}}</th>
              </tr>
              <tr>
                <th>Total retenus :</th>
                <th style="text-align:right">{{chiffre($totalRetenu)}} {{$monnaie}}</th>
              </tr>
              <tr style="border-top: solid 2px red; ">
                <th>Net a payer:</th>
              	@php 
				$net_apeyer = $salaireBruteCalculer - $totalRetenu;
				$_POST['TOT_NET'] += $net_apeyer; 
				$_POST['TOT_RET'] += $totalRetenu; 
				$_POST['TOT_ENV'] += $salaireBruteCalculer; 
				@endphp
                <th style="text-align:right">{{$net_apeyer<=0?"NET A PAYER NEGATIF":chiffre($net_apeyer)}} {{$monnaie}}</th>
			</tr>
            </tbody></table>
          </div>
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->

	  
</section>