@extends("template")

@section('autre-menu-list')
	@include('mes_vues.Scholar._autre_menu')
@endsection

@section('style')
	<link href="{{asset('css/select2.min.css')}}" rel="stylesheet">
	
	<style>
		.select2-container--default .select2-selection--single{
			height:34px;
		}
		
	#content-list {
	padding: 0;
	}
	.content {
	padding: 0;
	}
	.col-md-12.col-md-offset-0 {
	padding: 0;
	}
	</style>
@endsection
@section('content')

	@php display_flash(); @endphp
<div class="col-md-12 col-md-offset-0">
	<div class="col-md-4">
	
		<div class=" box box-warning box-solid collapsed-box">
			<div class="box-header with-border">
				<h3 class="box-title">Ajout d'un nouveau materiel ({{$materiels->count() }} en Stock)</h3>

				<div class="box-tools pull-right">
					<button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-plus"></i></button>
				</div>
				<!-- /.box-tools -->
			</div>
			<!-- /.box-header -->
			<div class="box-body" style="display:none">
				<form enctype="multipart/form-data" class="form-horizontal" action="" method="POST">
					@csrf
					<div class="form-group">
						<label for="input-atelier-id" class="col-sm-3 control-label">Atelier</label>

						<div class="col-sm-9">
							<select name="atelier_id" id="input-atelier-id"  class="form-control">
								<option value="">Choisir</option>
								@foreach($ateliers as $e)
								<option value="{{$e->id}}">{{($e->atelier??'')}}</option>
								@endforeach
							</select>
						</div>
					</div>
					<div class="form-group">
						<label for="input-atelier-id" class="col-sm-3 control-label">Materils</label>

						<div class="col-sm-9">
							<input  name="materiel" class="form-control" value="" id="input-materiel-id" type="text" placeholder=" Nom "> 
						</div>
					</div>
					<div class="form-group">
						<label for="input-model-id" class="col-sm-3 control-label">Model</label>

						<div class="col-sm-9">
							<input  name="model" class="form-control" value="" id="input-model-id" type="text" placeholder=" model"> 
						</div>
					</div>
					<div class="form-group">
						<label for="input-quantite-id" class="col-sm-3 control-label">Quantite</label>

						<div class="col-sm-9">
							<input  name="quantite" class="form-control" value="" id="input-quantite-id" type="text" placeholder=" Quantite"> 
						</div>
					</div>

					<div class="form-group">
						<label for="input-observation-id" class="col-sm-3 control-label">Observation</label>

						<div class="col-sm-9">
							<input  name="observation" class="form-control" value="" id="input--id" type="text" placeholder=" Observation "> 
						</div>
					</div>
					<button type="Submit" value="ok" name="ajouter_materiel" class="btn btn-success pull-right slider-ud">Enregistrer le materiel</button>
				</form>
			</div>
			<!-- /.box-body -->
		</div>
	
		<div class=" box box-info box-solid collapsed-box">
			<div class="box-header with-border">
				<h3 class="box-title">Approvisonner Stock</h3>

				<div class="box-tools pull-right">
					<button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-plus"></i></button>
				</div>
				<!-- /.box-tools -->
			</div>
			<!-- /.box-header -->
			<div class="box-body" style="display:none">
				<form enctype="multipart/form-data" class="form-horizontal" action="" method="POST">
					@csrf
					<div class="form-group">
						<label for="input-atelier-stock" class="col-sm-3 control-label">Materils</label>

						<div class="col-sm-9">
							<select name="materiel_id" id="input-materiel_id-stock"  class="form-control">
								<option value="">Choisir</option>
								@foreach($materiels as $e)
								<option value="{{$e->id}}">{{($e->materiel??'').' ['.($e->model??'').'] '.($e->quantite??'')}}</option>
								@endforeach
							</select>
						</div>
					</div>
					<div class="form-group">
						<label for="input-quantite-stock" class="col-sm-3 control-label">Quantite</label>

						<div class="col-sm-9">
							<input  name="quantite" class="form-control" value="" id="input-quantite-stock" type="text" placeholder=" Quantite"> 
						</div>
					</div>
					<div class="form-group">
						<label for="input-quantite-stock" class="col-sm-3 control-label">Renommer</label>

						<div class="col-sm-9">
							<input  name="rename" class="form-control" value="" id="input-quantite-stock" type="text" placeholder=" Nouveau nom"> 
						</div>
					</div>


					<button type="Submit" value="ok" name="approvisionner_materiel" class="btn btn-info pull-right slider-ud">Ajouter quantite</button>
				</form>
			</div>
			<!-- /.box-body -->
		</div>
	</div>

	<div class="col-sm-8 ">
		<form enctype="multipart/form-data" class="form-horizontal" action="" method="POST">
			@csrf
			
			<select class="form-control select22" required name="id_eleve[]" multiple="multiple" id="liste-eleves-select" style="width: 100%;">
			</select>		
				
			<div class="box box-info" style="margin-top: 5px;display:none" id="detail-eleve-selectionnes">
				<div class="box-header with-border" style="">
					<h2 style="" class="box-title">ALLOCATION DES MATERIELS</h2>
				</div>
				<div class="box-body" style="background: aliceblue;">
					<div class="col-xs-4">
					
						<div class="box box-primary">
							<div class="box-body box-profile">
								<p class="text-muted text-center">Elèves Choisis</p>
								<img id="img-eleve" class="profile-user-img img-responsive img-circle"
								src="{{asset('img/users25.png')}}" alt="User profile picture">


								<ul class="list-group list-group-unbordered editable-table" id="liste-eleves-ul">
									<!-- le conteneur des élèves qui paiement --> 
								</ul> 
								
								<!-- ce textarea contient le code d'ajout dynamique des élèves qui paient -->
								<textarea id="html-li-eleve" style="display:none">									
									<li id="eleve-__ID__" class="list-group-item">
										<b>__NOM__</b> </br>
										__IDTUT__ <a class="">__CLASS__</a> 
										<input name="eleve_id___ID__" value="__ID__" type="hidden"/>
									</li>
								</textarea>

				
							</div>
							<!-- /.box-body <a href="#" class="btn btn-primary btn-block"><b>Follow</b></a> -->
						</div>
					
					</div>
					<div class="col-xs-8" style="">
						
								
						<div class="form-group">
							<label for="input-materiel_id-id" class="col-sm-3 control-label">Materiel</label>

							<div class="col-sm-9">
								<select name="materiel_id[]" multiple id="input-materiel_id-id"  class="form-control">
									<option value="">Choisir</option>
									@foreach($materiels as $e)
									<option value="{{$e->id}}">{{($e->materiel??'').' ['.($e->model??'').'] '.($e->quantite??'')}}</option>
									@endforeach
								</select>
							</div>
						</div>
						
						<div class="form-group">
							<label for="input-quantite-id" class="col-sm-3 control-label">Quantite</label>

							<div class="col-sm-3">
								<input  name="quantite" class="form-control" value="" id="input-quantite-id" type="text" placeholder=" Quantite "> 
							</div>
							<label for="input-date_emprunt-id" class="col-sm-3 control-label">Date Emprunt</label>

							<div class="col-sm-3">
								<input  name="date_emprunt" class="form-control" value="{{ date('Y-m-y') }}" id="input-date_emprunt-id" type="date" placeholder=" Date Emprunt "> 
							</div>

						</div>

						<!--div class="form-group">
							<label for="input-qte_retour-id" class="col-sm-3 control-label">Qte Retour</label>

							<div class="col-sm-3">
								<input  name="qte_retour" class="form-control" value="" id="input-qte_retour-id" type="text" placeholder=" Qte Retour "> 
							</div>
							<label for="input-date_retour-id" class="col-sm-3 control-label">Date retour</label>

							<div class="col-sm-3">
								<input  name="date_retour" class="form-control" value="" id="input-date_retour-id" type="date" placeholder=" Date retour "> 
							</div>
						</div-->
						
						
						<!--div class="form-group">
							
								<label for="input-img_aller-id" class="col-sm-3 control-label">Image Aller</label>
							<div class="col-sm-3">
								<input  name="img_aller" class="form-control" value="" id="input-img_aller-id" type="file" placeholder=" Image Aller "> 
								@if(strstr(url()->current(),'edit')) 
									<input type='checkbox' title='mettre a jour le fichier?' name='chek_img_aller'> 
								@endif 
							</div>
								<label for="input-img_retour-id" class="col-sm-3 control-label">Image Retour</label>
							<div class="col-sm-3">
								<input  name="img_retour" class="form-control" value="" id="input-img_retour-id" type="file" placeholder=" Aller Retour "> 
								@if(strstr(url()->current(),'edit')) 
									<input type='checkbox' title='mettre a jour le fichier?' name='chek_img_retour'> 
								@endif 
							</div>
						</div-->

						<input type="submit" value="Allouer les Materiel" class="btn btn-success pull-right">
							
					</div>
				</div>
						
				<!-- /.box-body -->
				<div class="box-footer" style="text-align: right;">
					<i>Allouer les materiel avec 
					<span class="text-aqua">M-Scholar@Masomwetu </span>
					votre partenaire scolaire</i>
				</div>
			
			</div>
		</form>

	</div>

	<div class="col-md-12" style="margin-top:20px">
		
		<div class="box box-success box-solid">
			<div class="box-header with-border">
				<h3 class="box-title">LISTE DES MATERIELS DEJA ALLOUES</h3>

				<!-- /.box-tools -->
			</div>
			<!-- /.box-header -->
			<div class="box-body">
			<table id="datatable-empruntmateriels" style="overflow: auto;" class="table table-striped table-bordered table-condensed editable-table">
			<thead>
					<tr>
						
						<th>Mat.</th>
						<th>Eleve</th>
						<th>Genre</th>
						<th>Classe</th>
						<th>Materiel</th>
						<th>Quantite</th>
						<th>Date Emprunt</th>
						<th>Date retour</th>
						<th>Qte Retour</th>
						<th></th>
						<!--th>Image Aller</th>
						<th>Aller Retour</th>
						<th style="width:30px">Voir</th>
						<th style="width:30px">Modif.</th>
						<th style="width:30px">Supp.</th-->
					</tr>
			</thead>
			<tbody>
			@foreach($empruntmateriels as $key => $empruntmateriel)
				<tr>
						
						<td >{{ ($empruntmateriel->msEleve->enfant->matricule??'')}} </td>
						<td>{{($empruntmateriel->msEleve->enfant->nom??'').' '.($empruntmateriel->msEleve->enfant->postnom??'').' '.($empruntmateriel->msEleve->enfant->prenom??'')}} </td>
						<td>{{($empruntmateriel->msEleve->enfant->genre??'')}} </td>
						<td>{{($empruntmateriel->msEleve->msClasse->classe??'')}} </td>
						<td class='editable-td'  k='{{$empruntmateriel->id}}' f='materiel_id' i='74' t='select' s='Materiel' >{{ ($empruntmateriel->materiel->materiel??'')}}</td>
						<td class='editable-td' k='{{$empruntmateriel->id}}' f='quantite' i='74' t='number' >{{ $empruntmateriel->quantite }}</td>
						<td class='editable-td' k='{{$empruntmateriel->id}}' f='date_emprunt' i='74' t='date' >{{ $empruntmateriel->date_emprunt }}</td>
						<td class='editable-td' k='{{$empruntmateriel->id}}' f='date_retour' i='74' t='date' >{{ $empruntmateriel->date_retour }}</td>
						<td class='editable-td' k='{{$empruntmateriel->id}}' f='qte_retour' i='74' t='number' >{{ $empruntmateriel->qte_retour }}</td>
						<td>								
							<form style="margin: 0;" onsubmit="return confirm('Voulez-vous supprimer ?')" action="" method="POST">
								{{csrf_field()}}
								<label class="text-red" for="delete-dero-{{$empruntmateriel->id}}" k="1"><i class="glyphicon glyphicon-trash"></i></label>
								<button value="ok" id="delete-dero-{{$empruntmateriel->id}}" style="display:none" name="delete_emprunt" type="submit">Supp.</button>
								<input type="hidden" value="{{$empruntmateriel->id}}" name="id">
							</form></td>
						<!--td class='editable-td' k='{{$empruntmateriel->id}}' f='img_aller' i='74' t='file' ><img class='crud_img' src="{{ asset('storage/empruntmateriel/img_aller/'.$empruntmateriel->img_aller) }}" /></td>
						<td class='editable-td' k='{{$empruntmateriel->id}}' f='img_retour' i='74' t='file' ><img class='crud_img' src="{{ asset('storage/empruntmateriel/img_retour/'.$empruntmateriel->img_retour) }}" /></td>
	
						
					<td>
						<a class="btn btn-small btn-success btn-xs" href="{{ URL::to('empruntmateriels/' . $empruntmateriel->id) }}">Voir</a>
					</td>
					<td>
						<a class="btn btn-small btn-info btn-xs" href="{{ URL::to('empruntmateriels/' . $empruntmateriel->id . '/edit') }}">Modif.</a>
					</td>
					<td>								
						<form style="margin: 0;" onsubmit="return confirm('Voulez-vous supprimer ?')" action="{{route('empruntmateriels.destroy',$empruntmateriel)}}" method="POST">
							{{csrf_field()}}
							{{method_field('DELETE')}}
							<button class="btn btn-small btn-danger btn-xs" type="submit">Supp.</button>
							
						</form>
					</td-->
				</tr>
			@endforeach
			</tbody>
		</table>
			</div>
			<!-- /.box-body -->
		</div>
	</div>
</div>
					
@endsection

@section('script')
<script src="{{asset('js/select2/select2.full.js')}}?d=sgssd"></script>
	
	<script>
		Array.prototype.diff = function(a) {
			return this.filter(function(i) {return a.indexOf(i) < 0;});
		};
		var EX_TAB_FRAIS = [0];
		var EX_TAB_ELEVE = [0];
		// ajout dynamique des frais
		function addInput(values){
			values = values.diff( ["-"] );
			console.log(values);
			aucun_frais( !values.length );
			var html = $("#html-frais-input").val();
			var id , lbl, prix, i;
			for(i=0;i!=values.length;i++){
				id = values[i];
				// console.log("id:",id,"i:",i);
				lbl = $("#option-"+id).attr("lbl");
				typ = $("#option-"+id).attr("typ");
				prix = $("#option-"+id).attr("prix");
				
				if(! $("#frais-"+id).is('div') ){
					input = html.replace('__ID__',id);
					input = input.replace('__ID__',id);
					input = input.replace('__ID__',id);
					input = input.replace('__LBL__',lbl);
					input = input.replace('__PRIX__',prix);
					input = input.replace('__PRIX__',prix);
					input = input.replace('__TYPE__',typ);
					
					
					$("#les-frais-insc").append(input);
				}
			}		
			
			var tabDiff = EX_TAB_FRAIS.diff( values );
			
			for(i=0;i!=tabDiff.length;i++  )
				$("#frais-"+tabDiff[i]).remove();
			
			EX_TAB_FRAIS = values;
		}
		// ajout dynamique des élèves
		function addLi(values){
			values = values.diff( ["-"] );
			console.log(values);
			aucun_eleve( !values.length );
			var html = $("#html-li-eleve").val();
			var id , nom, classe, i,tel,IDTUT;
			for(i=0;i!=values.length;i++){
				id = values[i];
				// console.log("id:",id,"i:",i);
				nom = $("#option-eleve-"+id).attr("nom");
				tel = $("#option-eleve-"+id).attr("tel");
				IDTUT = $("#option-eleve-"+id).attr("IDTUT");
				classe = $("#option-eleve-"+id).attr("classe");
				$("#img-eleve").attr("src",$("#option-eleve-"+id).attr("img"));
				
				if(! $("#eleve-"+id).is('li') ){
					input = html.replace('__ID__',id);
					input = input.replace('__ID__',id);
					input = input.replace('__ID__',id);
					input = input.replace('__ID__',id);
					
					input = input.replace('__NOM__', '<a target="_blanc" href="{{route('payment.dossier.eleve')}}/'+id+'">'+nom+'</a>' );
					input = input.replace('__CLASS__',classe);
					if(IDTUT=='null'){
						input = input.replace('__IDTUT__',"<b class='ajouter-tuteur' k='0' f='telephone' i='3' el='"+id+"' >Pas de Tuteur</b>" );
					}
					else {
						input = input.replace('__IDTUT__',"<b style='color:blue' class='editable-td' k='"+IDTUT+"' f='telephone' i='3' t='text'>"+(tel?tel:'Pas de tel')+"</b>" );
					}
					$("#liste-eleves-ul").append(input);
				}
			}		
			
			var tabDiff = EX_TAB_ELEVE.diff( values );
			
			for(i=0;i!=tabDiff.length;i++  )
				$("#eleve-"+tabDiff[i]).remove();
			
			EX_TAB_ELEVE = values;
		}
		
		function aucun_eleve(val,vitesse=500){
			if (val){
				$('#detail-eleve-selectionnes').hide(vitesse);	 
			}
			else {
				$('#detail-eleve-selectionnes').show(vitesse);
			}
		}
		

		$(function(){
			$("#datatable-empruntmateriels").DataTable();
	
			$('#liste-eleves-select').change(function(){
				// alert($(this).val())
				addLi( $(this).val() );
				console.log($(this));
			});
			
			function repoFormatResult(repo) {
					console.log(repo);
			  var markup = '<div class="row-fluid">' +
				 '<div class="span2"><img src="' + repo.owner.avatar_url + '" /></div>' +
				 '<div class="span10">' +
					'<div class="row-fluid">' +
					   '<div class="span6">' + repo.full_name + '</div>' +
					   '<div class="span3"><i class="fa fa-code-fork"></i> ' + repo.forks_count + '</div>' +
					   '<div class="span3"><i class="fa fa-star"></i> ' + repo.stargazers_count + '</div>' +
					'</div>';

			  if (repo.description) {
				 markup += '<div>' + repo.description + '</div>';
			  }

			  markup += '</div></div>';

			  return markup;
		   }

		   function repoFormatSelection(repo) {
			  return repo.full_name;
		   }
		   
			$('#input-materiel_id-id, #input-materiel_id-stock').select2({
			  placeholder: "Indiquer le nom des matériel S.V.P!",
			  allowClear: true
			  
			});
		//
			$('#liste-eleves-select').select2({
			  placeholder: "Indiquer S.V.P! les noms des élèves pour leur attribuer les matreiel",
			  allowClear: true,
			  minimumInputLength: 3,
			  ajax: {
				url: "{{route('scholar.select.eleve.ajax')}}",
				processResults: function (data) {
				  // Transforms the top-level key of the response object from 'items' to 'results'
				  return {
					results: data.items
				  };
				},
				formatResult: repoFormatResult, // omitted for brevity, see the source of this page
				formatSelection: repoFormatSelection
			  }
			});
			
		})
	</script>
@endsection		