@extends("template")


@section('style')
	<link href="{{asset('css/select2.min.css')}}" rel="stylesheet">
	<style>
	/* Conteneur principal */
    .eleve-item {
        display: flex;
        align-items: center;
        gap: 12px;
        padding: 6px 4px;
    }
    
    /* Avatar */
    .eleve-avatar {
        flex-shrink: 0;
    }
    
    .eleve-avatar img {
        width: 42px;
        height: 42px;
        border-radius: 50%;
        object-fit: cover;
        border: 2px solid #e0e0e0;
        background: #fff;
    }
    
    /* Infos élève */
    .eleve-info {
        line-height: 1.3;
    }
    
    .eleve-nom {
        font-weight: 600;
        font-size: 14px;
        color: #222;
    }
    
    .eleve-meta {
        font-size: 12px;
        color: #555;
    }
    
    .eleve-tel {
        font-size: 12px;
        color: #0d6efd;
    }
    
    /* Hover Select2 */
    .select2-results__option--highlighted .eleve-item {
        background-color: #f1f5ff;
        border-radius: 6px;
    }
    .d-none {
      display: none !important;
    }
    
section.content {
  background: white;
  padding: 0;
}

	</style>
	
	<style>
.eleve-card {
    width: 300px;
    background: #f7f8fc;
    border-radius: 12px;
    box-shadow: 0 4px 12px rgba(0,0,0,0.15);
    overflow: hidden;
    font-family: 'Arial', sans-serif;
    margin: 10px auto;
    text-align: center;
}

.eleve-card img {
    width: 100%;
    height: 250px;
    object-fit: cover;
}

.eleve-card .eleve-info {
    padding: 15px;
}

.eleve-card .eleve-info h2 {
    font-size: 1.3em;
    margin: 5px 0;
    color: #333;
}

.eleve-card .eleve-info p {
    margin: 4px 0;
    font-size: 0.95em;
    color: #555;
}

.eleve-card .eleve-info .highlight {
    font-weight: bold;
    color: #2a2a72;
}

</style>

@endsection

@section('content')
<div class="panel panel-primary custom-card">
    <div class="panel-heading custom-card-header">
        <h5 class="panel-title">
            <span class="glyphicon glyphicon-education" aria-hidden="true"></span>
            Gestion cartes & fournitures élèves
        </h5>
    </div>
    <div class="panel-body">
        <div class="row">
            <div class="col-md-3">
                <div id="eleve-card-container" style="margin-top: 20px;"></div>
            </div>
            <div class="col-md-9">
                {{-- Sélection élèves --}}
                <div class="row">
                
                    <div class="col-md-6 mb-4">
                        <label><strong>Élèves concernés</strong></label>
                        <select class="form-control"
                                multiple
                                id="liste-eleves-select"
                                style="width:100%;">
                        </select>
                    </div>
                
                    <div class="col-md-6 mb-4">
                        <label><strong>Filtrer par classe (optionnel)</strong></label>
                        <select class="form-control"
                                multiple
                                id="liste-classes-select"
                                style="width:100%;">
                        </select>
                    </div>
                
                </div>
        
                <hr>
        
                {{-- 3 COLONNES --}}
                <div class="row">
        
                    {{-- Paiement carte --}}
                    <div class="col-md-4">
                        <div class="border p-3 rounded h-100">
                            <div class="form-check mb-3">
                                <input class="form-check-input" type="checkbox" id="chk_paiement">
                                <label class="form-check-label fw-bold" for="chk_paiement">
                                    Paiement de la carte
                                </label>
                            </div>
        
                            <div class="paiement-fields d-none">
                                <div class="form-group mb-3">
                                    <label>Date paiement</label>
                                    <input type="date" id="payer_carte_le" class="form-control">
                                </div>
        
                                <div class="form-group">
                                    <label>Montant payé</label>
                                    <input type="number" id="montant_carte" class="form-control" min="0">
                                </div>
                            </div>
                        </div>
                    </div>
        
                    {{-- Remise carte --}}
                    <div class="col-md-4">
                        <div class="border p-3 rounded h-100">
                            <div class="form-check mb-3">
                                <input class="form-check-input" type="checkbox" id="chk_remise">
                                <label class="form-check-label fw-bold" for="chk_remise">
                                    Remise de la carte
                                </label>
                            </div>
        
                            <div class="remise-fields d-none">
                                <div class="form-group">
                                    <label>Date remise carte</label>
                                    <input type="date" id="carte_remise_le" class="form-control">
                                </div>
                            </div>
                        </div>
                    </div>
        
                    {{-- Rame papier --}}
                    <div class="col-md-4">
                        <div class="border p-3 rounded h-100">
                            <div class="form-check mb-3">
                                <input class="form-check-input" type="checkbox" id="chk_rame">
                                <label class="form-check-label fw-bold" for="chk_rame">
                                    Dépôt rame papier
                                </label>
                            </div>
        
                            <div class="rame-fields d-none">
                                <div class="form-group">
                                    <label>Date dépôt rame</label>
                                    <input type="date" id="rame_papier_deposee_le" class="form-control">
                                </div>
                            </div>
                        </div>
                    </div>
        
                </div>
        
                <hr>
                
                <div class="checkbox mb-3" style="text-align: center;">
                    <label>
                        <input type="checkbox" id="chk_auto_scan">
                        <strong>Scanner et valider automatiquement</strong>
                    </label>
                </div>
        
                <div class="text-center mt-3">
                    <button class="btn btn-success me-2" id="btn-enregistrer">
                        💾 Enregistrer
                    </button>
                
                    <button class="btn btn-info " id="btn-rapport">
                        📊 Afficher le rapport
                    </button>
                    <button class="btn btn-danger  ms-2" id="btn-non-en-ordre">
                        🚨 Élèves NON en ordre
                    </button>
                    <button class="btn btn-info" id="btn-rapport-ordre">
                        📋 Afficher élèves en ordre
                    </button>
        
                    <button class="btn btn-warning" id="btn-annuler-tout">
                        ⚠️ Annuler opérations
                    </button>
        
        
                </div>
            </div>
        </div>
        <div class="mt-4 d-none" id="rapport-container">
            <div class="card shadow-sm">
                <div class="card-header bg-dark text-white">
                    <h6 class="mb-0">📊 Rapport carte & fournitures</h6>
                </div>
                <div class="card-body table-responsive">
                    <table class="table table-bordered table-hover align-middle" id="table-rapport">
                        <thead class="table-light">
                            <tr>
                                <th>Élève</th>
                                <th>Carte payée</th>
                                <th>Montant</th>
                                <th>Carte remise</th>
                                <th>Rame déposée</th>
                                <th>Statut</th>
                            </tr>
                        </thead>
                        <tbody></tbody>
                    </table>
                </div>
            </div>
        </div>

    </div>
</div>

<style>
/* Style personnalisé pour Bootstrap 3 */
.custom-card {
    border-radius: 6px;
    overflow: hidden;
    border-color: #17a2b8;
}

.custom-card-header {
    background: linear-gradient(90deg, #4e73df, #1cc88a);
    color: #fff !important;
    font-weight: bold;
    font-size: 16px;
    padding: 12px 20px;
    border-bottom: 3px solid #17a2b8;
    text-shadow: 0 1px 2px rgba(0,0,0,0.2);
}

.custom-card-header h5 {
    margin: 0;
}

.custom-card-header .glyphicon {
    margin-right: 8px;
}
</style>




@endsection

@section('script')
	<!--script src="{{asset('js/select2.full.min.js')}}"></script-->
	<script src="{{asset('js/select2/select2.full.js')}}?d=sgssd"></script>

    <script>  
    
        var barcode = '';
        var interval;
        function isNumeric(str) {
          if (typeof str != "string") return false // we only process strings!  
          return !isNaN(str) && // use type coercion to parse the _entirety_ of the string (`parseFloat` alone does not do this)...
                 !isNaN(parseFloat(str)) // ...and ensure strings of whitespace fail
        }
        
        function convert_int(c){
            var s='';
            var a = "&é\"'(-è_çà";
            var b = "1234567890";
            for (i in c){
                j=a.indexOf(c[i]); 
                if(j!=-1)s+=b[j];
                else s+=c[i]; 
                
            }
            return s;
            
        }
        function normalizeKeyboardNumbers(text) {
            const map = {
                '&':'1','é':'2','"':'3',"'":'4','(':'5','-':'6',
                'è':'7','_':'8','ç':'9','à':'0'
            };
        
            return text.replace(/[&é"'(-è_çà]/g, c => map[c]);
        }
    
    
        function extractTwoNumbers(text) {
            if (!text) return null;
        
            text = normalizeKeyboardNumbers(text);
        
            const nums = text.match(/\d+/g);
            if (!nums || nums.length < 2) return null;
        
            return {
                first: Number(nums[0]),
                second: Number(nums[1])
            };
        }
    
    
        document.addEventListener('keydown', function(evt) {
        if (interval) clearInterval(interval);
    
        if (evt.code == 'Enter') {
            if (barcode) {
                // Normalisation si nécessaire
                if(!isNumeric(barcode)) {
                    var barc = normalizeKeyboardNumbers(barcode);
                    if(barc) barcode = barc;
                }
    
                // ✅ Même si le curseur est dans le select, on force la sélection
                selectEleveByQR(barcode);
    
                // Vider le barcode pour le prochain scan
                barcode = '';
    
                // Empêche le comportement par défaut de l'input Select2
                evt.preventDefault();
                return;
            }
        }
    
        if (evt.key != 'Shift') barcode += evt.key;
        interval = setInterval(() => barcode = '', 20);
    });
    
    var elevesLocal = @json($items);
    window.selectEleveByQR = function (code) {
        if (!code || !elevesLocal || !elevesLocal.length) return;
    
        code = code.trim();
        console.log("QR scanné :", code);
    
        // 🔎 Recherche dans les données locales (data Select2)
        let found = elevesLocal.find(e => {
            if (!e.attrs) return false;
            return (
                e.text.includes(code) ||
                e.attrs.IDINSC == code ||
                e.attrs.IDELE == code ||
                e.attrs.MAT == code
            );
        });
    
        if (!found) {
            console.warn("Aucun élève trouvé pour :", code);
            return;
        }
    
        const $select = $('#liste-eleves-select');
    
        // 🔹 Valeurs actuellement sélectionnées (multiple)
        let selectedValues = $select.val() || [];
    
        // ⚠️ Déjà sélectionné → on sort
        if (selectedValues.includes(String(found.id))) {
            console.log("Élève déjà sélectionné :", found.text);
            return;
        }
    
        // ✅ Ajouter à la sélection SANS créer d'option
        selectedValues.push(String(found.id));
    
        $select
            .val(selectedValues)
            .trigger('change');
    
        // Carte élève (affichage visuel)
        renderEleveCard(found.attrs);
    
        // Event select2 manuel (si d'autres scripts écoutent)
        $select.trigger({
            type: 'select2:select',
            params: { data: found }
        });
        
        if($('#chk_auto_scan').is(':checked')) btn_enregistrer();
        
        console.log("Élève sélectionné via QR :", found.text);
    };


// Fonction pour générer la carte élève
function renderEleveCard(attrs) {
    if (!attrs) return;

    let html = `
        <div class="eleve-card">
            <img src="${attrs.img}" alt="Photo de ${attrs.nom}" />
            <div class="eleve-info">
                <h2>${attrs.nom}</h2>
                <p><span class="highlight">Classe:</span> ${attrs.classe}</p>
                <p><span class="highlight">Matricule:</span> ${attrs.mat || attrs.IDINSC}</p>
                <p><span class="highlight">Tuteur:</span> ${attrs.tut} (${attrs.lien})</p>
                <p><span class="highlight">Téléphone:</span> ${attrs.tel}</p>
            </div>
        </div>
    `;

    $('#eleve-card-container').html(html);
}

    
    
function getOperationsCochees() {
    return {
        paiement: $('#chk_paiement').is(':checked'),
        remise: $('#chk_remise').is(':checked'),
        rame: $('#chk_rame').is(':checked')
    };
}


function getSelectedEleves() {
    return $('#liste-eleves-select').val() || [];
}
function chargerRapport(ids) {
    $.ajax({
        url: '{{route("scholar.rapport.payer.carte")}}',
        type: 'POST',
        data: {
            ids: ids,
            _token: '{{ csrf_token() }}'
        },
        success: function (res) {
            afficherRapport(res);
        }
    });
}
function afficherRapport(data) {

    let operationsCochees = getOperationsCochees();
    let tbody = $('#table-rapport tbody');
    tbody.empty();

    data.forEach(e => {
        let statut = '';
        if (operationsCochees.paiement && operationsCochees.remise && operationsCochees.rame) {
            statut = (e.payer_carte_le && e.carte_remise_le && e.rame_papier_deposee_le)
                ? '<span class="badge bg-success">Complet</span>'
                : '<span class="badge bg-warning text-dark">Incomplet</span>';
        } else {
            // Vérifier seulement les colonnes cochées
            let complet = true;
            if (operationsCochees.paiement) complet = complet && e.payer_carte_le;
            if (operationsCochees.remise) complet = complet && e.carte_remise_le;
            if (operationsCochees.rame) complet = complet && e.rame_papier_deposee_le;
            statut = complet ? '<span class="badge bg-success">Complet</span>'
                             : '<span class="badge bg-warning text-dark">Incomplet</span>';
        }

        tbody.append(`
            <tr>
                <td><strong>${e.nom}</strong></td>
                ${operationsCochees.paiement ? `<td>${e.payer_carte_le ?? '❌'}</td><td>${e.montant_carte ?? '-'}</td>` : ''}
                ${operationsCochees.remise ? `<td>${e.carte_remise_le ?? '❌'}</td>` : ''}
                ${operationsCochees.rame ? `<td>${e.rame_papier_deposee_le ?? '❌'}</td>` : ''}
                <td>${statut}</td>
                <td>
                    <button class="btn btn-sm btn-danger btn-annuler" data-id="${e.id}">
                        Annuler
                    </button>
                </td>
            </tr>
        `);
    });

    $('#rapport-container').removeClass('d-none');

    // Ajouter l'événement pour le bouton Annuler
    $('.btn-annuler').off('click').on('click', function() {
        let idEleve = $(this).data('id');
        annulerOperation(idEleve, operationsCochees);
    });
    
}
function annulerOperation(idsEleves, operationsCochees) {
    if (!idsEleves || !idsEleves.length) return;
    
    if (!confirm("Voulez-vous vraiment annuler cette/ces opération(s) pour cet/ces élève(s) ?")) return;

    let payload = {
        ids: idsEleves,
        paiement: operationsCochees.paiement ? 1 : 0,
        remise: operationsCochees.remise ? 1 : 0,
        rame: operationsCochees.rame ? 1 : 0,
        _token: $('meta[name="csrf-token"]').attr('content') // CSRF pour Laravel
    };

    $.post('{{route("scholar.faire.payer.carte.annuler")}}', payload, function(res) {
        if (res.success) {
            alert('Opération(s) annulée(s) avec succès !');
            // Rafraîchir le rapport automatiquement
            afficherRapport(res.data);
        } else {
            alert('Impossible d’annuler l’opération.');
        }
    });
}


function chargerRapportNonEnOrdre(eleves, classes, ops) {
    $.ajax({
        url: '{{route("scholar.faire.payer.carte.elevenonenordre")}}',
        type: 'POST',
        data: {
            eleves: eleves,
            classes: classes,
            ops: ops,
            _token: '{{ csrf_token() }}'
        },
        success: function (res) {
            afficherRapport(res);
        }
    });
}




function formatElevee(eleve) {
    if (!eleve.id) return eleve.text;

    let a = eleve.attrs || {};

    return $(`
        <div class="d-flex align-items-center gap-2">
            <img src="${a.img ?? '/img/logo.png'}"
                 class="rounded-circle"
                 style="width:40px;height:40px;">
            <div>
                <strong>${eleve.text}</strong><br>
                <small class="text-muted">
                    ${a.classe ?? ''} | ${a.mat ?? ''}<br>
                    📞 ${a.tel ?? ''}
                </small>
            </div>
        </div>
    `);
}
function formatEleve(eleve) {
    if (!eleve.id) return eleve.text;

    let a = eleve.attrs || {};

    return $(`
        <div class="eleve-item">
            <div class="eleve-avatar">
                <img src="${a.img ?? '/img/logo.png'}">
            </div>
            <div class="eleve-info">
                <div class="eleve-nom">${eleve.text}</div>
                <div class="eleve-meta">
                    ${a.classe ?? ''} | ${a.mat ?? ''}
                </div>
                <div class="eleve-tel">
                    📞 ${a.tel ?? ''}
                </div>
            </div>
        </div>
    `);
}

function formatEleveSelection(eleve) {
    return eleve.text || eleve.id;
}
function getSelectedClasses() {
    return $('#liste-classes-select').val() || [];
}

function btn_enregistrer() {
    
        let eleves = $('#liste-eleves-select').val();
    
        if (!eleves || eleves.length === 0) {
            alert('Veuillez sélectionner au moins un élève');
            return;
        }
    
        let payload = {
            id_eleves: eleves,
            _token: '{{ csrf_token() }}'
        };
    
        if ($('#chk_paiement').is(':checked')) {
            if (!$('#payer_carte_le').val() || !$('#montant_carte').val()) {
                alert('Date et montant sont obligatoires pour le paiement');
                return;
            }
            payload.payer_carte_le = $('#payer_carte_le').val();
            payload.montant_carte  = $('#montant_carte').val();
        }
    
        if ($('#chk_remise').is(':checked')) {
            payload.carte_remise_le = $('#carte_remise_le').val();
        }
    
        if ($('#chk_rame').is(':checked')) {
            payload.rame_papier_deposee_le = $('#rame_papier_deposee_le').val();
        }
    
        $.post("{{ route('scholar.faire.payer.carte') }}", payload, function (res) {
            // alert(res.message);^
            
            let ids = getSelectedEleves();
            chargerRapport(ids); // 📊 affichage auto
    
            $('#liste-eleves-select').val(null).trigger('change');
        });
    
    }
$(document).ready(function () {

    $('#liste-eleves-select').select2({
        data: @json($items),
        placeholder: "Rechercher et sélectionner les élèves",
        allowClear: true,
        width: '100%',
        templateResult: formatEleve,
        templateSelection: formatEleveSelection
    });
    
    
    // Init select2 des classes
    $('#liste-classes-select').select2({
        placeholder: 'Choisir une ou plusieurs classes (ou laisser vide pour toutes)',
        allowClear: true,
        width: '100%',
        data: @json($classesSelect2),
    });

    
    $('#chk_paiement').on('change', function () {
        $('.paiement-fields').toggleClass('d-none', !this.checked);
    });
    
    $('#chk_remise').on('change', function () {
        $('.remise-fields').toggleClass('d-none', !this.checked);
    });
    
    $('#chk_rame').on('change', function () {
        $('.rame-fields').toggleClass('d-none', !this.checked);
    });
    
    
    $('#btn-enregistrer').on('click', btn_enregistrer);
    $('#btn-rapport').on('click', function () {
        let ids = getSelectedEleves();
    
        if (ids.length === 0) {
            alert('Veuillez sélectionner au moins un élève');
            return;
        }
    
        chargerRapport(ids);
    });
    
    $('#btn-non-en-ordre').on('click', function () {
    
        let eleves = getSelectedEleves();
        let classes = getSelectedClasses();
        let ops = getOperationsCochees();
    
        if (eleves.length === 0 && classes.length === 0) {
            alert('Veuillez sélectionner des élèves ou des classes');
            return;
        }
    
        if (!ops.paiement && !ops.remise && !ops.rame) {
            alert('Veuillez cocher au moins une opération');
            return;
        }
    
        chargerRapportNonEnOrdre(eleves, classes, ops);
    });
    
    $('#btn-annuler-tout').on('click', function() {
        let idsEleves = $('#liste-eleves-select').val(); // Tous les élèves sélectionnés
        if (!idsEleves || !idsEleves.length) {
            alert('Veuillez sélectionner au moins un élève.');
            return;
        }
    
        let operationsCochees = getOperationsCochees(); // Paiement / Remise / Rame
        if (!operationsCochees.paiement && !operationsCochees.remise && !operationsCochees.rame) {
            alert('Veuillez cocher au moins une opération à annuler.');
            return;
        }
    
        if (!confirm("Voulez-vous vraiment annuler les opérations cochées pour les élèves sélectionnés ?")) return;
    
        // Requête POST
        $.post('/annuler-cartes', {
            ids: idsEleves,
            paiement: operationsCochees.paiement ? 1 : 0,
            remise: operationsCochees.remise ? 1 : 0,
            rame: operationsCochees.rame ? 1 : 0,
            _token: $('meta[name="csrf-token"]').attr('content')
        }, function(res) {
            if (res.success) {
                alert('Opération(s) annulée(s) avec succès !');
                // Rafraîchir le rapport automatiquement
                afficherRapport(res.data);
            } else {
                alert('Impossible d’annuler l’opération.');
            }
        });
    });
    
    
    // Bouton "élèves en ordre"
    $('#btn-rapport-ordre').on('click', function() {
        let classesIds = $('#liste-classes-select').val(); // IDs des classes sélectionnées
        let operationsCochees = getOperationsCochees();
    
        if (!operationsCochees.paiement && !operationsCochees.remise && !operationsCochees.rame) {
            alert('Veuillez cocher au moins une opération à afficher.');
            return;
        }
    
        $.post('{{route("scholar.faire.payer.carte.eleveenordre")}}', {
            classes: classesIds, // si vide = toutes les classes
            paiement: operationsCochees.paiement ? 1 : 0,
            remise: operationsCochees.remise ? 1 : 0,
            rame: operationsCochees.rame ? 1 : 0,
            _token: $('meta[name="csrf-token"]').attr('content')
        }, function(res) {
            if (res.success) {
                afficherRapport(res.data);
            } else {
                alert('Impossible de générer le rapport.');
            }
        });
    });



});
</script>

@endsection