@extends('template')


@section('page-title') 
	Pointage de presence des élèves 
@endsection

@section('content')
<style>
	 
@media (max-width:1000px) {
		#content-actions {
			display: none;
		}
	 #modal-default{
		 display:block;
	 }
	 .main-header .navbar.navbar-static-top .row {
				margin: 0 10px;
		}
		#content-list .content-header {
				display: none;
		}
 }
</style>

<div class="row">
<div class="col-md-12 no-padding">

<div class="col-md-6 col-sm-6 col-xs-12">
  <div class="box box-primary">
	<div class="box-header with-border">
	  <h3 class="box-title">Placez votre carte face a la camera</h3>
	  <input style="width: 50px;margin-left: 20px;" placeholder="NUM-AGENT" id="input-id-agent-a-pointer"/>
	  <input type="button" value="POINTER" onclick="pointage_manuel()"/>
 
	  <div class="box-tools pull-right">
		<button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
		</button>
	  </div>
	</div>
	<!-- /.box-header -->
	<div class="box-body">
		<video id="preview" style="transform: scaleX(-1);width: 100%;"></video>
	  
		<div class="box-body box-profile">
		  <h3 class="profile-username text-center  noms-agent">Nom ELEVE</h3>

		  <p class="text-muted text-center fonction-agent" >CLASSE de l'ELEVE</p>

		  <ul style="margin: 0;" class="list-group list-group-unbordered">
			<li class="list-group-item">
			  <b>Date</b> <a class="pull-right jour-action" >{{date('d/m/Y')}}</a>
			</li>
			<li class="list-group-item">
			  <b classe="arriver-sortie">Present?</b> <a class="pull-right heure-action" >OUI</a>
			</li>
			<li style="text-align: center;font-size: 28;padding: 0;border-bottom: none;padding-top: 10px;" class="list-group-item">
			  <b id="span-progress"> 0 </b>
			</li>
		  </ul>
		</div>
	</div>
	<!-- /.box-body -->
	<div class="box-footer text-center">
	  <a href="javascript:void(0)" class="uppercase">Merci de marquer votre <span class='action-depart-arriver'>presence</span></a>
	</div>
	
	<!-- /.box-footer -->
  </div>
</div>
 
<div class="col-md-6 col-sm-6 col-xs-12">
  <div class="box box-primary">
	<div class="box-header with-border" style="text-align: center;">
	  <h3 class="box-title " >Image de: <b class='noms-agent'>Nom de l'élève reconnu</b></h3>

	  <div class="box-tools pull-right">
		<button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
		</button>
	  </div>
	</div>
	<!-- /.box-header -->
	<div class="box-body">
		
		<div class="col-md-10 col-md-offset-1 col-sm-12 col-xs-12">
			<div id="message-arriver" class="alert alert-info alert-dismissible" style='display:none'>
				<button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
				<h4><i class="icon fa fa-check"></i> Arrivee!</h4>
				Votre heure d’arrivée a été marquée.
			</div>
			<div id="message-sortie" class="alert alert-success alert-dismissible" style='display:none'>
				<button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
				<h4><i class="icon fa fa-check"></i> Sortie!</h4>
				Votre heure de sortie a été marquée.
			</div>
			<br/>
			
			<img class="img-responsive image-agent" src="{{asset('img/users25.png')}}" alt="Photo" style="border-radius: 30px;width: 100%">
		</div>
	</div>
	<!-- /.box-body -->
	<div class="box-footer text-center">
	  <a href="javascript:void(0)" class="uppercase">Merci de marquer votre presence</a>
	</div>
	<!-- /.box-footer -->
  </div>
</div>


        <div class="modal fade" id="modal-default">
          <div class="modal-dialog modal-lg" style="margin-top:20px">
              <p style="text-align: center;"><img style="margin-left: 4px;border-radius: 50%;margin: auto;width: 175px;border: solid aliceblue;background: #f4f0f0e3;" 
              src="{{\App\Config::getLogo()?asset('storage/ecole/logo_ecole/'.\App\Config::getLogo())
									:asset('img/email/pt-logo-1.jpeg')
									}}" alt="Masomwetu-logo"></p>
            <div class="modal-content row">
              <div class="modal-body col-sm-12" style="padding: 0;box-shadow: 7px 5px 9px #eadfdf;">
                  <div class="col-sm-12" style="padding: 0;border: solid 1px black;">
                      <div class="col-sm-5 col-xs-12" style="padding-left:0" >
        				<img class="img-responsive image-agent" id="id-image-agent" src="{{asset('img/users25.png')}}" alt="Photo" style="border-radius: 0px;width: 100%">
        			  </div>
                      <div class="col-sm-7 col-xs-12" style="padding:0">
                          <div class="modal-header" style="Ppadding: 4px;">
                            <h2 class="modal-title"><b class='noms-agent'>Nom de l'élève reconnu</b></h2>
                          </div>
            			  	<p style="font-size: 20px;margin: 6px;">POINTAGE DU <b> <a class="jour-action" >{{date('d/m/y')}}</a></b></p>
                          <table class='table table-condensed table-bordered table-striped' style="marginN-bottom: 3px;">
                              <tr><th></th><th>Pointée à</th><th>Prévue à</th><th style="">Constat</th></tr>
                              <tr><td>Arrivée</td><th style="font-size: 20px;" id="arrivee_po"></th><td id="arrivee_pr"></td><td id="arrivee_ap"></td></tr>
                              <tr><td>Sortie</td><th style="font-size: 20px;" id="sortie_po"></th><td id="sortie_pr"></td><td id="sortie_ap"></td></tr>
                              <tr><td>Durée</td><td colspan='3' id="arrivee_sortie_duree"></td></tr>
                          </table>
                          
        			  	<i class="arriver-sortie"></i> 
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"
                            style="position: absolute;top: 7px;right: 0;padding: 2px 6px;margin-right: 10px;color: red;border: solid 1px;border-radius: 6px;">
                          <span aria-hidden="true">&times;</span>
                        </button>
                     			
                      </div>
                  </div>
    				<form method="post" style="display:none" id="form-delete-pointage" action="{{route('personnel_presence.delete.pointeage')}}"> 
    				    @csrf
    				    <input type="hidden" name="personnel_id" id="pointage-personnel-id"/>
    				    <button type="submit" value="Supprimer Pointage" style="position: absolute;bottom: 5px;right:7px;color: red;border: solid 1px;border-radius: 4px;"><i class="fa fa-trash-o" style="position: ab;"></i></button>	
    				</form>
                  
                  <div class="overlay" style="position: absolute;height: 100%;width: 100%;top: 0;text-align: center;background: #ffffffd6;line-height: 400px;">
                    <i style="margin: auto;font-size: 55px;color: #0000ff96;" class="fa fa-refresh fa-spin"></i> <span style="font-size: 35px;"></span>
                  </div>
              </div>
            </div>
            <!-- /.modal-content -->
          </div>
          <!-- /.modal-dialog -->
        </div>

		

</div>
</div>
		
@endsection  


@section('script')
    <script>
    if ('speechSynthesis' in window) {
        //utterance = new SpeechSynthesisUtterance("Educative.io");
        //speechSynthesis.speak(utterance);
    }else{
        alert('Synthèse vocale no supportée!');
    }
    
    function getVoices() {
      let voices = speechSynthesis.getVoices();
      if(!voices.length){
        let utterance = new SpeechSynthesisUtterance("");
        speechSynthesis.speak(utterance);
        voices = speechSynthesis.getVoices();
      }
      return voices;
    }

    let speakDataa = new SpeechSynthesisUtterance();
    speakDataa.volume = 1; // From 0 to 1
    speakDataa.rate = 1; // From 0.1 to 10
    speakDataa.pitch = 2; // From 0 to 2
    speakDataa.lang = 'fr';
    speakDataa.voice = getVoices()[0];
    
    
	var barcode = '';
    var interval;
    function isNumeric(str) {
      if (typeof str != "string") return false // we only process strings!  
      return !isNaN(str) && // use type coercion to parse the _entirety_ of the string (`parseFloat` alone does not do this)...
             !isNaN(parseFloat(str)) // ...and ensure strings of whitespace fail
    }
    document.addEventListener('keydown', function(evt) {
        if (interval)
            clearInterval(interval);
        if (evt.code == 'Enter') {
            if (barcode){
                if(!isNumeric(barcode)){
                    //playNoAudio()
                    speakDataa.text = "ACTIVEZ LE MAJUSCULE  S'il vous plait.";
                    speechSynthesis.speak(speakDataa);
                    return alert("ACTIVEZ LE MAJUSCULE SVP");
                }pointer_agent(barcode)
            }
            //alert(barcode);
                // handleBarcode(barcode);
            barcode = '';
            return;
        }
        if (evt.key != 'Shift')
            barcode += evt.key;
        interval = setInterval(() => barcode = '', 20);
    });
	function postCallback(compteur){
		if(compteur==0){
			
			$('#span-progress').html('<span style=color:blue>Scannez une autre carte</span>');
			$('#modal-default').modal('hide');
		}
		else $('#span-progress').html(compteur+' secondes');
	}
	
    function detail_pointage_agent(data){
        // $("#image-agent").hide();
			var img = data.img?("{{asset('storage/mseleve/img')}}"+'/'+data.img):"{{asset('img/users25.png')}}";
			$(".image-agent").attr('src',img);
			// $("#image-agent").slideDown(500);
			$(".noms-agent").html(data.enfant.nom+' '+data.enfant.postnom+' '+data.enfant.prenom);
			
			/*if(data.tab_pointage){
			    var Tb = data.tab_pointage;
				$("#arrivee_sortie_duree").text(Tb.duree);
				$("#arrivee_pr").text(Tb.arrivee.hr_pr);
				$("#arrivee_po").text(Tb.arrivee.hr_po);
				$("#arrivee_ap").html(Tb.arrivee.retard==''?("En avance de "+Tb.arrivee.avance+""):("<span style='color:red'>En retard de "+Tb.arrivee.retard+"</span>"));
				
				$("#sortie_pr").text(Tb.sortie.hr_pr);
				$("#sortie_po").text(Tb.sortie.hr_po);
				$("#sortie_ap").html(Tb.sortie.retard==''?("<span style='color:red'>En avance de  "+Tb.sortie.avance+"</span>"):("En retard de "+Tb.sortie.retard+""));
			}*/
    }

	function findEleve(data){
		if(data.eleve){
			detail_pointage_agent(data);
			var t = data.heure.split(':');
            speakDataa.text = data.action+", "+(t[0][0]=='0'?t[0][1]:t[0])+" heure,  "+(t[1][0]=='0'?t[1][1]:t[1])+ " minutes  "+(t[2][0]=='0'?t[2][1]:t[2])+" seconde.";
            speechSynthesis.speak(speakDataa);
            //console.log(speakDataa.text);
			var msg = "";
			if(data.action!='sortie'){
			    $("#modal-default").addClass('arrivee').removeClass('sortie');
			}
			else{
			    $("#modal-default").addClass('sortie').removeClass('arrivee');
			}
			
			$(".arriver-sortie").text(data.message);
			// $(".heure-action").text(data.heure);
			$(".jour-action").text(data.jour);
			var fonc='',i = 0;
			for(i in data.agent.agents){
				var ag = data.agent.agents[i];
				fonc+= ag.mc_fonction.fonction+ (fonc?'/ ':'');
			}
			$(".fonction-agent").html(fonc);
			$(".overlay").hide()
			$('#modal-default').modal('show');
		}
		else {
			playNoAudio()
			$('#span-progress').html('<span style=color:red>CARTE INVALIDE</span>');
		}
		
		MyScan.postScan(5, postCallback)
	}
	
	function pointer_agent(id){
		console.log(id,"ch");
		$(".overlay").show()
        $(".overlay span").text("");
		$('#modal-default').modal('show');
		$('#span-progress').html('<span style=color:red>Chargement...</span>');
		// var t = id.split(' ');
		
		var action = '{{route("personnel_presence.pointer")}}';
		
		$.ajax({
			url : action,
			type: "POST",
			data : { 'id_personnel' : id ,'_token':'{{csrf_token()}}' } ,
			// processData: false,
			// contentType: false,
			// cache: false,
			success:function(data, textStatus, jqXHR){
			    console.log(data);
				if(data.result=='error' || !data.agent){
					//playNoAudio()
					$('#span-progress').html('<span style=color:red>'+data.message+'</span>');
					speakDataa.text = data.message;
                    speechSynthesis.speak(speakDataa);
            		$(".overlay span").text(data.message);
		            MyScan.postScan(5, postCallback)
				}
				else {
					console.log(data);
					findEleve(data)
				}
			},
			error: function(jqXHR, textStatus, errorThrown){
					alert("Une erreur s'est produite au serveur!")
					console.log("2:",jqXHR, textStatus, errorThrown);
			}
		});
	}
	
	function pointage_manuel(){
	    var id = $("#input-id-agent-a-pointer").val();
	    pointer_agent(id);
	}
	
	function get_pointage_agent(id){
		$(".overlay").show()
		$('#modal-default').modal('show');
	    var url = "{{route('personnel_presence.voir.pointage.agent')}}";
	     $.getJSON(url+"?personnel_id="+id, function(result){
            console.log(result);
            detail_pointage_agent(result)
    		$(".overlay").hide()
         });
	}
	$(function(){
	    $(".overlay").click(function(){
	        if(confirm("Voulez-vous ignorer le processus ?")){
	            $(".overlay").hide()
	            $('#modal-default').modal('hide');
	        }
	    })
	    $("#id-image-agent").click(function(){
	        if(confirm("Voulez-vous supprimer le pointage ?")){
	            $("#form-delete-pointage").show(5000)
	        }
	    })
	    $(document).on("click", ".lnk-get-pointage-agent", function(){
	        var id = $(this).attr('personnel_id');
	        $("#pointage-personnel-id").val(id);
	        get_pointage_agent(id);
	    })
		
		$("form#form-delete-pointage").submit(function (event) {
		    event.preventDefault();
            //var form = document.getElementById('form-delete-pointage'); 
            //var formData = new FormData(form); 
            
            if(!confirm("Voulez-vous réellement supprimer le pointage ?")){
                $('#form-delete-pointage').hide();
                return;
            }
            
            var formData = $('#form-delete-pointage').serialize();
            var action = $(this).attr("action");
            $(".overlay").show();
            $(".overlay span").text("SUPPRESSION EN COURS...");
            $.ajax({
              type: "POST",
              url: action,
              data: formData,
            }).done(function (data) {
		        $('#modal-default').modal('hide');
    		    $(".overlay").hide()
    		    $(".overlay span").text("");
                $('#form-delete-pointage').hide();
            });
        
            event.preventDefault();
        });
          

	})
	
</script>
    <script>
    	MyScan.scan('preview',pointer_agent);
    </script>
@endsection
