@extends('os.index')
@section('title')
@endsection
@section('page')
{{--
	<div class="row">
		<div class="col-md-3">			
			<!-- START WIDGET SLIDER -->
			<div class="widget widget-default widget-carousel">
				<div class="owl-carousel" id="owl-example">
					<div>                                    
						<div class="widget-title">Compte de Crédit</div>                                                                        
						<div class="widget-subtitle"></div>
						<div class="widget-int">{{$comptes->count()}}</div>
					</div>
					<div>                                    
						<div class="widget-title">Compte de Débit</div>
						<div class="widget-subtitle"> </div>
						<div class="widget-int">{{$comptes->count()}}</div>
					</div>
				</div>                            
				<div class="widget-controls">                                
					<a href="#" class="widget-control-right widget-remove" data-toggle="tooltip" data-placement="top" title="Remove Widget"><span class="fa fa-times"></span></a>
				</div>                             
			</div>         
			<!-- END WIDGET SLIDER -->
			
		</div>
		<div class="col-md-3">
			
			<!-- START WIDGET CLOCK -->
			<div class="widget widget-info widget-padding-sm">
				<div class="widget-big-int plugin-clock">00:00</div>                            
				<div class="widget-subtitle plugin-date">Loading...</div>
				<div class="widget-controls">                                
					<a href="#" class="widget-control-right widget-remove" data-toggle="tooltip" data-placement="left" title="Remove Widget"><span class="fa fa-times"></span></a>
				</div>                            
				<div class="widget-buttons widget-c3">
					<div class="col">
						<a href="#"><span class="fa fa-clock-o"></span></a>
					</div>
					<div class="col">
						<a href="#"><span class="fa fa-bell"></span></a>
					</div>
					<div class="col">
						<a href="#"><span class="fa fa-calendar"></span></a>
					</div>
				</div>                            
			</div>                        
			<!-- END WIDGET CLOCK -->
			
		</div>
	</div>
	--}}
	<!-- FORMULAIRE DES ORPERATION  --> 
	<div class="row">
		<div class="col-md-6">
			
			<div class="panel panel-default">
				<div class="panel-heading">
					<h3 class="panel-title"><strong>ENREGISTRER UN NOUVEAU COMPTE</strong> </h3>
					
					<ul class="panel-controls">
						<li><a href="#" class="panel-collapse"><span class="fa fa-angle-down"></span></a></li>
						<!--li><a href="#" class="panel-refresh"><span class="fa fa-refresh"></span></a></li>
						<li><a href="#" class="panel-remove"><span class="fa fa-times"></span></a></li-->
					</ul>                                   
				</div>
				<div class="panel-body">
					<div class="col-md-offset-2 col-md-8">
						<form enctype="multipart/form-data" class="form-horizontal" action="{{route('comptes.store')}}" method="POST">
							{{csrf_field()}}
							
							<input value="{{route('compta.codification')}}" style='display:none' checked type="checkbox" checked name="redirectTo">
							<input value="ok" style='display:none' checked type="checkbox" checked name="keep_the_formr">
							@include('Masomwetu.Comptabilite.comptes._form',['submitButtonText'=>'Enregistrer'])
							
							<button type="reset" class="btn btn-default">Annuler</button>	
						</form>
						
					</div>
				</div>
			</div>
		</div>
		<div class="col-md-6">
			
			<div class="panel panel-default">
				<div class="panel-heading">
					<h3 class="panel-title"><strong>ASSOCIER UN UTILISATEUR A UN SECTEUR</strong> </h3>
					
					<ul class="panel-controls">
						<li><a href="#" class="panel-collapse"><span class="fa fa-angle-down"></span></a></li>
						<!--li><a href="#" class="panel-refresh"><span class="fa fa-refresh"></span></a></li>
						<li><a href="#" class="panel-remove"><span class="fa fa-times"></span></a></li-->
					</ul>                                   
				</div>
				<div class="panel-body">
					<div class="col-md-offset-2 col-md-8">
						  <form class="form-horizontal"  action="{{route('cash.assoc.user.secteur')}}" method="post">
							  <div class="box-body"> @csrf()
								<div class="form-group">
								  <label for="inputEmail3" class="col-sm-2 control-label">Utilisateur</label>

								  <div class="col-sm-10">
									<select required  class="form-control select" data-live-search='true' name="user_id" >
										@foreach($users as $e)
										<option value="{{$e->id}}">{{$e->name}}</option>
										@endforeach
									</select>
								  </div>
								</div>
								<div class="form-group">
								  <label for="inputPassword3" class="col-sm-2 control-label">Secteurs</label>

								  <div class="col-sm-10">
									
									<select required name="cpt_secteur_id[]" multiple  class="form-control select"  data-live-search='true'>
										@foreach($cpt_secteurs as $e)
										<option value="{{$e->id}}">{{$e->nom}}</option>
										@endforeach
									</select>
								  </div>
								</div>
								<div class="form-group">
								  <label for="inputPassword3" class="col-sm-2 control-label"></label>

								  <div class="col-sm-10">
										<button type="submit" class="btn btn-info pull-right">Enregistrer</button>
							  
								  </div>
								</div>
								
							  </div>
							  <!-- /.box-footer -->
							</form>
						  
						
					</div>
					<div class=" col-md-12">
					<br/>
					<br/>
					<h3>LISTE DES COMPTABLES / SECTEUR</h3>
					@if($cptcomptables)
						<table class="table">
							<tr><th>N</th><th>UTILISATEUR</th><th>SECTEUR</th></tr>
							@foreach($cptcomptables as $c)
							<tr>
								<th>{{$loop->index+1}}</th>
								<th>{{$c->user->name}}</th>
								<th>{{$c->cptSecteur->nom}}</th>
							</tr>
							@endforeach
						</table>
					@endif
					</div>
				</div>
			</div>
		</div>
	</div>
	
	<div class="row">
		<div class="col-md-12">
			<div class="panel panel-default">
				<div class="panel-heading ui-draggable-handle">
					<h3 class="panel-title">CODIFICATION : LISTE DES COMPTES</h3>
				</div>
				
				<div class="panel-body panel-body-table" style="padding: 10px;"> 
					@include('mes_vues.Cash._liste_comptes')  
				</div>
			</div>
			
		</div>
	</div>   
	<script>
		document.getElementById('input-compte_id-id').setAttribute('class','select form-control');
		document.getElementById('input-compte_id-id').setAttribute('data-live-search','true');
		document.getElementById('input-imputation-id').parentElement.parentElement.style.display = 'none';
	</script>
	
	
@endsection

@section('script')

        <script type="text/javascript" src="{{asset('compta/js/plugins/datatables/jquery.dataTables.min.js')}}"></script>

@endsection
				