@extends('personnel_dossier.index')

@section('liste')

	<section class="content">
		
		<div class="col-md-4">
			@include('personnel_dossier._image_agent')
        </div>
		
		
		<div class="col-md-8">
            <div class="box-header with-border bg-green">
              <h3 class="box-title">Enregistrer nouvelles Etudes</h3>
            </div>
			<div class="box">
				<!-- /.box-header -->
				<div class="box-body">

					<!-- if there are creation errors, they will show here -->
					<ul>
					@foreach($errors->all() as $e)
						<li>{{ $e }}</li>
					@endforeach
					</ul>
					
					<form enctype="multipart/form-data" class="form-horizontal" action="{{route('niveauetudepersonnels.store')}}" method="POST">
						{{csrf_field()}}
						<div class="col-sm-offset-3 col-sm-9" style='display:none'>
							<div class="checkbox">
								<label style="color: #7d4982;font-weight: bold;font-style: italic;">
									<input value="ok" checked type="checkbox" name="keep_the_form">Rester sur le formulaire.
								</label>
							</div>
							<div class="checkbox">
								<label style="color: #7d4982;font-weight: bold;font-style: italic;">
									<input value="ok" checked type="checkbox" name="keep_form_data">Conserver les donnees du formulaire.
								</label>
							</div>
							@if(isset($personnel) and $personnel->id)
							<input name="redirectTo" value="{{route('personnel.dossier')}}/{{$personnel->id}}" type="hidden" />
							@endif
						</div>
						@include('Masomwetu.School.niveauetudepersonnels._form',['submitButtonText'=>'Enregistrer Etudes'])
					</form>
					 
					 @php display_flash(); @endphp
					
				</div>
				<!-- /.box-body -->
			</div>
        </div>
		
		
		
	</section>

@endsection

@section('script')
	<script>
	  $(function () {
		  @if( isset($niveauetudepersonnel) and $niveauetudepersonnel->personnel_id )
			  $('#input-personnel_id-id').parent().parent().hide();
		  @endif
		$('#datatable').DataTable()
		/* $('#datatable-agents').DataTable({
		  'paging'      : true,
		  'lengthChange': false,
		  'searching'   : false,
		  'ordering'    : true,
		  'info'        : true,
		  'autoWidth'   : false
		}) */
	  })
	</script>
@endsection