<?php
session_start();

// --------- LOGIN ---------
$USERNAME = "admin";
$PASSWORD = "123456";
$INDEXE = "https://ecoles.delardc.com/capture/eleve";
if(isset($_POST['logout'])){
    session_destroy();
    header("Location: $INDEXE");
    exit;
}

if(!isset($_SESSION['logged_in'])){
    $login_error = null;
    if($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['username'], $_POST['password'])){
        if($_POST['username'] === $USERNAME && $_POST['password'] === $PASSWORD){
            $_SESSION['logged_in'] = true;
            header("Location: $INDEXE");
            exit;
        } else {
            $login_error = "Identifiant ou mot de passe incorrect.";
        }
    }
    ?>
    <!DOCTYPE html>
    <html lang="fr">
    <head>
        <meta charset="UTF-8">
        <title>Login</title>
        <style>
            body { font-family: Arial, sans-serif; background:#f0f0f0; display:flex; justify-content:center; align-items:center; height:100vh; }
            .login-box { background:#fff; padding:20px; border-radius:8px; box-shadow:0 0 10px rgba(0,0,0,0.2); width:300px; }
            input { width:94%; padding:8px; margin:5px 0; border-radius:5px; border:1px solid #ccc; }
            button { width:100%; padding:8px; background:#4CAF50; color:white; border:none; border-radius:5px; cursor:pointer; margin-top:5px; }
            button:hover { background:#45a049; }
            .error { color:red; font-size:0.9em; }
        </style>
    </head>
    <body>
        <div class="login-box">
            <h2>Connexion</h2>
            <?php if($login_error) echo "<p class='error'>$login_error</p>"; ?>
            <form method="post">
                <input type="text" name="username" placeholder="Nom d'utilisateur" required>
                <input type="password" name="password" placeholder="Mot de passe" required>
                <button type="submit">Se connecter</button>
                @csrf
            </form>
        </div>
    </body>
    </html>
    <?php
    exit;
}


// --------- BASE DE DONNEES ---------
// $pdo = new PDO("mysql:host=localhost;dbname=collkono_masowetu_db;charset=utf8", "collkono", "tTfvm10iffiH");
$pdo = DB::connection()->getPdo();
// Upload photo AJAX
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] == 'upload_photo') {
    $id_eleve = $_POST['id_eleve'];
    $dossier = "storage/mseleve/img/";
    $ecole_id = \App\Config::getEcoleId();
    if(!$ecole_id)
		$ecole_id = session('ecole_id');
    if($_SESSION["T"] == "personnel")$dossier = "storage/personnel/image/";
    
    if (!is_dir($dossier)) mkdir($dossier, 0777, true);

    $fichier =  $ecole_id.'_'.$id_eleve . ".jpg";

    function saveAsJpg($sourcePath, $destPath, $maxWidth=500, $maxHeight=500){
        $info = getimagesize($sourcePath);
        if(!$info) return false;
        switch($info['mime']){
            case 'image/jpeg': $src=imagecreatefromjpeg($sourcePath); break;
            case 'image/png': $src=imagecreatefrompng($sourcePath); break;
            case 'image/gif': $src=imagecreatefromgif($sourcePath); break;
            default: return false;
        }
        $width=imagesx($src); $height=imagesy($src);
        $dst=imagecreatetruecolor($maxWidth,$maxHeight);
        imagecopyresampled($dst,$src,0,0,0,0,$maxWidth,$maxHeight,$width,$height);
        imagejpeg($dst,$destPath,90);
        imagedestroy($src); imagedestroy($dst);
        return true;
    }

    if(isset($_FILES['photo'])){
        saveAsJpg($_FILES['photo']['tmp_name'],$dossier.$fichier);
    }
    if(isset($_POST['webcam_image'])){
        $img = str_replace('data:image/png;base64,','',$_POST['webcam_image']);
        $img = str_replace(' ','+',$img);
        $data = base64_decode($img);
        $tmpFile = $dossier . "tmp_" . uniqid() . ".png";
        file_put_contents($tmpFile,$data);
        saveAsJpg($tmpFile,$dossier.$fichier);
        unlink($tmpFile);
    }
    
    
    if($_SESSION["T"] == "personnel")
        $stmt = $pdo->prepare("UPDATE personnels SET image=? WHERE id=?");
    else $stmt = $pdo->prepare("UPDATE bulletin_ms_eleves SET img=? WHERE id=?");
    
    $stmt->execute([$fichier,$id_eleve]);
    
    echo json_encode(["status"=>"success","img"=>$dossier.$fichier]);
    exit;
}

// récupérer classes et élèves
			$annee_id = \App\Config::getIdAnnee();
			$ecole_id = session('ecole_id');
$classes = $pdo->query("SELECT * FROM bulletin_ms_classes WHERE ecole_id=$ecole_id ORDER BY classe")->fetchAll(PDO::FETCH_OBJ);
$classe = $_GET['classe'] ?? $classes[0]->id;
$_SESSION["T"] = "eleves";
if($classe==-1){
    $eleves = $pdo->prepare("SELECT el.id,e.nom,e.postnom,e.prenom,e.genre,e.matricule,classe,img  
    FROM bulletin_ms_eleves el 
    INNER JOIN enfants e ON el.enfant_id=e.id 
    INNER JOIN bulletin_ms_classes cl ON cl.id=el.ms_classe_id 
    WHERE (img is null or img like '') and ms_annee_scolaire_id=$annee_id ORDER BY classe,e.nom,e.postnom,e.prenom,e.genre");
    $eleves->execute();
}
else if($classe==-2){
    $_SESSION["T"] = "personnel";
    $eleves = $pdo->prepare("SELECT p.id,p.noms nom,'' postnom,'' prenom,p.genre,nationalite matricule,'' classe,image img  
    FROM personnels p
    WHERE ecole_id=$ecole_id ORDER BY id");
    $eleves->execute();
}
else {
    $eleves = $pdo->prepare("SELECT el.id,e.nom,e.postnom,e.prenom,e.genre,e.matricule,classe,img  
    FROM bulletin_ms_eleves el 
    INNER JOIN enfants e ON el.enfant_id=e.id 
    INNER JOIN bulletin_ms_classes cl ON cl.id=el.ms_classe_id 
    WHERE ms_classe_id=? and ms_annee_scolaire_id=$annee_id ORDER BY e.nom,e.postnom,e.prenom,e.genre");
    $eleves->execute([$classe]);
}
$eleves = $eleves->fetchAll(PDO::FETCH_ASSOC);

?>
<!DOCTYPE html>
<html lang="fr">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<meta name="csrf-token" content="{{ csrf_token() }}">
<title>Capture Photo Élèves</title>
<link href="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.13/cropper.min.css" rel="stylesheet"/>
<style>
body { font-family: Arial,sans-serif; padding:10px; margin:0; }
h1 { font-size:1.5em; text-align:center; }
.grid { display:grid; grid-template-columns:repeat(auto-fit,minmax(220px,1fr)); gap:10px; }
.eleve { border:1px solid #ccc; border-radius:8px; padding:10px; text-align:center; background:#f9f9f9; position:relative; }
img { max-width:150px; max-height:150px; margin:auto; border-radius:6px; }
.button-group { display:flex; justify-content:center; gap:10px; margin-top:8px; flex-wrap:wrap; }
.button-group .btn { background:#4CAF50; color:white; padding:6px 12px; border:none; border-radius:5px; cursor:pointer; font-size:0.9em; transition:0.2s; }
.button-group .btn:hover { background:#45a049; }
.button-group label.btn { display:inline-block; cursor:pointer; }

.overlay {
  display:none; position:absolute; top:0; left:0; width:100%; height:100%;
  background:rgba(0,0,0,0.6); color:white; justify-content:center; align-items:center;
  flex-direction:column; border-radius:8px; z-index:10;
}
.spinner { border:5px solid rgba(255,255,255,0.3); border-top:5px solid #fff; border-radius:50%; width:40px; height:40px; animation:spin 1s linear infinite; }
@keyframes spin{100%{transform:rotate(360deg);}}

/* Webcam & cropper */
#cameraModal,#cropperModal { display:none; position:fixed; top:0; left:0; width:100%; height:100%; background:rgba(0,0,0,0.8); justify-content:center; align-items:center; z-index:9999; }
#cameraModal video { max-width:90vw; max-height:60vh; }
#cropperModal .container { background:#fff; padding:15px; border-radius:8px; width:95%; max-width:600px; display:flex; flex-direction:column; align-items:center; }
#cropperModal img { max-width:100%; max-height:400px; }
</style>
</head>
<body>

<h1>Capture des photos élèves</h1>
<form method="get">Classe :
<select name="classe" onchange="this.form.submit()">
<?php foreach($classes as $c): ?>
<option value="<?= $c->id ?>" <?= $c->id==$classe?'selected':'' ?>><?= $c->classe ?></option>
<?php endforeach; ?>
<option value="-1" <?= -1==$classe?'selected':'' ?>>ELEVES SANS IMAGE</option>
<option value="-2" <?= -2==$classe?'selected':'' ?>>TOUT LE PERSONNEL</option>
</select>
</form>

<div class="grid">
<?php $n=1; foreach($eleves as $e): ?>
<div class="eleve" id="eleve-<?= $e['id'] ?>">
  <p><b><?= ($n++).") ". $e['nom']." ".$e['postnom']." ".$e['prenom'] ?></b><br><?= $e['classe']." / ".$e['matricule']?></p>
  <img src="<?= $e['img']?asset(($_SESSION["T"] == "personnel"?'storage/personnel/image/':'storage/mseleve/img/').$e['img']):asset('no-photo.png')  ?>" id="photo-<?= $e['id'] ?>">
  <div class="button-group">
    <label class="btn">Choisir un fichier
      <input type="file" accept="image/*" onchange="uploadPhoto(<?= $e['id'] ?>, this.files[0])" style="display:none;">
    </label>
    <button type="button" class="btn" onclick="openCamera(<?= $e['id'] ?>)">📸 Webcam</button>
  </div>
  <!-- Dans chaque .eleve, overlay -->
    <div class="overlay" id="overlay-<?= $e['id'] ?>">
      <div class="spinner"></div>
      <p>Envoi... <span class="progress-text">0%</span></p>
      <div style="width:80%; background:#ddd; border-radius:4px; margin-top:5px;">
        <div class="progress-bar" style="width:0%; height:6px; background:#4CAF50; border-radius:4px;"></div>
      </div>
      <button onclick="cancelUpload(<?= $e['id'] ?>)" style="margin-top:10px;background:#f44336;padding:4px 8px;border:none;border-radius:4px;color:#fff;cursor:pointer;">❌ Annuler</button>
    </div>

</div>
<?php endforeach; ?>
</div>

<!-- Webcam -->
<div id="cameraModal">
  <div>
    <video id="video" autoplay></video><br>
    <button onclick="takePhoto()">Capturer</button>
    <button onclick="closeCamera()">Fermer</button>
    <button onclick="switchCamera()">🔄 Caméra</button>
    <canvas id="canvas" style="display:none;"></canvas>
  </div>
</div>

<!-- Cropper -->
<div id="cropperModal">
  <div class="container">
    <img id="cropperImage">
    <div style="margin-top:10px;">
      <button onclick="confirmCrop()">✅ Valider</button>
      <button onclick="closeCropper()">❌ Annuler</button>
    </div>
  </div>
</div>

<script src="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.13/cropper.min.js"></script>
<script>
let currentEleve = null;
let currentUpload = {};
let cropper=null;
let currentStream=null;
let facingMode='environment';
let csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute("content");

// Overlay individuel
function showOverlay(id,show){
  document.getElementById("overlay-"+id).style.display = show?'flex':'none';
  if(show) closeCropper(); // masque cropper si overlay actif
}

// Annulation d’un upload
function cancelUpload(id){
  if(currentUpload[id]){
    currentUpload[id].abort();
    delete currentUpload[id];
    showOverlay(id,false);
    alert("Envoi annulé pour l'élève "+id);
  }
}

// Upload fichier
function uploadPhoto(id,file){
  if(!file) return;
  if(!confirm("Voulez-vous vraiment utiliser ce fichier ?")){
    document.querySelector(`#eleve-${id} input[type=file]`).value="";
    return;
  }
  currentEleve=id;
  openCropper(null,file);
}

// Webcam
async function openCamera(id){
  currentEleve=id;
  await startCamera();
  document.getElementById("cameraModal").style.display="flex";
}
async function startCamera(){
  if(currentStream) stopMediaTracks(currentStream);
  try {
    currentStream=await navigator.mediaDevices.getUserMedia({video:{facingMode:{exact:facingMode}}});
  } catch(e){
    currentStream=await navigator.mediaDevices.getUserMedia({video:{facingMode}});
  }
  document.getElementById("video").srcObject=currentStream;
}
function switchCamera(){
  facingMode=(facingMode==='environment')?'user':'environment';
  startCamera();
}
function stopMediaTracks(stream){ stream.getTracks().forEach(t=>t.stop()); }
function closeCamera(){
  document.getElementById("cameraModal").style.display="none";
  if(currentStream) stopMediaTracks(currentStream);
  currentStream=null;
}
function takePhoto(){
  let video=document.getElementById("video");
  let canvas=document.getElementById("canvas");
  let ctx=canvas.getContext("2d");
  canvas.width=video.videoWidth;
  canvas.height=video.videoHeight;
  ctx.drawImage(video,0,0);
  let dataURL=canvas.toDataURL("image/png");
  closeCamera();
  openCropper(dataURL,null);
}

// Cropper
function openCropper(data,file){
  let img=document.getElementById("cropperImage");
  if(file){
    let reader=new FileReader();
    reader.onload=e=>{img.src=e.target.result;showCropper();};
    reader.readAsDataURL(file);
  } else if(data){ img.src=data; showCropper(); }
}
function showCropper(){
  document.getElementById("cropperModal").style.display="flex";
  if(cropper) cropper.destroy();
  cropper=new Cropper(document.getElementById("cropperImage"),{aspectRatio:1/1,viewMode:1,autoCropArea:1});
}
function closeCropper(){
  document.getElementById("cropperModal").style.display="none";
  if(cropper) cropper.destroy();
}

function confirmCrop(){
  let canvas=cropper.getCroppedCanvas({width:400,height:500});
  canvas.toBlob(function(blob){
    const eleveId = currentEleve;
    let formData=new FormData();
    formData.append("_token",csrfToken);
    formData.append("action","upload_photo");
    formData.append("id_eleve",eleveId);
    formData.append("photo",blob,"photo.jpg");

    let overlay = document.getElementById("overlay-"+eleveId);
    let progressBar = overlay.querySelector(".progress-bar");
    let progressText = overlay.querySelector(".progress-text");

    let xhr=new XMLHttpRequest();
    xhr.open("POST","");
    currentUpload[eleveId]=xhr;

    // afficher overlay
    overlay.style.display='flex';
    progressBar.style.width='0%';
    progressText.innerText='0%';

    xhr.upload.onprogress=function(e){
      if(e.lengthComputable){
        let percent=Math.round(e.loaded/e.total*100);
        progressBar.style.width=percent+'%';
        progressText.innerText=percent+'%';
      }
    };
    closeCropper(); 

    xhr.onload=function(){
      overlay.style.display='none';
      if(xhr.status===200){
        let data=JSON.parse(xhr.responseText);
        if(data.status==="success"){
          document.getElementById("photo-"+eleveId).src='<?=asset("")?>/'+data.img+"?t="+Date.now();
        }
      }
      delete currentUpload[eleveId];
    };

    xhr.onerror=function(){
      overlay.style.display='none';
      delete currentUpload[eleveId];
      alert("Erreur réseau");
    };

    xhr.send(formData);
  },"image/jpeg",0.9);
}

</script>
</body>
</html>