<?php
session_start();

// --------- LOGIN ---------
$USERNAME = "admin";
$PASSWORD = "123456";
$INDEXE = "https://ecoles.delardc.com/api/gst-carte";
if(isset($_POST['logout'])){
    session_destroy();
    header("Location: $INDEXE");
    exit;
}

if(!isset($_SESSION['logged_in'])){
    $login_error = null;
    if($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['username'], $_POST['password'])){
        if($_POST['username'] === $USERNAME && $_POST['password'] === $PASSWORD){
            $_SESSION['logged_in'] = true;
            header("Location: $INDEXE");
            exit;
        } else {
            $login_error = "Identifiant ou mot de passe incorrect.";
        }
    }
    ?>
    <!DOCTYPE html>
    <html lang="fr">
    <head>
        <meta charset="UTF-8">
        <title>Login</title>
        <style>
            body { font-family: Arial, sans-serif; background:#f0f0f0; display:flex; justify-content:center; align-items:center; height:100vh; }
            .login-box { background:#fff; padding:20px; border-radius:8px; box-shadow:0 0 10px rgba(0,0,0,0.2); width:300px; }
            input { width:94%; padding:8px; margin:5px 0; border-radius:5px; border:1px solid #ccc; }
            button { width:100%; padding:8px; background:#4CAF50; color:white; border:none; border-radius:5px; cursor:pointer; margin-top:5px; }
            button:hover { background:#45a049; }
            .error { color:red; font-size:0.9em; }
        </style>
    </head>
    <body>
        <div class="login-box">
            <h2>Connexion</h2>
            <?php if($login_error) echo "<p class='error'>$login_error</p>"; ?>
            <form method="post">
                <input type="text" name="username" placeholder="Nom d'utilisateur" required>
                <input type="password" name="password" placeholder="Mot de passe" required>
                <button type="submit">Se connecter</button>
                @csrf
            </form>
        </div>
    </body>
    </html>
    <?php
    exit;
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8" />
    <title>Gestion des Paiements & Cartes</title>

    <!-- JQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <!-- Select2 -->
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

    <!-- DataTable -->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.4/css/jquery.dataTables.min.css">
    <script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>

    <!-- Style -->
    <style>
        body {
            font-family: Arial, sans-serif;
            padding: 20px;
            background: #f7f7f7;
        }

        h2 { margin-bottom: 15px; }

        .section {
            background: white;
            border: 1px solid #ddd;
            padding: 15px;
            margin-bottom: 20px;
            border-radius: 6px;
        }

        .layout {
            display: flex;
            gap: 20px;
        }

        .col {
            flex: 1;
        }

        .btn {
            padding: 8px 15px;
            border: none;
            background: #007bff;
            color: white;
            cursor: pointer;
            border-radius: 4px;
            margin-right: 8px;
            margin-top: 8px;
        }

        .btn-secondary {
            background: #6c757d;
        }
        .overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(15, 23, 42, 0.5);
            display: none; /* caché par défaut */
            align-items: center;
            justify-content: center;
            z-index: 9999;
        }
        
        .spinner {
            border: 6px solid #f3f3f3;
            border-top: 6px solid #0ea5a4; /* couleur du spinner */
            border-radius: 50%;
            width: 50px;
            height: 50px;
            animation: spin 1s linear infinite;
        }
        
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

    </style>
</head>
<body>

    <h2>Gestion Paiements & Cartes Scolaires</h2>

    <!-- ----------------------------- -->
    <!--        STATISTIQUES           -->
    <!-- ----------------------------- -->
    <div class="section">
        <h3>Statistiques</h3>
        <p>Total payé : <span id="totalPaye">0</span> FC</p>
        <p>Payé aujourd'hui : <span id="payeAuj">0</span> FC</p>

        <label>Voir montant à une date :</label>
        <input type="date" id="dateFiltre" />

        <p>Montant à cette date : <span id="montantDate">0</span> FC</p>
    </div>

    <!-- ----------------------------- -->
    <!--     SELECT MULTIPLE + FORM    -->
    <!-- ----------------------------- -->
    <div class="layout">

        <div class="col section">
            <h3>Sélection des élèves</h3>
            <select id="selectEleves" multiple style="width:100%"></select>
        </div>

        <div class="col section">
            <h3>Actions rapides</h3>

            <label>Date :</label>
            <input type="date" id="dateAction" />

            <br><br>

            <label>Montant :</label>
            <input type="number" id="montantAction" />

            <br><br>
            <input type="checkbox" id="forceModification" title="Forcer les modification">
            <button class="btn" onclick="enregistrerPaiement()">Enregistrer paiement</button>
            <button class="btn" onclick="enregistrerImpression()">Impression carte</button>
            <button class="btn" onclick="enregistrerRemise()">Remise carte</button>
            <div id="message-retour"></div>
        </div>
    </div>
    <div class="overlay" id="loadingOverlay">
        <div class="spinner" style="margin: auto;margin-top: 20%;"></div>
    </div>

    <!-- ----------------------------- -->
    <!--            FILTRES            -->
    <!-- ----------------------------- -->
    <div class="section">
        <h3>Filtres d'affichage</h3>

        <button class="btn-secondary" onclick="table.ajax.url('/api/gst-carte/eleves?f=non_ordre').load()">Non en ordre</button>
        <button class="btn-secondary" onclick="table.ajax.url('/api/gst-carte/eleves?f=en_ordre').load()">En ordre</button>
        <button class="btn-secondary" onclick="table.ajax.url('/api/gst-carte/eleves?f=imprimee').load()">Carte imprimée</button>
        <button class="btn-secondary" onclick="table.ajax.url('/api/gst-carte/eleves?f=remise').load()">Carte remise</button>
        <button class="btn-secondary" onclick="table.ajax.url('/api/gst-carte/eleves?f=paye_pas_carte').load()">Payé sans carte</button>
        <button class="btn-secondary" onclick="table.ajax.url('/api/gst-carte/eleves').load()">Tous</button>
    </div>

    <!-- ----------------------------- -->
    <!--            TABLEAU            -->
    <!-- ----------------------------- -->
    <div class="section">
        <h3>Liste des élèves</h3>

        <table id="tableEleves" class="display">
            <thead>
                <tr>
                    <th>Nom</th>
                    <th>Classe</th>
                    <th>Montant payé</th>
                    <th>Payer carte le</th>
                    <th>Imprimée le</th>
                    <th>Remise le</th>
                    <th>N°</th>
                </tr>
            </thead>
        </table>
    </div>

<script>

    let table;

    // --------------------------------------
    //           CHARGER SELECT2
    // --------------------------------------
    function chargerSelectEleves() {
        $('#selectEleves').select2({
            placeholder: 'Choisir des élèves',
            ajax: {
                url: '/api/gst-carte/eleves-select2',
                dataType: 'json',
                delay: 250,
                data: function(params) {
                    return { q: params.term }; // recherche par texte
                },
                processResults: function(data) {
                    return { results: data.results };
                },
                cache: true
            },
            width: '100%'
        });

    }

    // --------------------------------------
    //           DATATABLE AJAX
    // --------------------------------------
    function chargerDataTable() {
        table = $('#tableEleves').DataTable({
            ajax: {
                url: '/api/gst-carte/eleves-table',
                dataSrc: ''
            },
            columns: [
                { data: 'nom' },
                { data: 'classe' },
                { data: 'montant_carte' },
                { data: 'payer_carte_le' },
                { data: 'carte_imprimee_le' },
                { data: 'carte_remise_le' },
                { data: 'numero' }
            ]
        });

    }

    // --------------------------------------
    //        ACTIONS PAYEMENT / CARTES
    // --------------------------------------
    function traiterUpdate(type) {
        $('#message-retour').html('').fadeIn();
        const ids = $('#selectEleves').val();
    
        if (!ids || ids.length === 0) {
            alert("Sélectionner au moins un élève");
            return;
        }
    
        const force = $('#forceModification').is(':checked');
    
        // afficher l'overlay
        $('#loadingOverlay').fadeIn();
    
        $.post('/api/gst-carte/updateCarte', {
            type: type,
            ids: ids,
            date: $('#dateAction').val(),
            montant: $('#montantAction').val(),
            force: force
        }, function(response) {
            table.ajax.reload(null, false);
            chargerStats();
    
            if (response && response.messages && response.messages.length > 0) {
                let html = '<ul>';
                response.messages.forEach(msg => {
                    html += `<li>${msg}</li>`;
                });
                html += '</ul>';
                $('#message-retour').html(html).fadeIn();
            }
    
        }).fail(function(xhr){
            let messages = [];
            if (xhr.responseJSON) {
                if (xhr.responseJSON.messages) {
                    messages = xhr.responseJSON.messages;
                } else if (xhr.responseJSON.error) {
                    messages = [xhr.responseJSON.error];
                }
            } else {
                messages = ['Erreur serveur'];
            }
    
            let html = '<ul style="color:red">';
            messages.forEach(msg => {
                html += `<li>${msg}</li>`;
            });
            html += '</ul>';
            $('#message-retour').html(html).fadeIn();
        }).always(function() {
            // masquer l'overlay après retour serveur
            $('#loadingOverlay').fadeOut();
        });
    }


    function enregistrerPaiement(){ traiterUpdate('payer'); }
    function enregistrerImpression(){ traiterUpdate('imprimer'); }
    function enregistrerRemise(){ traiterUpdate('remise'); }

    // --------------------------------------
    //              STATISTIQUES
    // --------------------------------------
    function chargerStats() {
        $.get("/api/gst-carte/stats", function(res){
            $('#totalPaye').text(res.total);
            $('#payeAuj').text(res.aujourdhui);
        });
    }

    $('#dateFiltre').on("input", function() {
        let d = this.value;
        if (!d) return;

        $.get("/api/gst-carte/montantParDate?d=" + d, function(res){
            $('#montantDate').text(res.montant);
        });
    });

    // --------------------------------------
    //              INIT
    // --------------------------------------
    $(document).ready(function(){
        chargerDataTable();
        chargerSelectEleves();
        chargerStats();
    });

</script>

</body>
</html>