@php 
$tables = \DB::select('SHOW TABLES');
$tables = array_map('current', $tables);
@endphp
<!DOCTYPE html> 
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Console SQL - Laravel</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.13/codemirror.min.css">
    <style>
        #sql-editor { height: 150px; }
        .history-box { max-height: 180px; overflow-y: auto; }
        .history-item { display: flex; justify-content: space-between; align-items: center; padding: 4px 0; }
        .copy-icon { cursor: pointer; color: #007bff; margin-left: 10px; }
        .copy-icon:hover { color: #0056b3; }
    </style>
</head>
<body class="p-4 bg-light">
    <div class="container bg-white shadow p-4 rounded">
        <h3 class="mb-3">🛠️ Console SQL (Laravel 5.8)</h3>
        @if($errors->any())
            <div class="alert alert-danger">
                <strong>Erreur :</strong>
                <ul class="mb-0">
                    @foreach($errors->all() as $err)
                        <li>{{ $err }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <form id="sqlForm" method="POST" action="{{ route('sql.execute') }}">
            @csrf
            <div class="form-group">
                <label for="sql">Requête SQL :</label>
                <textarea id="sql" name="sql" class="form-control">{{ old('sql', session('last_query', '')) }}</textarea>
                <input type="hidden" name="page" value="1" id="pageInput">
            </div>

            <div class="form-group form-check">
                <input type="checkbox" class="form-check-input" id="allowDanger" name="allowDanger">
                <label class="form-check-label" for="allowDanger">Autoriser temporairement les requêtes dangereuses</label>
            </div>

            <button type="submit" class="btn btn-primary">▶️ Exécuter</button>
            <a href="#" class="btn btn-secondary" id="exportCsvBtn" style="display:none">📥 Export CSV</a>
        </form>

        <hr>

        @if(session('results'))
            <h5>Résultats :</h5>
            <div class="table-responsive">
                <table class="table table-sm table-bordered">
                    <thead class="thead-light">
                        <tr>
                            @foreach(array_keys(session('results')[0] ?? []) as $col)
                                <th>{{ $col }}</th>
                            @endforeach
                        </tr>
                    </thead>
                    <tbody>
                        @foreach(session('results') as $row)
                            <tr>
                                @foreach($row as $val)
                                    <td>{{ $val }}</td>
                                @endforeach
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            @if(session('paginate'))
                <nav><ul class="pagination">
                    @for($i = 1; $i <= session('paginate.total_pages'); $i++)
                        <li class="page-item {{ session('paginate.current') == $i ? 'active' : '' }}">
                            <a class="page-link" href="#" onclick="goToPage({{ $i }})">{{ $i }}</a>
                        </li>
                    @endfor
                </ul></nav>
            @endif

            <script>
                document.getElementById('exportCsvBtn').style.display = 'inline-block';
                document.getElementById('exportCsvBtn').onclick = function () {
                    window.location.href = "{{ route('sql.export') }}";
                };
            </script>
        @endif

        <hr>
        <h5>📋 Explorer une table</h5>
        <div class="form-inline mb-3">
            <select id="tableName" class="form-control mr-2">
                <option value="">-- Sélectionner une table --</option>
                @foreach($tables ?? [] as $t)
                    <option value="{{ $t }}">{{ $t }}</option>
                @endforeach
            </select>

            <button class="btn btn-info mr-2" onclick="loadStructure()">Structure</button>
            <button class="btn btn-dark mr-2" onclick="loadCreate()">Création SQL</button>
            <button class="btn btn-success" onclick="loadData()">📊 Afficher données</button>
        </div>

        <pre id="structure" class="bg-light p-3 rounded"></pre>

        <hr>
        <h5>🕘 Historique des requêtes</h5>
        <div class="history-box border p-2 bg-white rounded">
            <ul class="list-unstyled mb-0">
                @foreach(session('history', []) as $query)
                    <li class="history-item">
                        <code>{{ $query }}</code>
                        <span class="copy-icon" title="Recopier" onclick="copyToEditor(`{{ addslashes($query) }}`)">📋</span>
                    </li>
                @endforeach
            </ul>
        </div>
    </div>

    <!-- Scripts -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.13/codemirror.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.13/mode/sql/sql.min.js"></script>
    <script>
        // Initialisation CodeMirror
        let editor = CodeMirror.fromTextArea(document.getElementById('sql'), {
            mode: "text/x-sql",
            lineNumbers: true,
        });

        // Conserve la requête dans le champ après soumission
        document.getElementById('sqlForm').addEventListener('submit', function() {
            document.querySelector('textarea[name="sql"]').value = editor.getValue();
        });

        function goToPage(page) {
            document.getElementById('pageInput').value = page;
            document.getElementById('sqlForm').submit();
        }

        function copyToEditor(query) {
            editor.setValue(query);
            editor.focus();
        }

        function loadStructure() {
            const name = document.getElementById('tableName').value;
            if (!name) return alert("Veuillez choisir une table !");
            fetch('/sql/structure/' + name)
                .then(res => res.text())
                .then(txt => document.getElementById('structure').innerText = txt);
        }

        function loadCreate() {
            const name = document.getElementById('tableName').value;
            if (!name) return alert("Veuillez choisir une table !");
            fetch('/sql/create/' + name)
                .then(res => res.text())
                .then(txt => document.getElementById('structure').innerText = txt);
        }

        function loadData() {
            const name = document.getElementById('tableName').value;
            if (!name) return alert("Veuillez choisir une table !");
            editor.setValue("SELECT * FROM " + name + " LIMIT 50;");
            editor.focus();
        }
    </script>
</body>
</html>
